/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.paygate;

import io.github.lightman314.lightmanscurrency.blockentity.PaygateBlockEntity;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageSetPaygateTicket {
    private BlockPos pos;
    private UUID ticketID;

    public MessageSetPaygateTicket(BlockPos pos, UUID ticketID) {
        this.pos = pos;
        this.ticketID = ticketID;
    }

    public static void encode(MessageSetPaygateTicket message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130077_(message.ticketID);
    }

    public static MessageSetPaygateTicket decode(FriendlyByteBuf buffer) {
        return new MessageSetPaygateTicket(buffer.m_130135_(), buffer.m_130259_());
    }

    public static void handle(MessageSetPaygateTicket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) != null && blockEntity instanceof PaygateBlockEntity) {
                PaygateBlockEntity paygateEntity = (PaygateBlockEntity)blockEntity;
                paygateEntity.SetTicketID(message.ticketID);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

