/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.ticket_machine;

import io.github.lightman314.lightmanscurrency.menus.TicketMachineMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageCraftTicket {
    private boolean fullStack;

    public MessageCraftTicket(boolean fullStack) {
        this.fullStack = fullStack;
    }

    public static void encode(MessageCraftTicket message, FriendlyByteBuf buffer) {
        buffer.writeBoolean(message.fullStack);
    }

    public static MessageCraftTicket decode(FriendlyByteBuf buffer) {
        return new MessageCraftTicket(buffer.readBoolean());
    }

    public static void handle(MessageCraftTicket message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && player.f_36096_ instanceof TicketMachineMenu) {
                TicketMachineMenu menu = (TicketMachineMenu)player.f_36096_;
                menu.craftTickets(message.fullStack);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

