/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IPermissions;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageAddOrRemoveAlly {
    BlockPos pos;
    boolean isAllyAdd;
    String ally;

    public MessageAddOrRemoveAlly(BlockPos pos, boolean isAllyAdd, String ally) {
        this.pos = pos;
        this.isAllyAdd = isAllyAdd;
        this.ally = ally;
    }

    public static void encode(MessageAddOrRemoveAlly message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeBoolean(message.isAllyAdd);
        buffer.m_130070_(message.ally);
    }

    public static MessageAddOrRemoveAlly decode(FriendlyByteBuf buffer) {
        return new MessageAddOrRemoveAlly(buffer.m_130135_(), buffer.readBoolean(), buffer.m_130277_());
    }

    public static void handle(MessageAddOrRemoveAlly message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) instanceof IPermissions) {
                IPermissions permissionEntity = (IPermissions)blockEntity;
                if (message.isAllyAdd) {
                    if (!permissionEntity.getAllies().contains(message.ally)) {
                        permissionEntity.getAllies().add(message.ally);
                        permissionEntity.markAlliesDirty();
                    }
                } else if (permissionEntity.getAllies().contains(message.ally)) {
                    permissionEntity.getAllies().remove(message.ally);
                    permissionEntity.markAlliesDirty();
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

