/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.proxy;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.BlockItemSet;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientEvents;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.InventoryWalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemEditScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemTraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemTraderScreenCR;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ItemTraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MintScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.PaygateScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TicketMachineScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.UniversalItemTraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.UniversalItemTraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.FreezerTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModContainers;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.integration.Curios;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TimedSale;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fmlclient.registry.ClientRegistry;

public class ClientProxy
extends CommonProxy {
    boolean openTerminal = false;
    boolean openVanillaInventory = false;
    Player player = null;
    private long timeOffset = 0L;

    @Override
    public void setupClient() {
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.DISPLAY_CASE.block, (RenderType)RenderType.m_110463_());
        ClientProxy.setRenderLayerForSet(ModBlocks.VENDING_MACHINE1, RenderType.m_110463_());
        ClientProxy.setRenderLayerForSet(ModBlocks.VENDING_MACHINE2, RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.ARMOR_DISPLAY.block, (RenderType)RenderType.m_110463_());
        MenuScreens.m_96206_(ModContainers.INVENTORY_WALLET, InventoryWalletScreen::new);
        MenuScreens.m_96206_(ModContainers.ATM, ATMScreen::new);
        MenuScreens.m_96206_(ModContainers.MINT, MintScreen::new);
        MenuScreens.m_96206_(ModContainers.ITEMTRADER, ItemTraderScreen::new);
        MenuScreens.m_96206_(ModContainers.ITEMTRADERSTORAGE, ItemTraderStorageScreen::new);
        MenuScreens.m_96206_(ModContainers.ITEMTRADERCR, ItemTraderScreenCR::new);
        MenuScreens.m_96206_(ModContainers.ITEM_EDIT, ItemEditScreen::new);
        MenuScreens.m_96206_(ModContainers.UNIVERSAL_ITEM_EDIT, ItemEditScreen::new);
        MenuScreens.m_96206_(ModContainers.WALLET, WalletScreen::new);
        MenuScreens.m_96206_(ModContainers.PAYGATE, PaygateScreen::new);
        MenuScreens.m_96206_(ModContainers.TICKET_MACHINE, TicketMachineScreen::new);
        MenuScreens.m_96206_(ModContainers.UNIVERSAL_ITEMTRADER, UniversalItemTraderScreen::new);
        MenuScreens.m_96206_(ModContainers.UNIVERSAL_ITEMTRADERSTORAGE, UniversalItemTraderStorageScreen::new);
        BlockEntityRenderers.m_173590_(ModBlockEntities.ITEM_TRADER, ItemTraderBlockEntityRenderer::new);
        BlockEntityRenderers.m_173590_(ModBlockEntities.FREEZER_TRADER, FreezerTraderBlockEntityRenderer::new);
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerWhitelist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerBlacklist()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerTradeLimit()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new PlayerDiscounts()));
        TradeRuleScreen.RegisterTradeRule((Supplier<TradeRule>)((Supplier)() -> new TimedSale()));
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        ClientRegistry.registerKeyBinding((KeyMapping)ClientEvents.KEY_WALLET);
        if (LightmansCurrency.isCuriosLoaded()) {
            Curios.RegisterCuriosRenderers();
        }
    }

    private static void setRenderLayerForSet(BlockItemSet<?> blockItemSet, RenderType type) {
        blockItemSet.getAll().forEach(blockItemPair -> ItemBlockRenderTypes.setRenderLayer((Block)blockItemPair.block, (RenderType)type));
    }

    @Override
    public void initializeTraders(CompoundTag compound) {
        if (compound.m_128425_("Traders", 9)) {
            ArrayList<UniversalTraderData> traders = new ArrayList<UniversalTraderData>();
            ListTag traderList = compound.m_128437_("Traders", 10);
            traderList.forEach(nbt -> traders.add(TradingOffice.Deserialize((CompoundTag)nbt)));
            ClientTradingOffice.initData(traders);
        }
    }

    @Override
    public void updateTrader(CompoundTag compound) {
        ClientTradingOffice.updateTrader(compound);
    }

    @Override
    public void removeTrader(UUID traderID) {
        ClientTradingOffice.removeTrader(traderID);
    }

    @Override
    public void openTerminalScreen(Player player) {
        this.openTerminal = true;
        this.player = player;
    }

    @Override
    public void openInventoryScreen(Player player) {
        this.openVanillaInventory = true;
        this.player = player;
    }

    @Override
    public long getTimeDesync() {
        return this.timeOffset;
    }

    @Override
    public void setTimeDesync(long serverTime) {
        this.timeOffset = serverTime - System.currentTimeMillis();
        this.timeOffset = this.timeOffset / 1000L * 1000L;
        if (this.timeOffset < 10000L) {
            this.timeOffset = 0L;
        }
    }

    @Override
    public void loadAdminPlayers(List<UUID> serverAdminList) {
        TradingOffice.loadAdminPlayers(serverAdminList);
    }

    public void registerItemColors(ColorHandlerEvent.Item event) {
        LightmansCurrency.LogInfo("Registering Item Colors for Ticket Items");
        event.getItemColors().m_92689_((ItemColor)new TicketColor(), new ItemLike[]{ModItems.TICKET, ModItems.TICKET_MASTER});
    }

    @SubscribeEvent
    public void openTerminalScreenOnRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.player != null) {
            if (this.openTerminal) {
                this.openTerminal = false;
                Minecraft.m_91087_().m_91152_((Screen)new TradingTerminalScreen(this.player));
            } else if (this.openVanillaInventory) {
                this.openVanillaInventory = false;
                Minecraft.m_91087_().m_91152_((Screen)new InventoryScreen(this.player));
            }
        }
    }
}

