/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ItemTradeData
extends TradeData {
    public static final int MAX_CUSTOMNAME_LENGTH = 30;
    ItemTradeRestriction restriction = ItemTradeRestriction.NONE;
    ItemStack sellItem = ItemStack.f_41583_;
    ItemStack barterItem = ItemStack.f_41583_;
    ItemTradeType tradeType = ItemTradeType.SALE;
    String customName = "";

    public static int MaxTradeTypeStringLength() {
        int length = 0;
        for (ItemTradeType value : ItemTradeType.values()) {
            int thisLength = value.name().length();
            if (thisLength <= length) continue;
            length = thisLength;
        }
        return length;
    }

    public ItemStack getSellItem() {
        return this.restriction.modifySellItem(this.sellItem.m_41777_(), this);
    }

    public ItemStack getBarterItem() {
        return this.barterItem.m_41777_();
    }

    public void setSellItem(ItemStack itemStack) {
        if (this.restriction.allowSellItem(itemStack) || itemStack.m_41619_()) {
            this.sellItem = this.restriction.filterSellItem(itemStack).m_41777_();
        }
    }

    public void setBarterItem(ItemStack itemStack) {
        this.barterItem = itemStack.m_41777_();
    }

    public boolean hasCustomName() {
        return !this.customName.isEmpty();
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        switch (this.tradeType) {
            case SALE: {
                return TradeData.TradeDirection.SALE;
            }
            case PURCHASE: {
                return TradeData.TradeDirection.PURCHASE;
            }
        }
        return TradeData.TradeDirection.NONE;
    }

    public ItemTradeType getTradeType() {
        return this.tradeType;
    }

    public boolean isSale() {
        return this.tradeType == ItemTradeType.SALE;
    }

    public boolean isPurchase() {
        return this.tradeType == ItemTradeType.PURCHASE;
    }

    public boolean isBarter() {
        return this.tradeType == ItemTradeType.BARTER;
    }

    public void setTradeType(ItemTradeType tradeDirection) {
        this.tradeType = tradeDirection;
    }

    public int getSlotCount() {
        return this.tradeType == ItemTradeType.BARTER ? 2 : 1;
    }

    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(ItemTradeRestriction restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isValid() {
        if (this.tradeType == ItemTradeType.BARTER) {
            return !this.sellItem.m_41619_() && !this.barterItem.m_41619_();
        }
        return super.isValid() && !this.sellItem.m_41619_();
    }

    public boolean hasStock(IItemTrader trader) {
        if (this.sellItem.m_41619_()) {
            return false;
        }
        return this.stockCount(trader) > 0;
    }

    public boolean hasSpace(IItemTrader trader) {
        switch (this.tradeType) {
            case PURCHASE: {
                return InventoryUtil.CanPutItemStack(trader.getStorage(), this.getSellItem());
            }
            case BARTER: {
                return InventoryUtil.CanPutItemStack(trader.getStorage(), this.getBarterItem());
            }
        }
        return true;
    }

    public int stockCount(IItemTrader trader) {
        if (this.sellItem.m_41619_()) {
            return 0;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            if (this.isFree) {
                return 1;
            }
            if (this.cost.getRawValue() == 0L) {
                return 0;
            }
            long coinValue = trader.getStoredMoney().getRawValue();
            long price = this.cost.getRawValue();
            return (int)(coinValue / price);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(this.sellItem, trader.getStorage());
        }
        return 0;
    }

    public void RemoveItemsFromStorage(Container storage) {
        this.restriction.removeItemsFromStorage(this.sellItem, storage);
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = super.getAsNBT();
        CompoundTag sellItemCompound = new CompoundTag();
        this.sellItem.m_41739_(sellItemCompound);
        tradeNBT.m_128365_("SellItem", (Tag)sellItemCompound);
        CompoundTag barterItemCompound = new CompoundTag();
        this.barterItem.m_41739_(barterItemCompound);
        tradeNBT.m_128365_("BarterItem", (Tag)barterItemCompound);
        tradeNBT.m_128359_("TradeDirection", this.tradeType.name());
        tradeNBT.m_128359_("Restrictions", this.restriction.getRegistryName().toString());
        tradeNBT.m_128359_("CustomName", this.customName);
        return tradeNBT;
    }

    public static CompoundTag saveAllData(CompoundTag nbt, NonNullList<ItemTradeData> data) {
        return ItemTradeData.saveAllData(nbt, data, "Trades");
    }

    public static CompoundTag saveAllData(CompoundTag nbt, NonNullList<ItemTradeData> data, String key) {
        ListTag listNBT = new ListTag();
        for (int i = 0; i < data.size(); ++i) {
            listNBT.add((Object)((ItemTradeData)data.get(i)).getAsNBT());
        }
        if (listNBT.size() > 0) {
            nbt.m_128365_(key, (Tag)listNBT);
        }
        return nbt;
    }

    public static NonNullList<ItemTradeData> loadAllData(CompoundTag nbt, int arraySize) {
        return ItemTradeData.loadAllData("Trades", nbt, arraySize);
    }

    public static NonNullList<ItemTradeData> loadAllData(String key, CompoundTag nbt, int arraySize) {
        ListTag listNBT = nbt.m_128437_(key, 10);
        NonNullList<ItemTradeData> data = ItemTradeData.listOfSize(arraySize);
        for (int i = 0; i < listNBT.size() && i < arraySize; ++i) {
            ((ItemTradeData)data.get(i)).loadFromNBT(listNBT.m_128728_(i));
        }
        return data;
    }

    @Override
    public void loadFromNBT(CompoundTag nbt) {
        super.loadFromNBT(nbt);
        this.sellItem = nbt.m_128425_("SellItem", 10) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SellItem")) : ItemStack.m_41712_((CompoundTag)nbt);
        this.barterItem = nbt.m_128425_("BarterItem", 10) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("BarterItem")) : ItemStack.f_41583_;
        this.tradeType = nbt.m_128425_("TradeDirection", 8) ? ItemTradeData.loadTradeType(nbt.m_128461_("TradeDirection")) : ItemTradeType.SALE;
        this.restriction = nbt.m_128441_("Restrictions") ? ItemTradeRestriction.get(nbt.m_128461_("Restrictions")) : ItemTradeRestriction.NONE;
        this.customName = nbt.m_128441_("CustomName") ? nbt.m_128461_("CustomName") : "";
    }

    public static ItemTradeType loadTradeType(String name) {
        ItemTradeType value = ItemTradeType.SALE;
        try {
            value = ItemTradeType.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            LightmansCurrency.LogError("Could not load '" + name + "' as a TradeDirection.");
        }
        return value;
    }

    public static NonNullList<ItemTradeData> listOfSize(int tradeCount) {
        NonNullList data = NonNullList.m_122780_((int)tradeCount, (Object)new ItemTradeData());
        for (int i = 0; i < tradeCount; ++i) {
            data.set(i, (Object)new ItemTradeData());
        }
        return data;
    }

    @Override
    public void markRulesDirty() {
    }

    public static enum ItemTradeType {
        SALE,
        PURCHASE,
        BARTER;

    }
}

