/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EquipmentRestriction
extends ItemTradeRestriction {
    private final EquipmentSlot equipmentType;

    public EquipmentRestriction(EquipmentSlot type) {
        this(type, "");
    }

    public EquipmentRestriction(EquipmentSlot type, String classicType) {
        super(classicType);
        this.equipmentType = type;
    }

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentType;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        return itemStack.canEquip(this.equipmentType, null);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        switch (this.equipmentType) {
            case HEAD: {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39693_);
            }
            case CHEST: {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39694_);
            }
            case LEGS: {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39695_);
            }
            case FEET: {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39696_);
            }
        }
        return null;
    }
}

