/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeWidget;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerTradeLimit
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "tradelimit");
    private int limit = 1;
    private long timeLimit = 0L;
    Map<UUID, List<Long>> memory = new HashMap<UUID, List<Long>>();

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = newLimit;
    }

    private boolean enforceTimeLimit() {
        return this.timeLimit > 0L;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int newValue) {
        this.timeLimit = newValue;
    }

    public void resetMemory() {
        this.memory.clear();
    }

    public PlayerTradeLimit() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        int tradeCount = this.getTradeCount(event.getPlayer().m_142081_());
        if (tradeCount >= this.limit) {
            if (this.enforceTimeLimit()) {
                event.denyTrade((Component)new TranslatableComponent("traderule.lightmanscurrency.tradelimit.denial.timed", new Object[]{tradeCount, new TimeUtil.TimeData(this.getTimeLimit()).toString()}));
            } else {
                event.denyTrade((Component)new TranslatableComponent("traderule.lightmanscurrency.tradelimit.denial", new Object[]{tradeCount}));
            }
            event.denyTrade((Component)new TranslatableComponent("traderule.lightmanscurrency.tradelimit.denial.limit", new Object[]{this.limit}));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.addEvent(event.getPlayer().m_142081_(), TimeUtil.getCurrentTime());
        this.clearExpiredData();
        event.markDirty();
    }

    private void addEvent(UUID player, Long time) {
        List<Long> eventTimes = new ArrayList<Long>();
        if (this.memory.containsKey(player)) {
            eventTimes = this.memory.get(player);
        }
        eventTimes.add(time);
        this.memory.put(player, eventTimes);
    }

    private void clearExpiredData() {
        if (!this.enforceTimeLimit()) {
            return;
        }
        ArrayList emptyEntries = new ArrayList();
        this.memory.forEach((id, eventTimes) -> {
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (TimeUtil.compareTime(this.timeLimit, (Long)eventTimes.get(i))) continue;
                eventTimes.remove(i);
                --i;
            }
            if (eventTimes.size() <= 0) {
                emptyEntries.add(id);
            }
        });
        emptyEntries.forEach(id -> this.memory.remove(id));
    }

    private int getTradeCount(UUID playerID) {
        int count = 0;
        if (this.memory.containsKey(playerID)) {
            List<Long> eventTimes = this.memory.get(playerID);
            if (!this.enforceTimeLimit()) {
                return eventTimes.size();
            }
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (!TimeUtil.compareTime(this.timeLimit, eventTimes.get(i))) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        compound.m_128405_("Limit", this.limit);
        ListTag memoryList = new ListTag();
        this.memory.forEach((id, eventTimes) -> {
            CompoundTag thisMemory = new CompoundTag();
            thisMemory.m_128362_("id", id);
            thisMemory.m_128428_("times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        compound.m_128365_("Memory", (Tag)memoryList);
        compound.m_128356_("ForgetTime", this.timeLimit);
        return compound;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("Limit", 3)) {
            this.limit = compound.m_128451_("Limit");
        }
        if (compound.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = compound.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag thisMemory = memoryList.m_128728_(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.m_128441_("id")) {
                    id = thisMemory.m_128342_("id");
                }
                if (thisMemory.m_128425_("count", 3)) {
                    int count = thisMemory.m_128451_("count");
                    for (int z = 0; z < count; ++z) {
                        eventTimes.add(0L);
                    }
                }
                if (thisMemory.m_128425_("times", 12)) {
                    for (long time : thisMemory.m_128467_("times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
        if (compound.m_128425_("ForgetTime", 4)) {
            this.timeLimit = compound.m_128454_("ForgetTime");
        }
    }

    @Override
    public Component getButtonText() {
        return new TranslatableComponent("gui.button.lightmanscurrency.playerlimit");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler
    implements TimeWidget.ITimeInput {
        EditBox limitInput;
        Button buttonSetLimit;
        Button buttonClearMemory;
        TimeWidget timeInput;

        private final PlayerTradeLimit getRule() {
            if (this.getRuleRaw() instanceof PlayerTradeLimit) {
                return (PlayerTradeLimit)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            this.limitInput = this.addCustomRenderable(new EditBox(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 19, 30, 20, (Component)new TextComponent("")));
            this.limitInput.m_94199_(3);
            this.limitInput.m_94144_(Integer.toString(this.getRule().limit));
            this.buttonSetLimit = this.addCustomRenderable(new Button(this.screen.guiLeft() + 41, this.screen.guiTop() + 19, 40, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.playerlimit.setlimit"), this::PressSetLimitButton));
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            Objects.requireNonNull(this.screen);
            this.buttonClearMemory = this.addCustomRenderable(new Button(n, n2, 176 - 20, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.playerlimit.clearmemory"), this::PressClearMemoryButton));
            this.timeInput = this.addCustomWidget(new TimeWidget(this.screen.guiLeft(), this.screen.guiTop() + 80, this.screen.getFont(), this.getRule().timeLimit, this, this, (Component)new TranslatableComponent("gui.widget.lightmanscurrency.playerlimit.noduration")));
        }

        @Override
        public void renderTab(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            this.timeInput.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            this.screen.getFont().m_92883_(poseStack, new TranslatableComponent("gui.button.lightmanscurrency.playerlimit.info", new Object[]{this.getRule().limit}).getString(), (float)(this.screen.guiLeft() + 10), (float)(this.screen.guiTop() + 9), 0xFFFFFF);
            if (this.buttonClearMemory.m_5953_((double)mouseX, (double)mouseY)) {
                this.screen.m_96602_(poseStack, (Component)new TranslatableComponent("gui.button.lightmanscurrency.playerlimit.clearmemory.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.limitInput);
            this.removeCustomWidget(this.buttonSetLimit);
            this.removeCustomWidget(this.buttonClearMemory);
            this.timeInput.getWidgets().forEach(button -> this.removeCustomWidget(button));
            this.removeCustomWidget(this.timeInput);
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.limitInput, 1L, 100L);
        }

        void PressSetLimitButton(Button button) {
            this.getRule().limit = MathUtil.clamp(TextInputUtil.getIntegerValue(this.limitInput), 1, 100);
            this.screen.markRulesDirty();
        }

        void PressClearMemoryButton(Button button) {
            this.getRule().memory.clear();
            this.screen.markRulesDirty();
        }

        @Override
        public void onTimeSet(long newTime) {
            this.getRule().timeLimit = MathUtil.clamp(newTime, 0L, Long.MAX_VALUE);
            this.screen.markRulesDirty();
        }
    }
}

