/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TradeRule {
    public static final ResourceLocation ICON_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/traderuleicons.png");
    public static final String DEFAULT_TAG = "TradeRules";
    public final ResourceLocation type;
    static final Map<String, Supplier<TradeRule>> registeredDeserializers = new HashMap<String, Supplier<TradeRule>>();

    public final Component getName() {
        return new TranslatableComponent("traderule." + this.type.m_135827_() + "." + this.type.m_135815_());
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
    }

    protected TradeRule(ResourceLocation type) {
        this.type = type;
    }

    public CompoundTag getNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("type", this.type.toString());
        return this.write(compound);
    }

    protected abstract CompoundTag write(CompoundTag var1);

    public abstract void readNBT(CompoundTag var1);

    public Component getButtonText() {
        return null;
    }

    public ResourceLocation getButtonGUI() {
        return ICON_TEXTURE;
    }

    public int getGUIX() {
        return 0;
    }

    public int getGUIY() {
        return 0;
    }

    public static CompoundTag writeRules(CompoundTag compound, List<TradeRule> rules) {
        return TradeRule.writeRules(compound, rules, DEFAULT_TAG);
    }

    public static CompoundTag writeRules(CompoundTag compound, List<TradeRule> rules, String tag) {
        ListTag ruleData = new ListTag();
        for (int i = 0; i < rules.size(); ++i) {
            CompoundTag thisRuleData = rules.get(i).getNBT();
            if (thisRuleData == null) continue;
            ruleData.add((Object)thisRuleData);
        }
        compound.m_128365_(tag, (Tag)ruleData);
        return compound;
    }

    public static List<TradeRule> readRules(CompoundTag compound) {
        return TradeRule.readRules(compound, DEFAULT_TAG);
    }

    public static List<TradeRule> readRules(CompoundTag compound, String tag) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        if (compound.m_128425_(tag, 9)) {
            ListTag ruleData = compound.m_128437_(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundTag thisRuleData = ruleData.m_128728_(i);
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData);
                if (thisRule == null) continue;
                rules.add(thisRule);
            }
        }
        return rules;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract GUIHandler createHandler(TradeRuleScreen var1, Supplier<TradeRule> var2);

    public static void RegisterDeserializer(ResourceLocation type, Supplier<TradeRule> deserializer) {
        TradeRule.RegisterDeserializer(type.toString(), deserializer);
    }

    public static void RegisterDeserializer(String type, Supplier<TradeRule> deserializer) {
        if (registeredDeserializers.containsKey(type)) {
            LightmansCurrency.LogWarning("A trade rule deserializer of type '" + type + "' has already been registered.");
            return;
        }
        registeredDeserializers.put(type, deserializer);
        LightmansCurrency.LogInfo("Registered trade rule deserializer of type " + type);
    }

    public static TradeRule Deserialize(CompoundTag compound) {
        String thisType = compound.m_128461_("type");
        AtomicReference data = new AtomicReference();
        registeredDeserializers.forEach((type, deserializer) -> {
            if (thisType.equals(type)) {
                TradeRule rule = (TradeRule)deserializer.get();
                rule.readNBT(compound);
                data.set(rule);
            }
        });
        if (data.get() != null) {
            return (TradeRule)data.get();
        }
        LightmansCurrency.LogError("Could not find a deserializer of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class GUIHandler {
        protected final TradeRuleScreen screen;
        private final Supplier<TradeRule> rule;

        protected final TradeRule getRuleRaw() {
            return (TradeRule)this.rule.get();
        }

        protected GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            this.screen = screen;
            this.rule = rule;
        }

        public abstract void initTab();

        public abstract void renderTab(PoseStack var1, int var2, int var3, float var4);

        public abstract void onTabClose();

        public void onScreenTick() {
        }

        public <T extends GuiEventListener & Widget> T addCustomRenderable(T widget) {
            return this.screen.addCustomRenderable(widget);
        }

        public <T extends GuiEventListener & NarratableEntry> T addCustomWidget(T widget) {
            return this.screen.addCustomWidget(widget);
        }

        public <T extends GuiEventListener> void removeCustomWidget(T widget) {
            this.screen.removeCustomWidget(widget);
        }
    }
}

