/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.MessageRequestNBT;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TileEntityUtil {
    public static void sendUpdatePacket(BlockEntity blockEntity) {
        ClientboundBlockEntityDataPacket packet = blockEntity.m_7033_();
        if (packet != null) {
            TileEntityUtil.sendUpdatePacket(blockEntity.m_58904_(), blockEntity.m_58899_(), packet);
        } else {
            LightmansCurrency.LogError(blockEntity.getClass().getName() + ".getUpdatePacket() returned null!");
        }
    }

    public static void sendUpdatePacket(BlockEntity tileEntity, CompoundTag compound) {
        ClientboundBlockEntityDataPacket packet = new ClientboundBlockEntityDataPacket(tileEntity.m_58899_(), 0, compound);
        TileEntityUtil.sendUpdatePacket(tileEntity.m_58904_(), tileEntity.m_58899_(), packet);
    }

    private static void sendUpdatePacket(Level level, BlockPos pos, ClientboundBlockEntityDataPacket packet) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Stream players = server.m_7726_().f_8325_.m_5960_(new ChunkPos(pos), false);
            players.forEach(player -> player.f_8906_.m_141995_((Packet)packet));
        } else {
            LightmansCurrency.LogWarning("Cannot send Tile Entity Update Packet from a client.");
        }
    }

    public static void requestUpdatePacket(BlockEntity blockEntity) {
        TileEntityUtil.requestUpdatePacket(blockEntity.m_58904_(), blockEntity.m_58899_());
    }

    public static void requestUpdatePacket(Level level, BlockPos pos) {
        if (level.f_46443_) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestNBT(pos));
        }
    }
}

