/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.live_main_menu.event;

import com.mojang.blaze3d.platform.Window;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.neoforged.neoforge.client.event.ScreenEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.zlt.live_main_menu.Config;
import net.zlt.live_main_menu.LiveMainMenu;
import net.zlt.live_main_menu.gui.LiveTitleScreen;
import net.zlt.live_main_menu.mixin.accessor.TitleScreenAccessor;

public class ModEvents {
    @Nullable
    private static LiveTitleScreen liveTitleScreen = null;
    private static boolean handleLevel = false;
    private static boolean openingLiveMainMenuLevel = false;
    private static boolean failed = false;

    public static boolean isHandlingLevel() {
        return handleLevel;
    }

    public static void onScreenOpening(ScreenEvent.Opening event) {
        Screen screen = event.getScreen();
        if (!(screen instanceof TitleScreen)) {
            return;
        }
        TitleScreen titleScreen = (TitleScreen)screen;
        if (failed) {
            failed = false;
            return;
        }
        LiveMainMenu.LOGGER.info("Opening live title screen");
        ModEvents.createLiveTitleScreen(titleScreen);
        ModEvents.tryLoadLevel(titleScreen);
    }

    public static void onLevelTick(LevelTickEvent.Post event) {
        if (!handleLevel) {
            return;
        }
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (!(minecraft.screen instanceof LiveTitleScreen)) {
            minecraft.setScreen((Screen)liveTitleScreen);
        }
    }

    public static void onLevelUnload(LevelEvent.Unload event) {
        handleLevel = false;
    }

    public static void onComputeFov(ViewportEvent.ComputeFov event) {
        if (!handleLevel || !Config.useCustomFov) {
            return;
        }
        event.setFOV((double)Config.liveMainMenuFov);
    }

    public static void onCreateLevel() {
        ModEvents.quitLiveMainMenuLevel();
    }

    public static void onPlaySingleplayer() {
        if (openingLiveMainMenuLevel) {
            openingLiveMainMenuLevel = false;
            return;
        }
        ModEvents.quitLiveMainMenuLevel();
    }

    public static void onPlayMultiplayer() {
        ModEvents.quitLiveMainMenuLevel();
    }

    public static void onPlayRealms() {
        ModEvents.quitLiveMainMenuLevel();
    }

    public static void onDeleteWorld() {
        ModEvents.quitLiveMainMenuLevel();
    }

    public static void onEditWorld() {
        ModEvents.quitLiveMainMenuLevel();
    }

    public static void onRecreateWorld() {
        ModEvents.quitLiveMainMenuLevel();
    }

    private static void quitLiveMainMenuLevel() {
        if (!handleLevel) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        ModEvents.quitLevel((Screen)(minecraft.screen == null ? new TitleScreen() : minecraft.screen));
    }

    public static void quitLevel(Screen screen) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.level == null) {
            return;
        }
        minecraft.getReportingContext().draftReportHandled(minecraft, screen, ModEvents::onQuitLevel, true);
    }

    private static void onQuitLevel() {
        Minecraft minecraft = Minecraft.getInstance();
        minecraft.level.disconnect();
        if (minecraft.isLocalServer()) {
            minecraft.disconnect((Screen)new GenericMessageScreen(LiveTitleScreen.SAVING_LEVEL));
        } else {
            minecraft.disconnect();
        }
    }

    private static void createLiveTitleScreen(TitleScreen titleScreen) {
        liveTitleScreen = new LiveTitleScreen(((TitleScreenAccessor)titleScreen).isFading());
        SelectWorldScreen selectWorldScreen = new SelectWorldScreen((Screen)liveTitleScreen);
        liveTitleScreen.setSelectWorldScreen(selectWorldScreen);
        Minecraft minecraft = Minecraft.getInstance();
        Window window = minecraft.getWindow();
        selectWorldScreen.init(minecraft, window.getGuiScaledWidth(), window.getGuiScaledHeight());
    }

    private static void tryLoadLevel(TitleScreen titleScreen) {
        CompletableFuture levelSummaryFuture;
        Minecraft minecraft = Minecraft.getInstance();
        LevelStorageSource levelSource = minecraft.getLevelSource();
        try {
            levelSummaryFuture = levelSource.loadLevelSummaries(levelSource.findLevelCandidates());
        }
        catch (Throwable e2) {
            LiveMainMenu.LOGGER.warn("Couldn't load worlds", e2);
            failed = true;
            minecraft.setScreen((Screen)titleScreen);
            return;
        }
        ((CompletableFuture)levelSummaryFuture.thenAcceptAsync(levelSummaries -> minecraft.execute(() -> {
            String levelId = null;
            for (LevelSummary levelSummary : levelSummaries) {
                if (!levelSummary.getLevelName().equals("LiveMainMenu")) continue;
                levelId = levelSummary.getLevelId();
                break;
            }
            if (levelId == null) {
                failed = true;
                minecraft.setScreen((Screen)titleScreen);
                return;
            }
            handleLevel = true;
            openingLiveMainMenuLevel = true;
            minecraft.createWorldOpenFlows().openWorld(levelId, () -> {
                LiveMainMenu.LOGGER.warn("Couldn't open world");
                failed = true;
                minecraft.setScreen((Screen)titleScreen);
            });
        }))).exceptionally(e -> {
            minecraft.execute(() -> {
                LiveMainMenu.LOGGER.warn("Couldn't load worlds", e);
                failed = true;
                minecraft.setScreen((Screen)titleScreen);
            });
            return null;
        });
    }
}

