/*
 * Decompiled with CFR 0.152.
 */
package net.zlt.live_main_menu.gui;

import com.mojang.authlib.minecraft.BanDetails;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CommonButtons;
import net.minecraft.client.gui.components.LogoRenderer;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.SplashRenderer;
import net.minecraft.client.gui.components.SpriteIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.CreditsAndAttributionScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.options.AccessibilityOptionsScreen;
import net.minecraft.client.gui.screens.options.LanguageSelectScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.neoforged.neoforge.client.ClientHooks;
import net.neoforged.neoforge.client.gui.ModListScreen;
import net.neoforged.neoforge.client.gui.widget.ModsButton;
import net.neoforged.neoforge.internal.BrandingControl;
import net.zlt.live_main_menu.LiveMainMenu;
import net.zlt.live_main_menu.event.ModEvents;
import net.zlt.live_main_menu.mixin.accessor.TitleScreenAccessor;

public class LiveTitleScreen
extends Screen {
    public static final Component SAVING_LEVEL = Component.translatable((String)"live_main_menu.menu.savingLevel");
    private final LogoRenderer logoRenderer;
    @Nullable
    private SplashRenderer splashRenderer;
    @Nullable
    private RealmsNotificationsScreen realmsNotificationsScreen;
    private boolean fading;
    private long fadeInStart;
    @Nullable
    SelectWorldScreen selectWorldScreen;

    public LiveTitleScreen(boolean fading) {
        super(TitleScreenAccessor.getTitle());
        this.fading = fading;
        this.logoRenderer = new LogoRenderer(false);
    }

    public void setSelectWorldScreen(SelectWorldScreen screen) {
        this.selectWorldScreen = screen;
    }

    protected void init() {
        if (this.splashRenderer == null) {
            this.splashRenderer = this.minecraft.getSplashManager().getSplash();
        }
        int i = this.font.width((FormattedText)TitleScreenAccessor.getCopyrightText());
        int j = this.width - i - 2;
        int l = this.height / 4 + 32;
        if (this.minecraft.isDemo()) {
            this.createDemoMenuOptions(l, 24);
        } else {
            this.createNormalMenuOptions(l, 24);
            this.addRenderableWidget((GuiEventListener)new ModsButton(Button.builder((Component)Component.translatable((String)"fml.menu.mods"), button -> this.minecraft.setScreen((Screen)new ModListScreen((Screen)this))).bounds(this.width / 2 - 100, l + 72, 200, 20)));
            l += 22;
        }
        SpriteIconButton languageButton = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)CommonButtons.language((int)20, button -> this.minecraft.setScreen((Screen)new LanguageSelectScreen((Screen)this, this.minecraft.options, this.minecraft.getLanguageManager())), (boolean)true));
        languageButton.setPosition(this.width / 2 - 124, l + 72 + 12);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.options"), button -> this.minecraft.setScreen((Screen)new OptionsScreen((Screen)this, this.minecraft.options))).bounds(this.width / 2 - 100, l + 72 + 12, 98, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.quit"), button -> this.minecraft.stop()).bounds(this.width / 2 + 2, l + 72 + 12, 98, 20).build());
        SpriteIconButton accessibilityButton = (SpriteIconButton)this.addRenderableWidget((GuiEventListener)CommonButtons.accessibility((int)20, button -> this.minecraft.setScreen((Screen)new AccessibilityOptionsScreen((Screen)this, this.minecraft.options)), (boolean)true));
        accessibilityButton.setPosition(this.width / 2 + 104, l + 72 + 12);
        this.addRenderableWidget((GuiEventListener)new PlainTextButton(j, this.height - 10, i, 10, TitleScreenAccessor.getCopyrightText(), button -> this.minecraft.setScreen((Screen)new CreditsAndAttributionScreen((Screen)this)), this.font));
        if (!this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen = new RealmsNotificationsScreen();
        }
        this.realmsNotificationsScreen.init(this.minecraft, this.width, this.height);
    }

    public void tick() {
        if (!ModEvents.isHandlingLevel()) {
            this.minecraft.setScreen((Screen)new TitleScreen());
            return;
        }
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.tick();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button) || this.realmsNotificationsEnabled() && this.realmsNotificationsScreen.mouseClicked(mouseX, mouseY, button);
    }

    public void removed() {
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.removed();
        }
    }

    public void added() {
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.added();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int i;
        if (this.fadeInStart == 0L && this.fading) {
            this.fadeInStart = Util.getMillis();
        }
        float f = 1.0f;
        if (this.fading) {
            float f1 = (float)(Util.getMillis() - this.fadeInStart) / 2000.0f;
            if (f1 > 1.0f) {
                this.fading = false;
            } else {
                f1 = Mth.clamp((float)f1, (float)0.0f, (float)1.0f);
                f = Mth.clampedMap((float)f1, (float)0.5f, (float)1.0f, (float)0.0f, (float)1.0f);
            }
            this.fadeWidgets(f);
        }
        if (((i = Mth.ceil((float)(f * 255.0f)) << 24) & 0xFC000000) != 0) {
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            this.logoRenderer.renderLogo(guiGraphics, this.width, f);
            ClientHooks.renderMainMenu(null, (GuiGraphics)guiGraphics, (Font)this.font, (int)this.width, (int)this.height, (int)i);
            if (this.splashRenderer != null && !((Boolean)this.minecraft.options.hideSplashTexts().get()).booleanValue()) {
                this.splashRenderer.render(guiGraphics, this.width, this.font, i);
            }
            BrandingControl.forEachLine((boolean)true, (boolean)true, (brdline, brd) -> {
                int n = brdline;
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, brd, 2, this.height - (10 + n * (9 + 1)), 0xFFFFFF | i);
            });
            BrandingControl.forEachAboveCopyrightLine((brdline, brd) -> {
                int n = this.width - this.font.width(brd);
                int n2 = brdline + 1;
                Objects.requireNonNull(this.font);
                guiGraphics.drawString(this.font, brd, n, this.height - (10 + n2 * (9 + 1)), 0xFFFFFF | i);
            });
            if (this.realmsNotificationsEnabled()) {
                RenderSystem.enableDepthTest();
                this.realmsNotificationsScreen.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }
    }

    private void fadeWidgets(float alpha) {
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget = (AbstractWidget)child;
            abstractWidget.setAlpha(alpha);
        }
    }

    private void createNormalMenuOptions(int y, int rowHeight) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.singleplayer"), button -> {
            if (this.selectWorldScreen != null) {
                this.minecraft.setScreen((Screen)this.selectWorldScreen);
            }
        }).bounds(this.width / 2 - 100, y, 200, 20).build());
        Component multiplayerDisabledReason = this.getMultiplayerDisabledReason();
        boolean isMultiplayerEnabled = multiplayerDisabledReason == null;
        Tooltip multiplayerDisabledReasonTooltip = multiplayerDisabledReason == null ? null : Tooltip.create((Component)multiplayerDisabledReason);
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.multiplayer"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$createNormalMenuOptions$9(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((LiveTitleScreen)this)).bounds((int)(this.width / 2 - 100), (int)(y + rowHeight), (int)200, (int)20).tooltip((Tooltip)multiplayerDisabledReasonTooltip).build())).active = isMultiplayerEnabled;
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.online"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$createNormalMenuOptions$10(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((LiveTitleScreen)this)).bounds((int)(this.width / 2 - 100), (int)(y + rowHeight * 2), (int)200, (int)20).tooltip((Tooltip)multiplayerDisabledReasonTooltip).build())).active = isMultiplayerEnabled;
    }

    @Nullable
    private Component getMultiplayerDisabledReason() {
        if (this.minecraft.allowsMultiplayer()) {
            return null;
        }
        if (this.minecraft.isNameBanned()) {
            return Component.translatable((String)"title.multiplayer.disabled.banned.name");
        }
        BanDetails banDetails = this.minecraft.multiplayerBan();
        if (banDetails == null) {
            return Component.translatable((String)"title.multiplayer.disabled");
        }
        return banDetails.expires() == null ? Component.translatable((String)"title.multiplayer.disabled.banned.permanent") : Component.translatable((String)"title.multiplayer.disabled.banned.temporary");
    }

    private void createDemoMenuOptions(int y, int rowHeight) {
        boolean isDemoWorldPresent = this.checkDemoWorldPresence();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.playdemo"), button -> {
            ModEvents.quitLevel(this);
            if (isDemoWorldPresent) {
                this.minecraft.createWorldOpenFlows().openWorld("Demo_World", () -> this.minecraft.setScreen((Screen)new TitleScreen()));
            } else {
                this.minecraft.createWorldOpenFlows().createFreshLevel("Demo_World", MinecraftServer.DEMO_SETTINGS, WorldOptions.DEMO_OPTIONS, WorldPresets::createNormalWorldDimensions, (Screen)new TitleScreen());
            }
        }).bounds(this.width / 2 - 100, y, 200, 20).build());
        ((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.resetdemo"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$createDemoMenuOptions$13(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((LiveTitleScreen)this)).bounds((int)(this.width / 2 - 100), (int)(y + rowHeight), (int)200, (int)20).build())).active = isDemoWorldPresent;
    }

    private boolean checkDemoWorldPresence() {
        try {
            boolean isDemoWorldPresent;
            try (LevelStorageSource.LevelStorageAccess levelAccess = this.minecraft.getLevelSource().createAccess("Demo_World");){
                isDemoWorldPresent = levelAccess.hasWorldData();
            }
            return isDemoWorldPresent;
        }
        catch (IOException e) {
            SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)"Demo_World");
            LiveMainMenu.LOGGER.warn("Failed to read demo world data", (Throwable)e);
            return false;
        }
    }

    private void confirmDemo(boolean confirmed) {
        if (confirmed) {
            try (LevelStorageSource.LevelStorageAccess levelAccess = this.minecraft.getLevelSource().createAccess("Demo_World");){
                levelAccess.deleteLevel();
            }
            catch (IOException e) {
                SystemToast.onWorldDeleteFailure((Minecraft)this.minecraft, (String)"Demo_World");
                LiveMainMenu.LOGGER.warn("Failed to delete demo world", (Throwable)e);
            }
        }
        this.minecraft.setScreen((Screen)this);
    }

    private boolean realmsNotificationsEnabled() {
        return this.realmsNotificationsScreen != null;
    }

    private /* synthetic */ void lambda$createDemoMenuOptions$13(Button button) {
        LevelStorageSource levelSource = this.minecraft.getLevelSource();
        try (LevelStorageSource.LevelStorageAccess levelAccess = levelSource.createAccess("Demo_World");){
            if (levelAccess.hasWorldData()) {
                this.minecraft.setScreen((Screen)new ConfirmScreen(this::confirmDemo, (Component)Component.translatable((String)"selectWorld.deleteQuestion"), (Component)Component.translatable((String)"selectWorld.deleteWarning", (Object[])new Object[]{MinecraftServer.DEMO_SETTINGS.levelName()}), (Component)Component.translatable((String)"selectWorld.deleteButton"), CommonComponents.GUI_CANCEL));
            }
        }
        catch (IOException e) {
            SystemToast.onWorldAccessFailure((Minecraft)this.minecraft, (String)"Demo_World");
            LiveMainMenu.LOGGER.warn("Failed to access demo world", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$10(Button button) {
        this.minecraft.setScreen((Screen)new RealmsMainScreen((Screen)this));
    }

    private /* synthetic */ void lambda$createNormalMenuOptions$9(Button button) {
        this.minecraft.setScreen((Screen)(this.minecraft.options.skipMultiplayerWarning ? new JoinMultiplayerScreen((Screen)this) : new SafetyScreen((Screen)this)));
    }
}

