/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil;

import CoroUtil.OldUtil;
import CoroUtil.config.ConfigCoroAI;
import CoroUtil.pathfinding.PFQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DimensionChunkCacheNew
implements IBlockAccess {
    public static List<Integer> listBlacklistIDs = new ArrayList<Integer>();
    public static List<String> listBlacklistNamess = new ArrayList<String>();
    public static HashMap<Integer, DimensionChunkCacheNew> dimCacheLookup = new HashMap();
    public int chunkX;
    public int chunkZ;
    public int chunkXMax;
    public int chunkZMax;
    private Chunk[][] chunkArray;
    private boolean hasExtendedLevels;
    private World worldObj;

    public static void updateAllWorldCache() {
        WorldServer[] worlds = DimensionManager.getWorlds();
        for (int i = 0; i < worlds.length; ++i) {
            WorldServer world = worlds[i];
            boolean skip = false;
            if (ConfigCoroAI.chunkCacheOverworldOnly && i != 0) {
                skip = true;
            }
            if (listBlacklistIDs.contains(i)) {
                skip = true;
            }
            for (int j = 0; j < listBlacklistNamess.size(); ++j) {
                if (world == null || !world.field_73011_w.func_80007_l().contains(listBlacklistNamess.get(j))) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            dimCacheLookup.put(world.field_73011_w.func_177502_q(), new DimensionChunkCacheNew((World)world, true));
        }
    }

    public DimensionChunkCacheNew(World world, boolean useLoadedChunks) {
        int chunkCount = 0;
        try {
            int minX = 0;
            int minZ = 0;
            int maxX = 0;
            int maxZ = 0;
            List chunks = ((ChunkProviderServer)world.func_72863_F()).func_152380_a();
            if (chunks == null) {
                try {
                    chunks = (ArrayList)OldUtil.getPrivateValueSRGMCP(ChunkProviderServer.class, world.func_72863_F(), OldUtil.refl_loadedChunks_obf, OldUtil.refl_loadedChunks_mcp);
                }
                catch (Exception ex2) {
                    System.out.println("SERIOUS REFLECTION FAIL IN DimensionChunkCache");
                }
            }
            if (chunks == null) {
                if (ConfigCoroAI.usePlayerRadiusChunkLoadingForFallback) {
                    System.out.println("unable to get loaded chunks, reverting to potentially cpu/memory heavy player radius method, to deactivate set usePlayerRadiusChunkLoadingForFallback in CoroUtil.cfg to false");
                } else {
                    System.out.println("loadedChunks is null, DimensionChunkCache unable to cache chunk data for dimension: " + world.field_73011_w.func_177502_q() + " - " + world.field_73011_w.func_80007_l());
                }
            }
            if (chunks != null && useLoadedChunks) {
                if (chunks != null) {
                    for (int i = 0; i < chunks.size(); ++i) {
                        Chunk chunk = (Chunk)chunks.get(i);
                        if (chunk.field_76635_g < minX) {
                            minX = chunk.field_76635_g;
                        }
                        if (chunk.field_76647_h < minZ) {
                            minZ = chunk.field_76647_h;
                        }
                        if (chunk.field_76635_g > maxX) {
                            maxX = chunk.field_76635_g;
                        }
                        if (chunk.field_76647_h <= maxZ) continue;
                        maxZ = chunk.field_76647_h;
                    }
                    this.worldObj = world;
                    this.chunkX = minX;
                    this.chunkZ = minZ;
                    int var8 = maxX;
                    int var9 = maxZ;
                    this.chunkArray = new Chunk[var8 - this.chunkX + 1][var9 - this.chunkZ + 1];
                    this.hasExtendedLevels = true;
                    for (int i = 0; i < chunks.size(); ++i) {
                        Chunk chunk;
                        this.chunkArray[chunk.field_76635_g - this.chunkX][chunk.field_76647_h - this.chunkZ] = chunk = (Chunk)chunks.get(i);
                        ++chunkCount;
                    }
                }
            } else if (ConfigCoroAI.usePlayerRadiusChunkLoadingForFallback) {
                int playerRadius = 8;
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityPlayer var5 = (EntityPlayer)world.field_73010_i.get(i);
                    if ((int)var5.field_70165_t < minX) {
                        minX = (int)var5.field_70165_t;
                    }
                    if ((int)var5.field_70161_v < minZ) {
                        minZ = (int)var5.field_70161_v;
                    }
                    if ((int)var5.field_70165_t > maxX) {
                        maxX = (int)var5.field_70165_t;
                    }
                    if ((int)var5.field_70161_v <= maxZ) continue;
                    maxZ = (int)var5.field_70161_v;
                }
                this.worldObj = world;
                this.chunkX = (minX -= playerRadius * 16) >> 4;
                this.chunkZ = (minZ -= playerRadius * 16) >> 4;
                int var8 = (maxX += playerRadius * 16) >> 4;
                int var9 = (maxZ += playerRadius * 16) >> 4;
                this.chunkXMax = var8;
                this.chunkZMax = var9;
                this.chunkArray = new Chunk[var8 - this.chunkX + 1][var9 - this.chunkZ + 1];
                this.hasExtendedLevels = true;
                for (int i = 0; i < world.field_73010_i.size(); ++i) {
                    EntityPlayer var5 = (EntityPlayer)world.field_73010_i.get(i);
                    int pChunkX = MathHelper.func_76128_c((double)(var5.field_70165_t / 16.0));
                    int pChunkZ = MathHelper.func_76128_c((double)(var5.field_70161_v / 16.0));
                    for (int xx = -playerRadius; xx <= playerRadius; ++xx) {
                        for (int zz = -playerRadius; zz <= playerRadius; ++zz) {
                            Chunk var12;
                            if (pChunkX + xx - this.chunkX < 0 || pChunkZ + zz - this.chunkZ < 0 || this.chunkArray[pChunkX + xx - this.chunkX][pChunkZ + zz - this.chunkZ] != null || (var12 = world.func_72964_e(pChunkX + xx, pChunkZ + zz)) == null) continue;
                            ++chunkCount;
                            this.chunkArray[pChunkX + xx - this.chunkX][pChunkZ + zz - this.chunkZ] = var12;
                        }
                    }
                }
            }
            PFQueue.lastChunkCacheCount = chunkCount;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("DimensionChunkCache crash, tell Corosus");
            PFQueue.lastChunkCacheCount = 0;
        }
    }

    public TileEntity func_175625_s(BlockPos pos) {
        int i = (pos.func_177958_n() >> 4) - this.chunkX;
        int j = (pos.func_177952_p() >> 4) - this.chunkZ;
        if (i < 0 || i >= this.chunkArray.length || j < 0 || j >= this.chunkArray[i].length) {
            return null;
        }
        if (this.chunkArray[i][j] == null) {
            return null;
        }
        return this.chunkArray[i][j].func_177424_a(pos, Chunk.EnumCreateEntityType.IMMEDIATE);
    }

    public int func_175626_b(BlockPos pos, int lightValue) {
        return 0;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            Chunk chunk;
            int i = (pos.func_177958_n() >> 4) - this.chunkX;
            int j = (pos.func_177952_p() >> 4) - this.chunkZ;
            System.out.println("PFQUEUE FIX ME IM BROKEN");
            if (i < 0 || i >= this.chunkArray.length || j < 0 || i >= this.chunkArray[i].length) {
                return Blocks.field_150350_a.func_176223_P();
            }
            if (i >= 0 && i < this.chunkArray.length && j >= 0 && j < this.chunkArray[i].length && (chunk = this.chunkArray[i][j]) != null) {
                return chunk.func_177435_g(pos);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).func_177230_c().isAir((IBlockAccess)this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BiomeGenBase func_180494_b(BlockPos pos) {
        return this.worldObj.func_180494_b(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return this.hasExtendedLevels;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        IBlockState iblockstate = this.func_180495_p(pos);
        return iblockstate.func_177230_c().func_176211_b((IBlockAccess)this, pos, iblockstate, direction);
    }

    @SideOnly(value=Side.CLIENT)
    public WorldType func_175624_G() {
        return this.worldObj.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        int x = (pos.func_177958_n() >> 4) - this.chunkX;
        int z = (pos.func_177952_p() >> 4) - this.chunkZ;
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            return _default;
        }
        if (x < 0 || x >= this.chunkArray.length || z < 0 || x >= this.chunkArray[x].length) {
            return _default;
        }
        return this.func_180495_p(pos).func_177230_c().isSideSolid((IBlockAccess)this, pos, side);
    }
}

