/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt;

import CoroUtil.OldUtil;
import CoroUtil.bt.AIBTAgent;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilEntity;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class AIBTTamable {
    public AIBTAgent agent;
    public String owner = "";
    public int ownerEntityID = -1;
    public EntityLivingBase ownerCachedInstance = null;
    public BlockCoord occupyCoord;
    public double followDistMin = 2.0;
    public double followDistMax = 8.0;
    public double strayDistMax = 32.0;
    public double teleportFromFarDist = 18.0;
    public boolean shouldStayStill = false;

    public AIBTTamable(AIBTAgent parJob) {
        this.agent = parJob;
    }

    public boolean isTame() {
        return !this.owner.equals("");
    }

    public boolean shouldStayStill() {
        return this.shouldStayStill;
    }

    public void setTamedByOwner(String user) {
        this.owner = user;
        this.updateCache();
    }

    public void tameClear() {
        this.owner = "";
        this.ownerCachedInstance = null;
    }

    public void updateCache() {
        this.ownerCachedInstance = this.agent.ent.field_70170_p.func_72924_a(this.owner);
    }

    public EntityLivingBase getPlayerCached() {
        return this.ownerCachedInstance;
    }

    public boolean isEnemy(Entity ent) {
        if (ent instanceof EntityPlayer && CoroUtilEntity.getName(ent).equals(this.owner)) {
            return false;
        }
        return false;
    }

    public void tick() {
        if (this.isTame()) {
            this.updateCache();
            EntityLivingBase ent = this.getPlayerCached();
            if (ent != null) {
                this.occupyCoord = OldUtil.entToCoord((Entity)ent);
                if (!this.shouldStayStill() && (ent.field_70122_E || ent.func_70090_H()) && this.teleportFromFarDist != -1.0 && (double)this.agent.ent.func_70032_d((Entity)ent) > this.teleportFromFarDist) {
                    double range = 0.0;
                    Random rand = new Random();
                    this.agent.ent.func_70107_b(ent.field_70165_t + rand.nextDouble() * range - rand.nextDouble() * range, ent.field_70163_u, ent.field_70161_v + rand.nextDouble() * range - rand.nextDouble() * range);
                    this.agent.ent.field_70143_R = -100.0f;
                    this.agent.blackboard.setMoveTo(null, true);
                    this.agent.blackboard.setTarget(null);
                }
                if (!this.agent.ent.func_82165_m(Potion.field_76431_k.field_76415_H)) {
                    this.agent.ent.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 5, 0));
                }
            }
        }
    }

    public void onIdleTick() {
    }

    public void cleanup() {
        this.agent = null;
        this.ownerCachedInstance = null;
    }
}

