/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt.actions;

import CoroUtil.bt.Behavior;
import CoroUtil.bt.EnumBehaviorState;
import CoroUtil.bt.leaf.LeafAction;
import CoroUtil.componentAI.ICoroAI;
import CoroUtil.util.BlockCoord;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Vec3;

public class ActionMoveToCoords
extends LeafAction {
    public ICoroAI ent;
    public BlockCoord[] coordsRef;
    public int closeDist;
    public boolean ignoreY = false;
    public boolean helpMonitor = false;
    public boolean noMoveReset = true;
    public int noMoveTicks = 0;
    public int noMoveTicksMax = 80;
    public double noMoveTicksThreshold = 0.1;
    public Vec3 noMoveTicksLastPos;

    public ActionMoveToCoords(Behavior parParent, ICoroAI parEnt, BlockCoord[] parCoordsRef, int parCloseDist, boolean parIgnoreY, boolean parHelpMonitor) {
        super(parParent);
        this.ent = parEnt;
        this.coordsRef = parCoordsRef;
        this.closeDist = parCloseDist;
        this.ignoreY = parIgnoreY;
        this.helpMonitor = parHelpMonitor;
    }

    @Override
    public EnumBehaviorState tick() {
        if (this.coordsRef[0] != null) {
            EntityLivingBase entL = (EntityLivingBase)this.ent;
            double dist = this.ignoreY ? ((EntityLivingBase)this.ent).func_70011_f((double)this.coordsRef[0].posX, ((EntityLivingBase)this.ent).field_70163_u, (double)this.coordsRef[0].posZ) : ((EntityLivingBase)this.ent).func_70011_f((double)this.coordsRef[0].posX, (double)this.coordsRef[0].posY, (double)this.coordsRef[0].posZ);
            if (dist < (double)this.closeDist) {
                this.noMoveTicks = 0;
                return EnumBehaviorState.SUCCESS;
            }
            if (((EntityLiving)this.ent).func_70661_as().func_75500_f() && ((EntityLiving)this.ent).field_70170_p.func_72820_D() % 20L == 0L) {
                this.ent.getAIAgent().moveTo(this.coordsRef[0]);
                this.noMoveTicks = 0;
            }
            if (this.helpMonitor) {
                if (this.noMoveTicksLastPos != null) {
                    double posDiff = entL.func_70011_f(this.noMoveTicksLastPos.field_72450_a, entL.field_70163_u, this.noMoveTicksLastPos.field_72449_c);
                    this.noMoveTicksThreshold = 0.01;
                    if (posDiff < this.noMoveTicksThreshold) {
                        ++this.noMoveTicks;
                        if (this.noMoveTicks > this.noMoveTicksMax) {
                            this.noMoveTicks = 0;
                            this.dbg("no move ticks max triggered, nulling coords");
                            this.coordsRef[0] = null;
                            return EnumBehaviorState.FAILURE;
                        }
                    }
                }
                this.noMoveTicksLastPos = new Vec3(entL.field_70165_t, entL.field_70163_u, entL.field_70161_v);
            }
            return EnumBehaviorState.RUNNING;
        }
        return EnumBehaviorState.FAILURE;
    }
}

