/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt.entity;

import CoroUtil.ability.Ability;
import CoroUtil.ability.IAbilityUser;
import CoroUtil.bt.AIBTAgent;
import CoroUtil.bt.IBTAgent;
import CoroUtil.entity.IEntityPacket;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityAnimalBase
extends EntityAnimal
implements IBTAgent,
IAbilityUser,
IEntityPacket {
    public AIBTAgent agent;

    public EntityAnimalBase(World par1World) {
        super(par1World);
        this.initAIProfile();
        this.agent.initBTTemplate();
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    @Override
    public AIBTAgent getAIBTAgent() {
        return this.agent;
    }

    @Override
    public EntityLivingBase getEntityLiving() {
        return this;
    }

    @Override
    public void cleanup() {
        this.agent = null;
    }

    @Override
    public Ability activateAbility(String ability, Object ... objects) {
        Ability abilityObj = this.agent.profile.abilities.get(ability);
        if (abilityObj != null) {
            abilityObj.setActive();
        }
        return abilityObj;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.initRPGStats();
        return super.func_180482_a(difficulty, this.getAIBTAgent().onSpawnEvent(livingdata));
    }

    @Override
    public ConcurrentHashMap getAbilities() {
        return this.agent.profile.abilities;
    }

    public void checkAgent() {
        if (this.agent == null) {
            this.agent = new AIBTAgent(this);
        }
    }

    public void initRPGStats() {
    }

    public void initAIProfile() {
        this.agent.profile.init();
        this.agent.profile.initProfile(-1);
    }

    public void initExtraAI() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.agent.setSpeedNormalBase(0.65f);
        this.agent.applyEntityAttributes();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public void func_70619_bc() {
        this.agent.tickAI();
        AIBTAgent.DEBUGTREES = false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.checkAgent();
        this.agent.entityInit();
    }

    public boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        this.checkAgent();
        return this.agent.eventHandler.interact(par1EntityPlayer);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        this.checkAgent();
        if (!(this.field_70170_p.field_72995_K || this.agent != null && this.agent.ent != null)) {
            return false;
        }
        boolean result = this.agent.eventHandler.attackEntityFrom(par1DamageSource, par2);
        if (result) {
            return true;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.checkAgent();
        this.agent.nbtRead(par1nbtTagCompound);
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        this.agent.nbtWrite(par1nbtTagCompound);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.agent.tickLiving();
    }

    @Override
    public void handleNBTFromClient(NBTTagCompound par1nbtTagCompound) {
    }

    @Override
    public void handleNBTFromServer(NBTTagCompound par1nbtTagCompound) {
        this.agent.nbtDataFromServer(par1nbtTagCompound);
        String command = par1nbtTagCompound.func_74779_i("command");
        if (command.equals("tamed")) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_175688_a(EnumParticleTypes.HEART, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
            }
        }
    }
}

