/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt.selector;

import CoroUtil.bt.Behavior;
import CoroUtil.bt.EnumBehaviorState;
import CoroUtil.bt.IBTAgent;
import CoroUtil.bt.selector.Selector;
import CoroUtil.util.BlockCoord;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.Vec3;

public class SelectorMoveToCoords
extends Selector {
    public IBTAgent ent;
    public BlockCoord[] coordsRef;
    public int closeDist;
    public boolean ignoreY = false;
    public boolean helpMonitor = false;
    public boolean noMoveReset = true;
    public int noMoveTicks = 0;
    public int noMoveTicksMax = 80;
    public double noMoveTicksThreshold = 0.1;
    public Vec3 noMoveTicksLastPos;
    public boolean useSight = true;

    public SelectorMoveToCoords(Behavior parParent, IBTAgent parEnt, BlockCoord[] parCoordsRef, int parCloseDist, boolean parIgnoreY, boolean parHelpMonitor) {
        this(parParent, parEnt, parCoordsRef, parCloseDist);
        this.ignoreY = parIgnoreY;
        this.helpMonitor = parHelpMonitor;
    }

    public SelectorMoveToCoords(Behavior parParent, IBTAgent parEnt, BlockCoord[] parCoordsRef, int parCloseDist) {
        super(parParent);
        this.ent = parEnt;
        this.coordsRef = parCoordsRef;
        this.closeDist = parCloseDist;
    }

    @Override
    public EnumBehaviorState tick() {
        if (this.coordsRef[0] != null) {
            EntityLivingBase entL = (EntityLivingBase)this.ent;
            double dist = this.ignoreY ? ((EntityLivingBase)this.ent).func_70011_f((double)this.coordsRef[0].posX, ((EntityLivingBase)this.ent).field_70163_u, (double)this.coordsRef[0].posZ) : ((EntityLivingBase)this.ent).func_70011_f((double)this.coordsRef[0].posX, (double)this.coordsRef[0].posY, (double)this.coordsRef[0].posZ);
            if (dist < (double)this.closeDist && (!this.useSight || this.canBeSeen(new Vec3((double)this.coordsRef[0].posX, (double)this.coordsRef[0].posY + 1.1, (double)this.coordsRef[0].posZ)))) {
                this.noMoveTicks = 0;
                return ((Behavior)this.children.get(1)).tick();
            }
            this.ent.getAIBTAgent().blackboard.setMoveTo(new Vec3((double)this.coordsRef[0].posX, (double)this.coordsRef[0].posY, (double)this.coordsRef[0].posZ));
            this.noMoveTicks = 0;
            if (this.helpMonitor) {
                if (this.noMoveTicksLastPos != null) {
                    double posDiff = entL.func_70011_f(this.noMoveTicksLastPos.field_72450_a, entL.field_70163_u, this.noMoveTicksLastPos.field_72449_c);
                    this.noMoveTicksThreshold = 0.01;
                    if (posDiff < this.noMoveTicksThreshold) {
                        ++this.noMoveTicks;
                        if (this.noMoveTicks > this.noMoveTicksMax) {
                            this.noMoveTicks = 0;
                            this.dbg("no move ticks max triggered, nulling coords");
                            this.coordsRef[0] = null;
                            return ((Behavior)this.children.get(0)).tick();
                        }
                    }
                }
                this.noMoveTicksLastPos = new Vec3(entL.field_70165_t, entL.field_70163_u, entL.field_70161_v);
            }
            return EnumBehaviorState.RUNNING;
        }
        return ((Behavior)this.children.get(0)).tick();
    }

    public boolean canBeSeen(Vec3 pos) {
        EntityLivingBase entL = (EntityLivingBase)this.ent;
        return entL.field_70170_p.func_72933_a(new Vec3(entL.field_70165_t, entL.field_70163_u + (double)entL.func_70047_e(), entL.field_70161_v), pos) == null;
    }
}

