/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.entity;

import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.Vec3;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityThrowableUsefull
extends Entity
implements IProjectile {
    int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile = null;
    protected boolean inGround = false;
    public int throwableShake = 0;
    public EntityLivingBase thrower;
    public EntityLivingBase target;
    public boolean targetSeeking = false;
    public float targetSeekAngleLimit = 5.0f;
    private String throwerName = null;
    public int ticksInGround;
    public int ticksInAir = 0;
    public int ticksMaxAlive = 120;

    public EntityThrowableUsefull(World par1World) {
        super(par1World);
        this.func_70105_a(0.25f, 0.25f);
    }

    protected void func_70088_a() {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public EntityThrowableUsefull(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase parTarget, double parSpeed) {
        super(par1World);
        this.thrower = par2EntityLivingBase;
        this.func_70105_a(0.25f, 0.25f);
        this.target = parTarget;
        Vec3 vec = this.getTargetVector(this.target);
        this.field_70159_w = vec.xCoord * parSpeed;
        this.field_70181_x = vec.yCoord * parSpeed;
        this.field_70179_y = vec.zCoord * parSpeed;
        this.func_70107_b(par2EntityLivingBase.field_70165_t, par2EntityLivingBase.field_70163_u + (double)par2EntityLivingBase.func_70047_e(), par2EntityLivingBase.field_70161_v);
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, (float)parSpeed, 0.0f);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public EntityThrowableUsefull(World par1World, EntityLivingBase par2EntityLivingBase) {
        this(par1World, par2EntityLivingBase, 1.0);
    }

    public EntityThrowableUsefull(World par1World, EntityLivingBase par2EntityLivingBase, double parSpeed) {
        super(par1World);
        this.thrower = par2EntityLivingBase;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(par2EntityLivingBase.field_70165_t, par2EntityLivingBase.field_70163_u + (double)par2EntityLivingBase.func_70047_e(), par2EntityLivingBase.field_70161_v, par2EntityLivingBase.field_70177_z, par2EntityLivingBase.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)((this.field_70125_A + this.func_70183_g()) / 180.0f * (float)Math.PI)) * f;
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, (float)parSpeed, 0.0f);
    }

    public double func_70033_W() {
        return super.func_70033_W();
    }

    public EntityThrowableUsefull(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(par2, par4, par6);
    }

    public Vec3 getTargetVector(EntityLivingBase target) {
        double vecX = target.field_70165_t - this.thrower.field_70165_t;
        double vecY = target.field_70163_u - this.thrower.field_70163_u;
        double vecZ = target.field_70161_v - this.thrower.field_70161_v;
        double dist = Math.sqrt(vecX * vecX + vecY * vecY + vecZ * vecZ);
        Vec3 vec3 = new Vec3(vecX / dist, vecY / dist, vecZ / dist);
        return vec3;
    }

    protected float func_70183_g() {
        return 0.0f;
    }

    public void func_70186_c(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)f2;
        par3 /= (double)f2;
        par5 /= (double)f2;
        par1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70159_w = par1 *= (double)par7;
        this.field_70181_x = par3 *= (double)par7;
        this.field_70179_y = par5 *= (double)par7;
        float f3 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, f) * 180.0 / Math.PI);
        }
    }

    public void func_70071_h_() {
        MovingObjectPosition temp;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.throwableShake > 0) {
            --this.throwableShake;
        }
        if (this.field_70123_F) {
            this.func_70106_y();
        }
        if (this.inGround) {
            Block i = this.field_70170_p.func_180495_p(new BlockPos(this.xTile, this.yTile, this.zTile)).func_177230_c();
            if (i == this.inTile) {
                ++this.ticksInGround;
                if (this.ticksInGround == 1200) {
                    this.func_70106_y();
                }
                return;
            }
            this.inGround = false;
            this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInAir;
        }
        if (this.field_70173_aa >= this.ticksMaxAlive) {
            this.func_70106_y();
        }
        Vec3 vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3 vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        MovingObjectPosition movingobjectposition = this.field_70170_p.func_72933_a(vec3.toMCVec(), vec31.toMCVec());
        vec3 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec31 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            vec31 = new Vec3(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
        }
        if (!this.field_70170_p.field_72995_K && (temp = this.tickEntityCollision(vec3, vec31)) != null) {
            movingobjectposition = temp;
        }
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f1) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f2 = 1.0f;
        float f3 = this.getGravityVelocity();
        if (this.func_70090_H()) {
            for (int k = 0; k < 4; ++k) {
                float f4 = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
            f2 = 0.8f;
        }
        this.field_70159_w *= (double)f2;
        this.field_70181_x *= (double)f2;
        this.field_70179_y *= (double)f2;
        this.field_70181_x -= (double)f3;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void adjustSeekMotion() {
        double speedOld = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        double vecX = this.target.field_70165_t - this.field_70165_t;
        double vecZ = this.target.field_70161_v - this.field_70161_v;
        float aimAngle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI) - 90.0f;
        float maxSpeed = 0.01f;
        float adjRate = 0.03f;
        if (this.field_70163_u < this.target.field_70163_u) {
            if (this.field_70181_x < 0.0) {
                this.field_70181_x += (double)0.01f;
            }
        } else if (this.field_70181_x > 0.0) {
            this.field_70181_x -= (double)0.01f;
        }
        if (Math.abs(this.field_70159_w) > (double)maxSpeed) {
            this.field_70159_w *= (double)0.85f;
        }
        if (Math.abs(this.field_70179_y) > (double)maxSpeed) {
            this.field_70179_y *= (double)0.85f;
        }
        this.field_70159_w = this.field_70165_t < this.target.field_70165_t ? (this.field_70159_w += (double)adjRate) : (this.field_70159_w -= (double)adjRate);
        this.field_70179_y = this.field_70161_v < this.target.field_70161_v ? (this.field_70179_y += (double)adjRate) : (this.field_70179_y -= (double)adjRate);
    }

    public void faceEntity(Entity p_70625_1_, float p_70625_2_, float p_70625_3_) {
        double d1;
        double d0 = p_70625_1_.field_70165_t - this.field_70165_t;
        double d2 = p_70625_1_.field_70161_v - this.field_70161_v;
        if (p_70625_1_ instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)p_70625_1_;
            d1 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (this.field_70163_u + (double)this.func_70047_e());
        } else {
            d1 = (p_70625_1_.func_174813_aQ().field_72338_b + p_70625_1_.func_174813_aQ().field_72337_e) / 2.0 - (this.field_70163_u + (double)this.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        this.field_70125_A = this.updateRotation(this.field_70125_A, f3, p_70625_3_);
        this.field_70177_z = this.updateRotation(this.field_70177_z, f2, p_70625_2_);
    }

    private float updateRotation(float p_70663_1_, float p_70663_2_, float p_70663_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_70663_2_ - p_70663_1_));
        if (f3 > p_70663_3_) {
            f3 = p_70663_3_;
        }
        if (f3 < -p_70663_3_) {
            f3 = -p_70663_3_;
        }
        return p_70663_1_ + f3;
    }

    public MovingObjectPosition tickEntityCollision(Vec3 vec3, Vec3 vec31) {
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
        double d0 = 0.0;
        EntityLivingBase entityliving = this.getThrower();
        for (int j = 0; j < list.size(); ++j) {
            double d1;
            Entity entity1 = (Entity)list.get(j);
            if (!entity1.func_70067_L() || entity1 == entityliving && this.ticksInAir < 5) continue;
            float f = 0.3f;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
            MovingObjectPosition movingobjectposition1 = axisalignedbb.func_72327_a(vec3.toMCVec(), vec31.toMCVec());
            if (movingobjectposition1 == null || !((d1 = vec3.toMCVec().func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            return new MovingObjectPosition(entity);
        }
        return null;
    }

    protected float getGravityVelocity() {
        return 0.03f;
    }

    protected void onImpact(MovingObjectPosition movingobjectposition) {
        this.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.xTile);
        par1NBTTagCompound.func_74777_a("yTile", (short)this.yTile);
        par1NBTTagCompound.func_74777_a("zTile", (short)this.zTile);
        par1NBTTagCompound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        par1NBTTagCompound.func_74774_a("shake", (byte)this.throwableShake);
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = CoroUtilEntity.getName((Entity)this.thrower);
        }
        par1NBTTagCompound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.func_74765_d("xTile");
        this.yTile = par1NBTTagCompound.func_74765_d("yTile");
        this.zTile = par1NBTTagCompound.func_74765_d("zTile");
        this.inTile = Block.func_149729_e((int)(par1NBTTagCompound.func_74771_c("inTile") & 0xFF));
        this.throwableShake = par1NBTTagCompound.func_74771_c("shake") & 0xFF;
        this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        this.throwerName = par1NBTTagCompound.func_74779_i("ownerName");
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public EntityLivingBase getThrower() {
        if (this.thrower == null && this.throwerName != null && this.throwerName.length() > 0) {
            this.thrower = this.field_70170_p.func_72924_a(this.throwerName);
        }
        return this.thrower;
    }
}

