/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.event;

import CoroUtil.entity.EnumJobState;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilFile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class WorldEvent {
    public int dimensionID;
    public BlockCoord coordSource;
    public BlockCoord coordDestination;
    public String mainPlayerName = "";
    public boolean invasionActive = true;
    public int ticksActive = 0;
    public int ticksMaxActive = 168000;
    public EnumWorldEventType type;
    public EnumJobState state;
    public ArrayList<EntityLivingBase> invasionEntities = new ArrayList();
    public ArrayList<String> cursedPlayers = new ArrayList();
    public int lastCheckedInvasionCount = 1;
    public float currentWaveDifficultyRating;
    public int currentWavePlayerCount;
    public int currentWaveCountFromPortal;
    public int currentWaveSpawnedInvaders;
    public int waveCount = 0;
    public int curCooldown = 800;
    public float lastLeaderDist;
    public int lastLeaderCount;

    public WorldEvent() {
        this.state = EnumJobState.IDLE;
    }

    public WorldEvent(int parDim, String parName, EnumWorldEventType parType, BlockCoord source, BlockCoord dest) {
        this();
        this.type = parType;
        this.coordSource = source;
        this.coordDestination = dest;
        this.mainPlayerName = parName;
        this.dimensionID = parDim;
        this.updateCursedPlayersList(false);
    }

    public static WorldEvent newInvasionFromNBT(NBTTagCompound par1NBTTagCompound) {
        EnumWorldEventType type = EnumWorldEventType.get(par1NBTTagCompound.func_74762_e("type"));
        WorldEvent inv = null;
        inv = new WorldEvent();
        inv.readNBT(par1NBTTagCompound);
        return inv;
    }

    public void tick() {
        WorldServer world = DimensionManager.getWorld((int)this.dimensionID);
        EntityPlayer entP = world.func_72924_a(this.mainPlayerName);
    }

    public boolean isComplete() {
        return !this.invasionActive;
    }

    public void setState(EnumJobState job) {
        this.state = job;
    }

    public boolean checkForActiveInvadersCached() {
        if (this.lastCheckedInvasionCount == 0 || DimensionManager.getWorld((int)this.dimensionID).func_72820_D() % 100L == 0L) {
            for (int i = 0; i < this.invasionEntities.size(); ++i) {
                EntityLivingBase ent = this.invasionEntities.get(i);
                if (!ent.field_70128_L) continue;
                this.invasionEntities.remove(i);
            }
            if (this.lastCheckedInvasionCount != this.invasionEntities.size() && this.invasionEntities.size() == 0) {
                this.onFirstDetectNoActiveInvaders();
            }
            this.lastCheckedInvasionCount = this.invasionEntities.size();
            return this.invasionEntities.size() != 0;
        }
        return this.lastCheckedInvasionCount > 0;
    }

    public void onFirstDetectNoActiveInvaders() {
        this.updateCursedPlayersList(false);
        this.updatePlayerStates();
        this.calculatePlayerRatingData();
    }

    public void invasionStart() {
        this.invasionActive = true;
    }

    public void invasionEnd() {
        this.invasionActive = false;
    }

    public void registerWithInvasion(EntityLivingBase ent) {
        this.invasionEntities.add(ent);
    }

    public EntityPlayer tryGetCursedPlayer(String username) {
        EntityPlayerMP entP = MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(username);
        if (entP != null && entP.field_70170_p.field_73011_w.func_177502_q() == DimensionManager.getWorld((int)this.dimensionID).field_73011_w.func_177502_q()) {
            return entP;
        }
        return null;
    }

    public void calculatePlayerRatingData() {
        WorldServer worldObj = DimensionManager.getWorld((int)this.dimensionID);
        float playersFound = 0.0f;
        float totalRating = 0.0f;
        for (int i = 0; i < this.cursedPlayers.size(); ++i) {
            EntityPlayer entP = this.tryGetCursedPlayer(this.cursedPlayers.get(i));
            if (entP == null) continue;
            playersFound += 1.0f;
        }
        int waveCount = 0;
        float playerCountAdditiveFactor = 3.0f;
        float waveCountFactor = 2.0f;
        int averagedRating = (int)(totalRating / playersFound + playersFound * playerCountAdditiveFactor + (float)waveCount * waveCountFactor);
        this.currentWaveDifficultyRating = averagedRating;
        this.currentWavePlayerCount = (int)playersFound;
        this.currentWaveCountFromPortal = waveCount;
    }

    public void updateCursedPlayersList(boolean clearList) {
        float maxDist = 96.0f;
        WorldServer worldObj = DimensionManager.getWorld((int)this.dimensionID);
        if (clearList) {
            this.cursedPlayers.clear();
        }
        for (int i = 0; i < worldObj.field_73010_i.size(); ++i) {
            EntityPlayer entP = (EntityPlayer)worldObj.field_73010_i.get(i);
            if (this.cursedPlayers.contains(CoroUtilEntity.getName((Entity)entP)) || !(entP.func_70011_f((double)this.coordDestination.posX, (double)this.coordDestination.posY, (double)this.coordDestination.posZ) < (double)maxDist)) continue;
            this.cursedPlayers.add(CoroUtilEntity.getName((Entity)entP));
        }
    }

    public void updatePlayerStates() {
        for (int i = 0; i < this.cursedPlayers.size(); ++i) {
            float armorValue = 0.0f;
            float bestWeaponValue = 0.0f;
            boolean hasGlove = false;
            EntityPlayer entP = this.tryGetCursedPlayer(this.cursedPlayers.get(i));
            if (entP == null) continue;
            for (int armorIndex = 0; armorIndex < 4; ++armorIndex) {
                if (entP.field_71071_by.field_70460_b[armorIndex] == null || !(entP.field_71071_by.field_70460_b[armorIndex].func_77973_b() instanceof ItemArmor)) continue;
                armorValue += (float)EnchantmentHelper.func_77508_a((ItemStack[])entP.field_71071_by.field_70460_b, (DamageSource)DamageSource.field_76377_j);
            }
            ItemStack itemstack = entP.field_71071_by.func_70448_g();
            if (itemstack != null) {
                entP.func_110140_aT().func_111148_a(itemstack.func_111283_C());
            }
            for (int slotIndex = 0; slotIndex < entP.field_71071_by.field_70462_a.length; ++slotIndex) {
                if (entP.field_71071_by.field_70462_a[slotIndex] == null) continue;
                itemstack = entP.field_71071_by.field_70462_a[slotIndex];
                if (itemstack != null) {
                    entP.func_110140_aT().func_111147_b(itemstack.func_111283_C());
                }
                float f = (float)entP.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                float f1 = 0.0f;
                if (entP instanceof EntityLivingBase) {
                    // empty if block
                }
                float dmg = f + f1;
                if (itemstack != null) {
                    entP.func_110140_aT().func_111148_a(itemstack.func_111283_C());
                }
                if (!(dmg > bestWeaponValue)) continue;
                bestWeaponValue = dmg;
            }
            itemstack = entP.field_71071_by.func_70448_g();
            if (itemstack == null) continue;
            entP.func_110140_aT().func_111147_b(itemstack.func_111283_C());
        }
    }

    public void writeNBT(NBTTagCompound data) {
        data.func_74776_a("currentWaveDifficultyRating", this.currentWaveDifficultyRating);
        data.func_74768_a("dimensionID", this.dimensionID);
        data.func_74768_a("type", this.type.ordinal());
        if (this.coordSource != null) {
            CoroUtilFile.writeCoords("source", this.coordSource, data);
        }
        if (this.coordDestination != null) {
            CoroUtilFile.writeCoords("dest", this.coordDestination, data);
        }
        data.func_74768_a("ticksActive", this.ticksActive);
        data.func_74768_a("ticksMaxActive", this.ticksMaxActive);
        data.func_74768_a("waveCount", this.waveCount);
        data.func_74778_a("mainPlayerName", this.mainPlayerName);
        data.func_74768_a("state", this.state.ordinal());
        data.func_74768_a("currentWaveCountFromPortal", this.currentWaveCountFromPortal);
        data.func_74768_a("currentWaveSpawnedInvaders", this.currentWaveSpawnedInvaders);
        data.func_74768_a("currentWavePlayerCount", this.currentWavePlayerCount);
        int dist = -1;
        if (this.coordDestination != null && this.invasionEntities.size() > 0) {
            dist = (int)this.invasionEntities.get(0).func_70011_f((double)this.coordDestination.posX, (double)this.coordDestination.posY, (double)this.coordDestination.posZ);
        }
        data.func_74768_a("lastLeaderDist", dist);
        data.func_74768_a("lastLeaderCount", this.invasionEntities.size());
        data.func_74768_a("curCooldown", this.curCooldown);
    }

    public void readNBT(NBTTagCompound data) {
        this.currentWaveDifficultyRating = data.func_74760_g("currentWaveDifficultyRating");
        this.dimensionID = data.func_74762_e("dimensionID");
        this.type = EnumWorldEventType.get(data.func_74762_e("type"));
        this.coordSource = CoroUtilFile.readCoords("source", data);
        this.coordDestination = CoroUtilFile.readCoords("dest", data);
        this.ticksActive = data.func_74762_e("ticksActive");
        this.ticksMaxActive = data.func_74762_e("ticksMaxActive");
        this.waveCount = data.func_74762_e("waveCount");
        this.mainPlayerName = data.func_74779_i("mainPlayerName");
        this.state = EnumJobState.get(data.func_74762_e("state"));
        this.currentWaveCountFromPortal = data.func_74762_e("currentWaveCountFromPortal");
        this.currentWaveSpawnedInvaders = data.func_74762_e("currentWaveSpawnedInvaders");
        this.currentWavePlayerCount = data.func_74762_e("currentWavePlayerCount");
        this.lastLeaderDist = data.func_74762_e("lastLeaderDist");
        this.lastLeaderCount = data.func_74762_e("lastLeaderCount");
        this.curCooldown = data.func_74762_e("curCooldown");
    }

    public void init() {
    }

    public void cleanup() {
    }

    public static enum EnumWorldEventType {
        INV_PORTAL_CATACOMBS,
        INV_PORTAL_NETHER,
        INV_CAVE,
        BOSS_CATACOMBS;

        public String[] eventEnumToName = new String[]{"Portal Invasion", "Nether Invasion", "Cave Invasion", "Boss Event"};
        private static final Map<Integer, EnumWorldEventType> lookup;

        public static EnumWorldEventType get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, EnumWorldEventType>();
            for (EnumWorldEventType e : EnumSet.allOf(EnumWorldEventType.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }
}

