/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.config.ConfigCoroAI;
import CoroUtil.diplomacy.TeamTypes;
import CoroUtil.forge.CommandCoroUtil;
import CoroUtil.forge.CommonProxy;
import CoroUtil.forge.EventHandlerFML;
import CoroUtil.forge.EventHandlerForge;
import CoroUtil.forge.EventHandlerPacket;
import CoroUtil.pets.PetsManager;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.util.CoroUtilFile;
import CoroUtil.world.WorldDirectorManager;
import com.google.common.collect.BiMap;
import java.util.Map;
import modconfig.ConfigMod;
import net.minecraft.command.ICommand;
import net.minecraft.entity.EntityList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

@Mod(modid="CoroAI", name="CoroAI", version="v1.1.5", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.8.9]")
public class CoroAI {
    @Mod.Instance(value="CoroAI")
    public static CoroAI instance;
    public static String modID;
    @SidedProxy(clientSide="CoroUtil.forge.ClientProxy", serverSide="CoroUtil.forge.CommonProxy")
    public static CommonProxy proxy;
    public static boolean initProperNeededForInstance;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigMod.addConfigFile(event, "coroai", new ConfigCoroAI());
        eventChannel.register((Object)new EventHandlerPacket());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new EventHandlerFML());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
        proxy.init(this);
        TeamTypes.initTypes();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        boolean debugOutputEntityRegistrations = false;
        if (debugOutputEntityRegistrations) {
            try {
                BiMap entityClassRegistrations = (BiMap)ObfuscationReflectionHelper.getPrivateValue(EntityRegistry.class, (Object)EntityRegistry.instance(), (String[])new String[]{"entityClassRegistrations"});
                for (EntityRegistry.EntityRegistration entReg : entityClassRegistrations.values()) {
                }
                for (Map.Entry entReg : EntityList.field_75625_b.entrySet()) {
                    System.out.println((String)entReg.getKey() + " - " + entReg.getValue());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCoroUtil());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        CoroAI.writeOutData(true);
        initProperNeededForInstance = true;
    }

    public static void initTry() {
        if (initProperNeededForInstance) {
            System.out.println("CoroUtil being reinitialized");
            initProperNeededForInstance = false;
            CoroUtilFile.getWorldFolderName();
            PetsManager.instance().nbtReadFromDisk();
            WorldDirectorManager.instance().reset();
        }
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            PetsManager.instance().nbtWriteToDisk();
            if (unloadInstances) {
                PetsManager.instance().reset();
            }
            PlayerQuestManager.i().saveData(false, unloadInstances);
            WorldDirectorManager.instance().writeToFile(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void dbg(Object obj) {
        System.out.println(obj);
    }

    static {
        modID = "coroutil";
        initProperNeededForInstance = true;
        eventChannelName = "coroutil";
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
    }
}

