/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.forge;

import CoroUtil.componentAI.ICoroAI;
import CoroUtil.entity.IEntityPacket;
import CoroUtil.packet.INBTPacketHandler;
import CoroUtil.packet.NBTDataManager;
import CoroUtil.packet.PacketHelper;
import CoroUtil.quest.PlayerQuestManager;
import CoroUtil.quest.PlayerQuests;
import CoroUtil.tile.ITilePacket;
import CoroUtil.util.CoroUtilEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EventHandlerPacket {
    @SideOnly(value=Side.CLIENT)
    public World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public INBTPacketHandler getClientDataInterface() {
        if (Minecraft.func_71410_x().field_71462_r instanceof INBTPacketHandler) {
            return (INBTPacketHandler)Minecraft.func_71410_x().field_71462_r;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPacketFromServer(FMLNetworkEvent.ClientCustomPacketEvent event) {
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound(event.packet.payload());
            String command = nbt.func_74779_i("command");
            if (command.equals("CoroAI_Inv")) {
                int entID = nbt.func_74762_e("entID");
                ItemStack is = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemstack"));
                Entity entity = this.getClientWorld().func_73045_a(entID);
                if (entity instanceof ICoroAI && entity instanceof EntityLivingBase) {
                    ((EntityLivingBase)entity).func_70062_b(0, is);
                }
            } else if (!command.equals("CoroAI_TEntDW")) {
                if (command.equals("NBTData_GUI")) {
                    NBTDataManager.nbtDataFromServer(nbt);
                } else if (command.equals("NBTData_CONT")) {
                    INBTPacketHandler nbtHandler = this.getClientDataInterface();
                    if (nbtHandler != null) {
                        nbtHandler.nbtDataFromServer(nbt);
                    }
                } else if (command.equals("CoroAI_Ent")) {
                    int entID = nbt.func_74762_e("entityID");
                    Entity entity = this.getClientWorld().func_73045_a(entID);
                    if (entity instanceof IEntityPacket) {
                        ((IEntityPacket)entity).handleNBTFromServer(nbt);
                    }
                } else if (command.equals("QuestData")) {
                    NBTTagCompound data = nbt.func_74775_l("data");
                    PlayerQuests quests = PlayerQuestManager.i().getPlayerQuests(this.getClientPlayer());
                    quests.reset();
                    quests.nbtLoad(data);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPacketFromClient(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP entP = ((NetHandlerPlayServer)event.handler).field_147369_b;
        try {
            NBTTagCompound nbt = PacketHelper.readNBTTagCompound(event.packet.payload());
            String command = nbt.func_74779_i("command");
            if (command.equals("CoroAI_TEntCmd")) {
                TileEntity tEnt;
                int dimID = nbt.func_74762_e("dimID");
                int x = nbt.func_74762_e("x");
                int y = nbt.func_74762_e("y");
                int z = nbt.func_74762_e("z");
                NBTTagCompound nbtData = nbt.func_74775_l("data");
                WorldServer world = DimensionManager.getWorld((int)dimID);
                if (world != null && (tEnt = world.func_175625_s(new BlockPos(x, y, z))) instanceof ITilePacket) {
                    System.out.println("CONFIRM THIS SHOULD BE nbtData and not just nbt var");
                    ((ITilePacket)tEnt).handleClientSentNBT(CoroUtilEntity.getName((Entity)entP), nbtData);
                }
            } else if (command.equals("NBTData_CONT")) {
                if (entP.field_71070_bA instanceof INBTPacketHandler) {
                    ((INBTPacketHandler)entP.field_71070_bA).nbtDataFromClient(CoroUtilEntity.getName((Entity)entP), nbt);
                }
            } else if (command.equals("NBTData_GUI")) {
                NBTDataManager.nbtDataFromClient(CoroUtilEntity.getName((Entity)entP), nbt);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

