/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.formation;

import CoroUtil.util.CoroUtilBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PathNavigateFormation {
    public float width = 1.0f;
    public float height = 2.0f;
    private World worldObj;
    public Vec3 pos;
    public EntityMoveHelper moveHelper;
    private PathEntity currentPath;
    private float speed;
    private float pathSearchRange;
    private boolean noSunPathfind = false;
    private int totalTicks;
    private int ticksAtLastPos;
    private Vec3 lastPosCheck = new Vec3(0.0, 0.0, 0.0);
    private boolean canPassOpenWoodenDoors = true;
    private boolean canPassClosedWoodenDoors = false;
    private boolean avoidsWater = false;
    private boolean canSwim = false;

    public PathNavigateFormation(float parWidth, float parHeight, World par2World, float par3) {
        this.width = parWidth;
        this.height = parHeight;
        this.worldObj = par2World;
        this.pathSearchRange = par3;
    }

    public void setAvoidsWater(boolean par1) {
        this.avoidsWater = par1;
    }

    public boolean getAvoidsWater() {
        return this.avoidsWater;
    }

    public void setBreakDoors(boolean par1) {
        this.canPassClosedWoodenDoors = par1;
    }

    public void setEnterDoors(boolean par1) {
        this.canPassOpenWoodenDoors = par1;
    }

    public boolean getCanBreakDoors() {
        return this.canPassClosedWoodenDoors;
    }

    public void setAvoidSun(boolean par1) {
        this.noSunPathfind = par1;
    }

    public void setSpeed(float par1) {
        this.speed = par1;
    }

    public void setCanSwim(boolean par1) {
        this.canSwim = par1;
    }

    public boolean setPath(PathEntity par1PathEntity, float par2) {
        if (par1PathEntity == null) {
            this.currentPath = null;
            return false;
        }
        if (!par1PathEntity.func_75876_a(this.currentPath)) {
            this.currentPath = par1PathEntity;
        }
        if (this.noSunPathfind) {
            this.removeSunnyPath();
        }
        if (this.currentPath.func_75874_d() == 0) {
            return false;
        }
        this.speed = par2;
        Vec3 vec3 = this.getEntityPosition();
        this.ticksAtLastPos = this.totalTicks;
        this.lastPosCheck = vec3;
        return true;
    }

    public PathEntity getPath() {
        return this.currentPath;
    }

    public Vec3 getVectorFromIndex(int par2) {
        double d0 = (double)this.currentPath.func_75877_a((int)par2).field_75839_a + (double)((int)(this.width + 1.0f)) * 0.5;
        double d1 = this.currentPath.func_75877_a((int)par2).field_75837_b;
        double d2 = (double)this.currentPath.func_75877_a((int)par2).field_75838_c + (double)((int)(this.width + 1.0f)) * 0.5;
        return new Vec3(d0, d1, d2);
    }

    public void onUpdateNavigation() {
        ++this.totalTicks;
        if (!this.noPath()) {
            Vec3 vec3;
            if (this.canNavigate()) {
                this.pathFollow();
            }
            if (!this.noPath() && (vec3 = this.getVectorFromIndex(this.currentPath.func_75873_e())) != null) {
                this.moveHelper.func_75642_a(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c, (double)this.speed);
            }
        }
    }

    private void pathFollow() {
        int k;
        Vec3 vec3 = this.getEntityPosition();
        int i = this.currentPath.func_75874_d();
        for (int j = this.currentPath.func_75873_e(); j < this.currentPath.func_75874_d(); ++j) {
            if (this.currentPath.func_75877_a((int)j).field_75837_b == (int)vec3.field_72448_b) continue;
            i = j;
            break;
        }
        float f = this.width * this.width;
        for (k = this.currentPath.func_75873_e(); k < i; ++k) {
            if (!(vec3.func_72436_e(this.getVectorFromIndex(k)) < (double)f)) continue;
            this.currentPath.func_75872_c(k + 1);
        }
        k = MathHelper.func_76123_f((float)this.width);
        int l = (int)this.height + 1;
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.currentPath.func_75873_e(); --j1) {
            if (!this.isDirectPathBetweenPoints(vec3, this.getVectorFromIndex(j1), k, l, i1)) continue;
            this.currentPath.func_75872_c(j1);
            break;
        }
        if (this.totalTicks - this.ticksAtLastPos > 100) {
            if (vec3.func_72436_e(this.lastPosCheck) < 2.25) {
                this.clearPathEntity();
            }
            this.ticksAtLastPos = this.totalTicks;
            this.lastPosCheck = vec3;
        }
    }

    public boolean noPath() {
        return this.currentPath == null || this.currentPath.func_75879_b();
    }

    public void clearPathEntity() {
        this.currentPath = null;
    }

    private Vec3 getEntityPosition() {
        return this.pos;
    }

    private boolean canNavigate() {
        return true;
    }

    private boolean isInFluid() {
        return false;
    }

    private void removeSunnyPath() {
    }

    private boolean isDirectPathBetweenPoints(Vec3 par1Vec3, Vec3 par2Vec3, int par3, int par4, int par5) {
        int l = MathHelper.func_76128_c((double)par1Vec3.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)par1Vec3.field_72449_c);
        double d0 = par2Vec3.field_72450_a - par1Vec3.field_72450_a;
        double d1 = par2Vec3.field_72449_c - par1Vec3.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(l, (int)par1Vec3.field_72448_b, i1, par3 += 2, par4, par5 += 2, par1Vec3, d0 *= d3, d1 *= d3)) {
            return false;
        }
        par3 -= 2;
        par5 -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)(l * 1) - par1Vec3.field_72450_a;
        double d7 = (double)(i1 * 1) - par1Vec3.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int j1 = d0 < 0.0 ? -1 : 1;
        int k1 = d1 < 0.0 ? -1 : 1;
        int l1 = MathHelper.func_76128_c((double)par2Vec3.field_72450_a);
        int i2 = MathHelper.func_76128_c((double)par2Vec3.field_72449_c);
        int j2 = l1 - l;
        int k2 = i2 - i1;
        do {
            if (j2 * j1 <= 0 && k2 * k1 <= 0) {
                return true;
            }
            if (d6 < d7) {
                d6 += d4;
                j2 = l1 - (l += j1);
                continue;
            }
            d7 += d5;
            k2 = i2 - (i1 += k1);
        } while (this.isSafeToStandAt(l, (int)par1Vec3.field_72448_b, i1, par3, par4, par5, par1Vec3, d0, d1));
        return false;
    }

    private boolean isSafeToStandAt(int par1, int par2, int par3, int par4, int par5, int par6, Vec3 par7Vec3, double par8, double par10) {
        int k1 = par1 - par4 / 2;
        int l1 = par3 - par6 / 2;
        if (!this.isPositionClear(k1, par2, l1, par4, par5, par6, par7Vec3, par8, par10)) {
            return false;
        }
        for (int i2 = k1; i2 < k1 + par4; ++i2) {
            for (int j2 = l1; j2 < l1 + par6; ++j2) {
                double d2 = (double)i2 + 0.5 - par7Vec3.field_72450_a;
                double d3 = (double)j2 + 0.5 - par7Vec3.field_72449_c;
                if (!(d2 * par8 + d3 * par10 >= 0.0)) continue;
                Block k2 = this.worldObj.func_180495_p(new BlockPos(i2, par2 - 1, j2)).func_177230_c();
                if (CoroUtilBlock.isAir(k2)) {
                    return false;
                }
                Material material = k2.func_149688_o();
                if (material != Material.field_151587_i) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isPositionClear(int p_179692_1_, int p_179692_2_, int p_179692_3_, int p_179692_4_, int p_179692_5_, int p_179692_6_, Vec3 p_179692_7_, double p_179692_8_, double p_179692_10_) {
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)new BlockPos(p_179692_1_, p_179692_2_, p_179692_3_), (BlockPos)new BlockPos(p_179692_1_ + p_179692_4_ - 1, p_179692_2_ + p_179692_5_ - 1, p_179692_3_ + p_179692_6_ - 1))) {
            Block block;
            double d1;
            double d0 = (double)blockpos.func_177958_n() + 0.5 - p_179692_7_.field_72450_a;
            if (!(d0 * p_179692_8_ + (d1 = (double)blockpos.func_177952_p() + 0.5 - p_179692_7_.field_72449_c) * p_179692_10_ >= 0.0) || (block = this.worldObj.func_180495_p(blockpos).func_177230_c()).func_176205_b((IBlockAccess)this.worldObj, blockpos)) continue;
            return false;
        }
        return true;
    }
}

