/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest.quests;

import CoroUtil.quest.EnumQuestState;
import CoroUtil.quest.PlayerQuests;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ActiveQuest {
    public PlayerQuests playerQuests;
    public int dimIDCreatedIn = 0;
    public String questType = "baseQuestObject";
    public EnumQuestState curState = EnumQuestState.ASSIGNED;
    public boolean returnToQuestGiver;
    public String modOwner = "";

    public void initFirstTime(int parDimensionID) {
        this.dimIDCreatedIn = parDimensionID;
    }

    public void initCreateObject(PlayerQuests parPlQuests) {
        this.playerQuests = parPlQuests;
    }

    public void initCreateLoad() {
    }

    public void initCustomData() {
    }

    public void reset() {
    }

    public void tick() {
    }

    public void saveAndSync() {
        this.playerQuests.saveAndSyncAllPlayers();
    }

    public void load(NBTTagCompound parNBT) {
        this.curState = EnumQuestState.get(parNBT.func_74762_e("curState"));
        this.dimIDCreatedIn = parNBT.func_74762_e("dimIDCreatedIn");
        this.modOwner = parNBT.func_74779_i("modOwner");
        this.returnToQuestGiver = parNBT.func_74767_n("returnToQuestGiver");
    }

    public void save(NBTTagCompound parNBT) {
        parNBT.func_74778_a("classNamePath", this.getClass().getCanonicalName());
        parNBT.func_74768_a("curState", this.curState.ordinal());
        parNBT.func_74768_a("dimIDCreatedIn", this.dimIDCreatedIn);
        parNBT.func_74778_a("modOwner", this.modOwner);
        parNBT.func_74757_a("returnToQuestGiver", this.returnToQuestGiver);
    }

    public void setState(EnumQuestState state) {
        this.curState = state;
        this.saveAndSync();
    }

    public boolean isPlayerInOriginalDimension() {
        return this.dimIDCreatedIn == this.playerQuests.getWorld().field_73011_w.func_177502_q();
    }

    public boolean isComplete() {
        return this.curState == EnumQuestState.COMPLETE;
    }

    public void eventComplete() {
        this.setState(EnumQuestState.COMPLETE);
    }

    public void onEvent(Event event) {
    }

    public String toString() {
        return this.questType;
    }

    public String getTitle() {
        return this.toString();
    }

    public List<String> getInstructions(List<String> parList) {
        if (parList == null) {
            parList = new ArrayList<String>();
        }
        parList.add("<missing instructions>");
        return parList;
    }

    public List<String> getInfoProgress(List<String> parList) {
        if (parList == null) {
            parList = new ArrayList<String>();
        }
        parList.add("<missing progress info>");
        return parList;
    }
}

