/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.quest.quests;

import CoroUtil.quest.EnumQuestState;
import CoroUtil.quest.quests.ActiveQuest;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.CoroUtilNBT;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BreakBlockQuest
extends ActiveQuest {
    public BlockCoord blockCoords;
    public String blockType;
    public int blockCountNeeded = -1;
    public int blockCountCurrent = 0;

    public BreakBlockQuest() {
        this.questType = "breakBlock";
    }

    public void initCustomData(BlockCoord parCoords, Block parBlock) {
        super.initCustomData();
        this.blockCoords = parCoords;
        this.blockType = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)parBlock)).toString();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.curState == EnumQuestState.ASSIGNED) {
            if (this.blockCountNeeded != -1 && this.blockCountCurrent >= this.blockCountNeeded) {
                if (this.returnToQuestGiver) {
                    this.setState(EnumQuestState.CONCLUDING);
                } else {
                    this.eventComplete();
                }
            }
        } else if (this.curState == EnumQuestState.CONCLUDING) {
            // empty if block
        }
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof BlockEvent.BreakEvent) {
            this.handleEvent((BlockEvent.BreakEvent)event);
        }
    }

    public void handleEvent(BlockEvent.BreakEvent event) {
        if (event.getPlayer() == null || !CoroUtilEntity.getName((Entity)event.getPlayer()).equals(this.playerQuests.playerName)) {
            return;
        }
        if (this.getBlock() != null && this.getBlock() != event.state.func_177230_c()) {
            return;
        }
        if (this.blockCoords != null && (this.blockCoords.posX != event.pos.func_177958_n() || this.blockCoords.posY != event.pos.func_177956_o() || this.blockCoords.posZ != event.pos.func_177952_p())) {
            return;
        }
        if (this.blockCountNeeded != -1) {
            ++this.blockCountCurrent;
        } else {
            this.eventComplete();
        }
        this.saveAndSync();
    }

    public Block getBlock() {
        return (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(this.blockType));
    }

    @Override
    public void load(NBTTagCompound parNBT) {
        super.load(parNBT);
        this.blockCountNeeded = parNBT.func_74762_e("blockCountNeeded");
        this.blockCountCurrent = parNBT.func_74762_e("blockCountCurrent");
        this.blockCoords = CoroUtilNBT.readCoords("blockCoords", parNBT);
        this.blockType = parNBT.func_74779_i("blockType");
    }

    @Override
    public void save(NBTTagCompound parNBT) {
        super.save(parNBT);
        parNBT.func_74768_a("blockCountNeeded", this.blockCountNeeded);
        parNBT.func_74768_a("blockCountCurrent", this.blockCountCurrent);
        CoroUtilNBT.writeCoords("blockCoords", this.blockCoords, parNBT);
        parNBT.func_74778_a("blockType", this.blockType);
    }
}

