/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.util.BlockCoord;
import CoroUtil.util.CoroUtilBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CoroUtilPath {
    public static PathEntity getSingleNodePath(BlockCoord coords) {
        PathPoint[] points = new PathPoint[]{new PathPoint(coords.posX, coords.posY, coords.posZ)};
        PathEntity pe = new PathEntity(points);
        return pe;
    }

    public static boolean tryMoveToEntityLivingLongDist(EntityCreature entSource, Entity entityTo, double moveSpeedAmp) {
        return CoroUtilPath.tryMoveToXYZLongDist(entSource, entityTo.field_70165_t, entityTo.func_174813_aQ().field_72338_b, entityTo.field_70161_v, moveSpeedAmp);
    }

    public static boolean tryMoveToXYZLongDist(EntityCreature ent, double x, double y, double z, double moveSpeedAmp) {
        World world = ent.field_70170_p;
        boolean success = false;
        if (ent.func_70661_as().func_75500_f()) {
            double followDist;
            double distToPlayer = ent.func_70011_f(x, y, z);
            if (distToPlayer <= (followDist = ent.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e())) {
                success = ent.func_70661_as().func_75492_a(x, y, z, moveSpeedAmp);
            } else {
                int tries;
                double d = x + 0.5 - ent.field_70165_t;
                double d2 = z + 0.5 - ent.field_70161_v;
                double d1 = y + 0.5 - (ent.field_70163_u + (double)ent.func_70047_e());
                double d3 = MathHelper.func_76133_a((double)(d * d + d2 * d2));
                float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
                float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
                float rotationPitch = -f3;
                float rotationYaw = f2;
                EntityCreature center = ent;
                Random rand = world.field_73012_v;
                float randLook = rand.nextInt(90) - 45;
                double dist = followDist * 0.75 + (double)rand.nextInt((int)followDist / 2);
                int gatherX = (int)Math.floor(center.field_70165_t + -Math.sin((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                int gatherY = (int)center.field_70163_u;
                int gatherZ = (int)Math.floor(center.field_70161_v + Math.cos((rotationYaw + randLook) / 180.0f * (float)Math.PI) * dist);
                Block block = world.func_180495_p(new BlockPos(gatherX, gatherY, gatherZ)).func_177230_c();
                if (!CoroUtilBlock.isAir(block)) {
                    int offset = -5;
                    for (tries = 0; tries < 30 && !CoroUtilBlock.isAir(block) && block.isSideSolid((IBlockAccess)world, new BlockPos(gatherX, gatherY, gatherZ), EnumFacing.UP); ++tries) {
                        block = world.func_180495_p(new BlockPos(gatherX, gatherY += offset++, gatherZ)).func_177230_c();
                    }
                } else {
                    while (tries < 30 && (CoroUtilBlock.isAir(block) || !block.isSideSolid((IBlockAccess)world, new BlockPos(gatherX, gatherY, gatherZ), EnumFacing.UP))) {
                        block = world.func_180495_p(new BlockPos(gatherX, --gatherY, gatherZ)).func_177230_c();
                        ++tries;
                    }
                }
                if (tries < 30) {
                    success = ent.func_70661_as().func_75492_a((double)gatherX, (double)gatherY, (double)gatherZ, moveSpeedAmp);
                }
            }
        }
        return success;
    }
}

