/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world;

import CoroUtil.forge.CoroAI;
import CoroUtil.world.WorldDirector;
import CoroUtil.world.grid.block.BlockDataGrid;
import CoroUtil.world.grid.chunk.ChunkDataGrid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class WorldDirectorManager {
    private List<BlockDataGrid> listGridsBlocks = new ArrayList<BlockDataGrid>();
    private List<ChunkDataGrid> listGridsChunks = new ArrayList<ChunkDataGrid>();
    private HashMap<Integer, BlockDataGrid> lookupGridsBlockData = new HashMap();
    private HashMap<Integer, ChunkDataGrid> lookupGridsChunkData = new HashMap();
    private HashMap<String, HashMap<Integer, WorldDirector>> lookupWorldDirectors = new HashMap();
    private List<WorldDirector> listWorldDirectors = new ArrayList<WorldDirector>();
    private static WorldDirectorManager instanceServer;
    private static WorldDirectorManager instanceClient;
    public static String EPOCHDIM_OVERWORLD_NAME;
    public static int EPOCHDIM_OVERWORLD_ID;
    public static String EPOCHDIM_DUNGEON_NAME;

    public static WorldDirectorManager instance() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (instanceServer == null) {
                instanceServer = new WorldDirectorManager();
            }
            return instanceServer;
        }
        return null;
    }

    public WorldDirectorManager() {
        this.reset();
    }

    public WorldDirector getCoroUtilWorldDirector(World world) {
        WorldDirector wd = this.getWorldDirector(CoroAI.modID, world);
        if (wd == null) {
            wd = new WorldDirector(true);
            WorldDirectorManager.instance().registerWorldDirector(wd, CoroAI.modID, world);
        }
        return wd;
    }

    public WorldDirector getWorldDirector(String parModID, World world) {
        HashMap<Integer, WorldDirector> lookup;
        int dimID = world.field_73011_w.func_177502_q();
        if (this.lookupWorldDirectors.containsKey(parModID) && (lookup = this.lookupWorldDirectors.get(parModID)).containsKey(dimID)) {
            return lookup.get(dimID);
        }
        return null;
    }

    public void registerWorldDirector(WorldDirector worldDirector, String parModID, World world) {
        int dimID = world.field_73011_w.func_177502_q();
        HashMap<Integer, WorldDirector> lookup = this.lookupWorldDirectors.get(parModID);
        if (lookup == null) {
            lookup = new HashMap();
            this.lookupWorldDirectors.put(parModID, lookup);
        }
        lookup.put(dimID, worldDirector);
        this.listWorldDirectors.add(worldDirector);
        worldDirector.initData(parModID, world);
        worldDirector.tryReadFromFile();
    }

    public void reset() {
        int i;
        Iterator<WorldDirector> it = this.listWorldDirectors.iterator();
        while (it.hasNext()) {
            it.next().reset();
        }
        for (i = 0; i < this.listGridsBlocks.size(); ++i) {
            this.listGridsBlocks.get((int)i).grid.clear();
        }
        this.listGridsBlocks.clear();
        for (i = 0; i < this.listGridsChunks.size(); ++i) {
            this.listGridsChunks.get((int)i).grid.clear();
        }
        this.listGridsChunks.clear();
        this.lookupGridsBlockData.clear();
        this.lookupGridsChunkData.clear();
    }

    public void addGridBlockData(int parDimID, BlockDataGrid parGrid) {
        this.listGridsBlocks.add(parGrid);
        this.lookupGridsBlockData.put(parDimID, parGrid);
    }

    public BlockDataGrid getBlockDataGrid(World world) {
        if (this.lookupGridsBlockData.containsKey(world.field_73011_w.func_177502_q())) {
            return this.lookupGridsBlockData.get(world.field_73011_w.func_177502_q());
        }
        BlockDataGrid grid = new BlockDataGrid(world);
        grid.readFromFile();
        this.addGridBlockData(world.field_73011_w.func_177502_q(), grid);
        return grid;
    }

    public void addGridChunkData(int parDimID, ChunkDataGrid parGrid) {
        this.listGridsChunks.add(parGrid);
        this.lookupGridsChunkData.put(parDimID, parGrid);
    }

    public ChunkDataGrid getChunkDataGrid(World world) {
        if (this.lookupGridsChunkData.containsKey(world.field_73011_w.func_177502_q())) {
            return this.lookupGridsChunkData.get(world.field_73011_w.func_177502_q());
        }
        ChunkDataGrid grid = new ChunkDataGrid(world);
        grid.readFromFile();
        this.addGridChunkData(world.field_73011_w.func_177502_q(), grid);
        return grid;
    }

    public void onTick() {
        for (WorldDirector wd : this.listWorldDirectors) {
            if (DimensionManager.getWorld((int)wd.dimID) == null) continue;
            wd.tick();
        }
    }

    public void resetDynamicDimData() {
    }

    public void initDynamicDimData(World world) {
        this.initDynamicDimData(world.field_73011_w.func_177502_q());
    }

    public void initDynamicDimData(int dimID) {
    }

    public void writeToFile(boolean unloadInstances) {
        try {
            int i;
            Iterator<WorldDirector> it = this.listWorldDirectors.iterator();
            while (it.hasNext()) {
                it.next().writeToFile(unloadInstances);
            }
            for (i = 0; i < this.listGridsBlocks.size(); ++i) {
                this.listGridsBlocks.get(i).writeToFile(unloadInstances);
            }
            for (i = 0; i < this.listGridsChunks.size(); ++i) {
                this.listGridsChunks.get(i).writeToFile(unloadInstances);
            }
            if (unloadInstances) {
                this.listGridsBlocks.clear();
                this.lookupWorldDirectors.clear();
                this.listGridsBlocks.clear();
                this.lookupGridsBlockData.clear();
                this.listGridsChunks.clear();
                this.lookupGridsChunkData.clear();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        EPOCHDIM_OVERWORLD_NAME = "epoch_overworld";
        EPOCHDIM_OVERWORLD_ID = -64;
        EPOCHDIM_DUNGEON_NAME = "epoch_dungeon";
    }
}

