/*
 * Decompiled with CFR 0.152.
 */
package modconfig;

import CoroUtil.OldUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import modconfig.ConfigComment;
import modconfig.ConfigComparatorName;
import modconfig.ConfigEntryInfo;
import modconfig.IConfigCategory;
import modconfig.ModConfigData;
import modconfig.forge.CommandModConfig;
import modconfig.forge.EventHandlerPacket;
import net.minecraft.command.ICommand;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="ConfigMod", name="Extended Mod Config", version="v1.0", useMetadata=false, acceptedMinecraftVersions="[1.8.9]")
public class ConfigMod {
    @Mod.Instance(value="ConfigMod")
    public static ConfigMod instance;
    public static List<ModConfigData> configs;
    public static List<ModConfigData> liveEditConfigs;
    public static HashMap<String, ModConfigData> configLookup;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
        ((ServerCommandManager)FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D()).func_71560_a((ICommand)new CommandModConfig());
    }

    @Mod.EventHandler
    private static void preInit(FMLPreInitializationEvent event) {
        eventChannel.register((Object)new EventHandlerPacket());
    }

    @Mod.EventHandler
    private static void init(FMLInitializationEvent event) {
    }

    public static void populateData(String modid) {
        ConfigMod.configLookup.get((Object)modid).configData.clear();
        ModConfigData data = configLookup.get(modid);
        if (data != null) {
            ConfigMod.processHashMap(modid, data.valsInteger);
            ConfigMod.processHashMap(modid, data.valsDouble);
            ConfigMod.processHashMap(modid, data.valsBoolean);
            ConfigMod.processHashMap(modid, data.valsString);
        } else {
            System.out.println("error: cant find config data for gui");
        }
        Collections.sort(ConfigMod.configLookup.get((Object)modid).configData, new ConfigComparatorName());
    }

    public static void processHashMap(String modid, Map map) {
        for (Map.Entry pairs : map.entrySet()) {
            String name = (String)pairs.getKey();
            Object val = pairs.getValue();
            String comment = ConfigMod.getComment(modid, name);
            ConfigEntryInfo info = new ConfigEntryInfo(ConfigMod.configLookup.get((Object)modid).configData.size(), name, val, comment);
            ConfigMod.configLookup.get((Object)modid).configData.add(info);
        }
    }

    public void initData() {
    }

    public void writeConfigFiles(Boolean resetData) {
    }

    public static String getSaveFolderPath() {
        if (MinecraftServer.func_71276_C() == null || MinecraftServer.func_71276_C().func_71264_H()) {
            return ConfigMod.getClientSidePath() + File.separator;
        }
        return new File(".").getAbsolutePath() + File.separator;
    }

    @SideOnly(value=Side.CLIENT)
    public static String getClientSidePath() {
        return FMLClientHandler.instance().getClient().field_71412_D.getPath();
    }

    public static void dbg(Object obj) {
        System.out.println(obj);
    }

    public static void addConfigFile(FMLPreInitializationEvent event, String modID, IConfigCategory configCat) {
        ConfigMod.addConfigFile(event, modID, configCat, true);
    }

    public static void addConfigFile(FMLPreInitializationEvent event, String modID, IConfigCategory configCat, boolean liveEdit) {
        ModConfigData configData = new ModConfigData(new File(ConfigMod.getSaveFolderPath() + "config" + File.separator + configCat.getConfigFileName() + ".cfg"), modID, configCat.getClass(), configCat);
        configs.add(configData);
        if (liveEdit) {
            liveEditConfigs.add(configData);
        }
        configLookup.put(modID, configData);
        configData.initData();
        configData.writeConfigFile(false);
    }

    public static Object getField(String configID, String name) {
        try {
            return OldUtil.getPrivateValue(ConfigMod.configLookup.get((Object)configID).configClass, instance, name);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getComment(String configID, String name) {
        try {
            Field field = ConfigMod.configLookup.get((Object)configID).configClass.getDeclaredField(name);
            ConfigComment anno_comment = field.getAnnotation(ConfigComment.class);
            return anno_comment == null ? null : anno_comment.value()[0];
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean updateField(String configID, String name, Object obj) {
        if (configLookup.get(configID).setFieldBasedOnType(name, obj)) {
            configLookup.get(configID).writeConfigFile(true);
            return true;
        }
        return false;
    }

    public static void updateHashMaps() {
    }

    static {
        configs = new ArrayList<ModConfigData>();
        liveEditConfigs = new ArrayList<ModConfigData>();
        configLookup = new HashMap();
        eventChannelName = "modconfig";
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
    }
}

