/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.LanguageRegistry;
import weather2.CreativeTabWeather;
import weather2.Weather;
import weather2.block.BlockAnemometer;
import weather2.block.BlockTSensor;
import weather2.block.BlockTSiren;
import weather2.block.BlockWeatherDeflector;
import weather2.block.BlockWeatherForecast;
import weather2.block.BlockWeatherMachine;
import weather2.block.BlockWindVane;
import weather2.block.TileEntityAnemometer;
import weather2.block.TileEntityTSiren;
import weather2.block.TileEntityWeatherDeflector;
import weather2.block.TileEntityWeatherForecast;
import weather2.block.TileEntityWeatherMachine;
import weather2.block.TileEntityWindVane;
import weather2.config.ConfigMisc;
import weather2.entity.EntityIceBall;
import weather2.entity.EntityLightningBolt;
import weather2.entity.EntityMovingBlock;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilConfig;

public class CommonProxy
implements IGuiHandler {
    public static Block blockTSensor;
    public static Block blockTSiren;
    public static Block blockWindVane;
    public static Block blockAnemometer;
    public static Block blockWeatherForecast;
    public static Block blockWeatherMachine;
    public static Block blockWeatherDeflector;
    public static CreativeTabWeather tab;

    public void init() {
        tab = new CreativeTabWeather("Weather2");
        WeatherUtil.doBlockList();
        WeatherUtilConfig.processLists();
        CommonProxy.addMapping(EntityIceBall.class, "Weather Hail", 0, 128, 5, true);
        CommonProxy.addMapping(EntityMovingBlock.class, "Moving Block", 1, 128, 5, true);
        CommonProxy.addMapping(EntityLightningBolt.class, "Weather2 Lightning Bolt", 2, 512, 5, true);
        blockTSensor = new BlockTSensor(ConfigMisc.Block_sensorID);
        this.addBlock(blockTSensor, "TornadoSensor", "Tornado Sensor");
        blockTSiren = new BlockTSiren(ConfigMisc.Block_sirenID);
        this.addBlock(blockTSiren, TileEntityTSiren.class, "TornadoSiren", "Tornado Siren");
        blockWindVane = new BlockWindVane(ConfigMisc.Block_windVaneID);
        this.addBlock(blockWindVane, TileEntityWindVane.class, "WindVane", "Wind Vane");
        blockWeatherForecast = new BlockWeatherForecast(ConfigMisc.Block_weatherForecastID);
        this.addBlock(blockWeatherForecast, TileEntityWeatherForecast.class, "WeatherForecast", "Weather Forecast");
        blockWeatherMachine = new BlockWeatherMachine(ConfigMisc.Block_weatherMachineID);
        this.addBlock(blockWeatherMachine, TileEntityWeatherMachine.class, "WeatherMachine", "Weather Machine (right click to cycle)");
        blockWeatherDeflector = new BlockWeatherDeflector(ConfigMisc.Block_weatherDeflectorID);
        this.addBlock(blockWeatherDeflector, TileEntityWeatherDeflector.class, "WeatherDeflector", "Weather Deflector");
        blockAnemometer = new BlockAnemometer(ConfigMisc.Block_anemometer);
        this.addBlock(blockAnemometer, TileEntityAnemometer.class, "Anemometer", "Anemometer");
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockTSensor, 1), (Object[])new Object[]{"X X", "DID", "X X", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151043_k, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockTSiren, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), blockTSensor, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWindVane, 1), (Object[])new Object[]{"X X", "DXD", "X X", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWeatherForecast, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151111_aL, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWeatherMachine, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), Items.field_151045_i, Character.valueOf('X'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack(blockWeatherDeflector, 1), (Object[])new Object[]{"XDX", "DID", "XDX", Character.valueOf('D'), Items.field_151137_ax, Character.valueOf('I'), blockWeatherMachine, Character.valueOf('X'), Items.field_151042_j});
        LanguageRegistry.instance().addStringLocalization("itemGroup.Weather2", "Weather2 Items");
    }

    public static void addItem(ItemStack is, String unlocalizedName) {
        CommonProxy.addItem(is, unlocalizedName, "");
    }

    public static void addItem(ItemStack is, String unlocalizedName, String itemNameBase) {
        Item item = is.func_77973_b();
        item.func_77655_b(Weather.modID + ":" + unlocalizedName);
        item.func_77637_a(CreativeTabs.field_78026_f);
        LanguageRegistry.addName((Object)item, (String)itemNameBase);
    }

    public void addBlock(Block block, Class tEnt, String unlocalizedName, String blockNameBase) {
        this.addBlock(block, unlocalizedName, blockNameBase);
        GameRegistry.registerTileEntity((Class)tEnt, (String)unlocalizedName);
    }

    public void addBlock(Block parBlock, String unlocalizedName, String blockNameBase) {
        GameRegistry.registerBlock((Block)parBlock, (String)unlocalizedName);
        parBlock.func_149663_c(CommonProxy.getNamePrefixed(unlocalizedName));
        parBlock.func_149647_a((CreativeTabs)tab);
        LanguageRegistry.addName((Object)parBlock, (String)blockNameBase);
    }

    public static void addMapping(Class par0Class, String par1Str, int entityId, int distSync, int tickRateSync, boolean syncMotion) {
        EntityRegistry.registerModEntity((Class)par0Class, (String)par1Str, (int)entityId, (Object)Weather.instance, (int)distSync, (int)tickRateSync, (boolean)syncMotion);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(Weather.modID, name);
    }

    public static String getNamePrefixed(String name) {
        return Weather.modID + "." + name;
    }
}

