/*
 * Decompiled with CFR 0.152.
 */
package weather2;

import CoroUtil.util.CoroUtilFile;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import weather2.CommandWeather2;
import weather2.CommonProxy;
import weather2.EventHandlerFML;
import weather2.EventHandlerForge;
import weather2.EventHandlerPacket;
import weather2.ServerTickHandler;
import weather2.config.ConfigMisc;
import weather2.player.PlayerData;
import weather2.util.WeatherUtilConfig;
import weather2.weathersystem.WeatherManagerServer;

@Mod(modid="weather2", name="weather2", version="v2.3.11", acceptedMinecraftVersions="[1.8.9]")
public class Weather {
    @Mod.Instance(value="weather2")
    public static Weather instance;
    public static String modID;
    public static long lastWorldTime;
    public Configuration preInitConfig;
    @SidedProxy(clientSide="weather2.ClientProxy", serverSide="weather2.CommonProxy")
    public static CommonProxy proxy;
    public static boolean initProperNeededForWorld;
    public static String eventChannelName;
    public static final FMLEventChannel eventChannel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        eventChannel.register((Object)new EventHandlerPacket());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerFML());
        ConfigMod.addConfigFile((FMLPreInitializationEvent)event, (String)"weather2Misc", (IConfigCategory)new ConfigMisc());
        WeatherUtilConfig.nbtLoadDataAll();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.init();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerForge());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandWeather2());
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartedEvent event) {
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppedEvent event) {
        Weather.writeOutData(true);
        Weather.resetStates();
        initProperNeededForWorld = true;
    }

    public static void initTry() {
        if (initProperNeededForWorld) {
            System.out.println("Weather2 being reinitialized");
            initProperNeededForWorld = false;
            CoroUtilFile.getWorldFolderName();
            ServerTickHandler.initialize();
        }
    }

    public static void resetStates() {
        ServerTickHandler.reset();
    }

    public static void writeOutData(boolean unloadInstances) {
        try {
            WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(0);
            if (wm != null) {
                wm.writeToFile();
            }
            PlayerData.writeAllPlayerNBT(unloadInstances);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void handleIMCMessages(FMLInterModComms.IMCMessage event) {
    }

    public static void dbg(Object obj) {
        if (ConfigMisc.consoleDebug) {
            System.out.println(obj);
        }
    }

    static {
        modID = "weather2";
        initProperNeededForWorld = true;
        eventChannelName = "weather2";
        eventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(eventChannelName);
    }
}

