/*
 * Decompiled with CFR 0.152.
 */
package weather2.api;

import CoroUtil.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ClientTickHandler;
import weather2.ServerTickHandler;
import weather2.weathersystem.WeatherManagerBase;

public class WindReader {
    public static float getWindAngle(World parWorld, Vec3 parLocation) {
        return WindReader.getWindAngle(parWorld, parLocation, WindType.DOMINANT);
    }

    public static float getWindAngle(World parWorld, Vec3 parLocation, WindType parWindType) {
        WeatherManagerBase wMan = null;
        wMan = parWorld.field_72995_K ? WindReader.getWeatherManagerClient() : (WeatherManagerBase)ServerTickHandler.lookupDimToWeatherMan.get(parWorld.field_73011_w.func_177502_q());
        if (wMan != null) {
            if (parWindType == WindType.DOMINANT) {
                return wMan.windMan.getWindAngleForPriority();
            }
            if (parWindType == WindType.EVENT) {
                return wMan.windMan.getWindAngleForEvents();
            }
            if (parWindType == WindType.GUST) {
                return wMan.windMan.getWindAngleForGusts();
            }
            if (parWindType == WindType.CLOUD) {
                return wMan.windMan.getWindAngleForClouds();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public static float getWindSpeed(World parWorld, Vec3 parLocation) {
        return WindReader.getWindSpeed(parWorld, parLocation, WindType.DOMINANT);
    }

    public static float getWindSpeed(World parWorld, Vec3 parLocation, WindType parWindType) {
        WeatherManagerBase wMan = null;
        wMan = parWorld.field_72995_K ? WindReader.getWeatherManagerClient() : (WeatherManagerBase)ServerTickHandler.lookupDimToWeatherMan.get(parWorld.field_73011_w.func_177502_q());
        if (wMan != null) {
            if (parWindType == WindType.DOMINANT) {
                return wMan.windMan.getWindSpeedForPriority();
            }
            if (parWindType == WindType.EVENT) {
                return wMan.windMan.getWindSpeedForEvents();
            }
            if (parWindType == WindType.GUST) {
                return wMan.windMan.getWindSpeedForGusts();
            }
            if (parWindType == WindType.CLOUD) {
                return wMan.windMan.getWindSpeedForClouds();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private static WeatherManagerBase getWeatherManagerClient() {
        return ClientTickHandler.weatherManager;
    }

    public static enum WindType {
        DOMINANT,
        EVENT,
        GUST,
        CLOUD;

    }
}

