/*
 * Decompiled with CFR 0.152.
 */
package weather2.client.gui;

import CoroUtil.packet.PacketHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import weather2.Weather;
import weather2.client.gui.elements.GuiButtonBoolean;
import weather2.client.gui.elements.GuiButtonCycle;
import weather2.util.WeatherUtilConfig;

public class GuiEZConfig
extends GuiScreen {
    public int xCenter;
    public int yCenter;
    public int xStart;
    public int yStart;
    public ResourceLocation resGUI = new ResourceLocation(Weather.modID + ":textures/gui/gui512.png");
    public String guiCur = GUI_SUBGUI_PERFORMANCE;
    public HashMap<Integer, GuiButton> buttonsLookup = new HashMap();
    public NBTTagCompound nbtSendCache = new NBTTagCompound();
    public static int CMD_CLOSE = 0;
    public static int CMD_ADVANCED = 99;
    public static int CMD_SUBGUI_PERFORMANCE = 40;
    public static int CMD_SUBGUI_COMPATIBILITY = 41;
    public static int CMD_SUBGUI_PREFERENCE = 42;
    public static int CMD_SUBGUI_DIMENSIONS = 43;
    public static int CMD_BUTTON_DIMENSIONS_PREV = 44;
    public static int CMD_BUTTON_DIMENSIONS_NEXT = 45;
    public static String GUI_SUBGUI_PERFORMANCE = "Performance";
    public static String GUI_SUBGUI_COMPATIBILITY = "Compatibility";
    public static String GUI_SUBGUI_PREFERENCE = "Preference";
    public static String GUI_SUBGUI_DIMENSIONS = "Dimensions";
    protected int xSize = 176;
    protected int ySize = 166;
    public boolean canPlayerChangeServerSettings = false;
    public int curDimListPage = 0;
    public int curDimListCountPerPage = 4;
    public int optionsPerDim = 4;
    public int btnDimIndexStart = 50;
    public List<Integer> listDimIDs = new ArrayList<Integer>();
    public List<String> listDimNames = new ArrayList<String>();
    public List<Boolean> listSettingWeather = new ArrayList<Boolean>();
    public List<Boolean> listSettingClouds = new ArrayList<Boolean>();
    public List<Boolean> listSettingStorms = new ArrayList<Boolean>();
    public List<Boolean> listSettingEffects = new ArrayList<Boolean>();

    public GuiEZConfig() {
        Weather.dbg("EZGUI constructor");
        if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71264_H()) {
            this.canPlayerChangeServerSettings = true;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("command", "syncRequest");
        data.func_74778_a("packetCommand", "EZGuiData");
        Weather.eventChannel.sendToServer(PacketHelper.getNBTPacket((NBTTagCompound)data, (String)Weather.eventChannelName));
        this.nbtSendCache.func_74782_a("guiData", (NBTBase)new NBTTagCompound());
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public void addButton(GuiButton btn) {
        this.buttonsLookup.put(btn.field_146127_k, btn);
        this.field_146292_n.add(btn);
    }

    public void resetGuiElements() {
        this.field_146292_n.clear();
        this.buttonsLookup.clear();
    }

    public void func_146278_c(int par1) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.resGUI);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.func_73729_b(x, y, 0, 0, 512, 512);
        int yEleSize = 24;
        int yEleSize2 = 44;
        this.func_73731_b(this.field_146289_q, "Weather2 EZ GUI Configuration" + (this.guiCur.equals("main") ? "" : " - GUI Tab: " + this.guiCur), this.xStart + 7, this.yStart - 9, 0xFFFFFF);
        int yStart2 = this.yStart + 34;
        int xOP = 260;
        String op = "For OP/Singleplayer";
        this.func_73731_b(this.field_146289_q, "--------------------------------------------------------", this.xStart + 7, yStart2 - 3 - 4, 0xFFFFFF);
        if (this.guiCur.equals(GUI_SUBGUI_PERFORMANCE)) {
            this.func_73731_b(this.field_146289_q, "Cloud/Storm effects", this.xStart + 7, yStart2 + 8, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Nature effects", this.xStart + 7, yStart2 + 8 + yEleSize * 1, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Particle precipitation rate", this.xStart + 7, yStart2 + 8 + yEleSize * 2, 0xFFFFFF);
        } else if (this.guiCur.equals(GUI_SUBGUI_COMPATIBILITY)) {
            this.func_73731_b(this.field_146289_q, "Storms when", this.xStart + 7, yStart2 + 8, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Lock vanilla weather", this.xStart + 7, yStart2 + 8 + yEleSize * 1, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Particle precipitation", this.xStart + 7, yStart2 + 8 + yEleSize * 2, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Extra snowfall blocks", this.xStart + 7, yStart2 + 8 + yEleSize * 3, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Wind only for vanilla particles", this.xStart + 7, yStart2 + 8 + yEleSize * 4, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8 + yEleSize * 1, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8 + yEleSize * 3, 0xFFFFFF);
        } else if (this.guiCur.equals(GUI_SUBGUI_PREFERENCE)) {
            this.func_73731_b(this.field_146289_q, "Rate of storms per each player", this.xStart + 7, yStart2 + 8, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Chance of storms", this.xStart + 7, yStart2 + 8 + yEleSize * 1, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Chance of rain", this.xStart + 7, yStart2 + 8 + yEleSize * 2, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Block destruction", this.xStart + 7, yStart2 + 8 + yEleSize * 3, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, "Tornados and Cyclones", this.xStart + 7, yStart2 + 8 + yEleSize * 4, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8 + yEleSize * 1, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8 + yEleSize * 2, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8 + yEleSize * 3, 0xFFFFFF);
            this.func_73731_b(this.field_146289_q, op, this.xStart + xOP, yStart2 + 8 + yEleSize * 4, 0xFFFFFF);
        } else if (this.guiCur.equals(GUI_SUBGUI_DIMENSIONS)) {
            try {
                for (int i = 0; i < this.curDimListCountPerPage; ++i) {
                    if (this.curDimListPage * this.curDimListCountPerPage + i >= this.listDimIDs.size()) continue;
                    this.func_73731_b(this.field_146289_q, "\u00a76" + this.listDimNames.get(this.curDimListPage * this.curDimListCountPerPage + i), this.xStart + 7, yStart2 + 8 + yEleSize2 * i, 0xFFFFFF);
                    this.func_73731_b(this.field_146289_q, "Weather: ", this.xStart + 7, yStart2 + 28 + yEleSize2 * i, 0xFFFFFF);
                    this.func_73731_b(this.field_146289_q, "Clouds: ", this.xStart + 100, yStart2 + 28 + yEleSize2 * i, 0xFFFFFF);
                    this.func_73731_b(this.field_146289_q, "Storms: ", this.xStart + 186, yStart2 + 28 + yEleSize2 * i, 0xFFFFFF);
                    this.func_73731_b(this.field_146289_q, "Effects: ", this.xStart + 270, yStart2 + 28 + yEleSize2 * i, 0xFFFFFF);
                }
                this.func_73731_b(this.field_146289_q, "" + (this.curDimListPage + 1) + "/" + (this.listDimNames.size() / this.curDimListCountPerPage + 1), this.xStart + 80, yStart2 + 194, 0xFFFFFF);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146278_c(0);
        super.func_73863_a(par1, par2, par3);
    }

    protected void func_73869_a(char par1, int par2) {
        if (par2 == 1) {
            // empty if block
        }
        try {
            super.func_73869_a(par1, par2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        try {
            super.func_73864_a(par1, par2, par3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (WeatherUtilConfig.nbtClientCache.func_74767_n("markUpdated")) {
            Weather.dbg("EZGUI client markUpdated detected");
            WeatherUtilConfig.nbtClientCache.func_74757_a("markUpdated", false);
            this.updateGuiElements();
        }
        if (this.guiCur.equals(GUI_SUBGUI_COMPATIBILITY)) {
            if (((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_COMP_STORM)).getIndex() == 1) {
                ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_COMP_LOCK))).field_146124_l = false;
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_COMP_LOCK)).setIndex(2);
            } else {
                ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_COMP_LOCK))).field_146124_l = true;
            }
        } else if (this.guiCur.equals(GUI_SUBGUI_DIMENSIONS)) {
            try {
                for (int i = 0; i < this.curDimListCountPerPage; ++i) {
                    boolean show = false;
                    int startIndex = this.btnDimIndexStart + this.curDimListCountPerPage * i;
                    if (this.curDimListPage * this.curDimListCountPerPage + i < this.listDimIDs.size()) {
                        show = true;
                    }
                    if (!show) continue;
                    boolean enabled = true;
                    if (((GuiButtonCycle)this.buttonsLookup.get(startIndex + 0)).getIndex() == 0) {
                        enabled = false;
                    }
                    ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)(startIndex + 1)))).field_146124_l = enabled;
                    ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)(startIndex + 2)))).field_146124_l = enabled;
                    ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)(startIndex + 3)))).field_146124_l = enabled;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateGuiElements() {
        Weather.dbg("updateGuiElements");
        this.canPlayerChangeServerSettings = WeatherUtilConfig.nbtClientCache.func_74767_n("isPlayerOP");
        NBTTagCompound serverDataCache = WeatherUtilConfig.nbtClientCache.func_74775_l("data");
        NBTTagCompound dimData = WeatherUtilConfig.nbtClientCache.func_74775_l("dimListing");
        this.listDimIDs.clear();
        this.listDimNames.clear();
        this.listSettingWeather.clear();
        this.listSettingStorms.clear();
        this.listSettingClouds.clear();
        this.listSettingEffects.clear();
        for (String tagName : dimData.func_150296_c()) {
            NBTTagCompound tag = dimData.func_74775_l(tagName);
            this.listDimIDs.add(tag.func_74762_e("ID"));
            this.listDimNames.add(tag.func_74779_i("name"));
            this.listSettingWeather.add(tag.func_74767_n("weather"));
            this.listSettingStorms.add(tag.func_74767_n("storms"));
            this.listSettingClouds.add(tag.func_74767_n("clouds"));
            this.listSettingEffects.add(WeatherUtilConfig.listDimensionsWindEffects.contains(tag.func_74762_e("ID")));
        }
        if (this.guiCur.equals(GUI_SUBGUI_PERFORMANCE)) {
            if (WeatherUtilConfig.nbtClientData.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PERF_STORM)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PERF_STORM)).setIndex(WeatherUtilConfig.nbtClientData.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PERF_STORM));
            }
            if (WeatherUtilConfig.nbtClientData.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PERF_NATURE)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PERF_NATURE)).setIndex(WeatherUtilConfig.nbtClientData.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PERF_NATURE));
            }
            if (WeatherUtilConfig.nbtClientData.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PERF_PRECIPRATE)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PERF_PRECIPRATE)).setIndex(WeatherUtilConfig.nbtClientData.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PERF_PRECIPRATE));
            }
        } else if (this.guiCur.equals(GUI_SUBGUI_COMPATIBILITY)) {
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_COMP_STORM)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_COMP_STORM)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_COMP_STORM));
            }
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_COMP_LOCK)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_COMP_LOCK)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_COMP_LOCK));
            }
            if (WeatherUtilConfig.nbtClientData.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_COMP_PARTICLEPRECIP)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_COMP_PARTICLEPRECIP)).setIndex(WeatherUtilConfig.nbtClientData.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_COMP_PARTICLEPRECIP));
            }
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_COMP_SNOWFALLBLOCKS)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_COMP_SNOWFALLBLOCKS)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_COMP_SNOWFALLBLOCKS));
            }
            if (WeatherUtilConfig.nbtClientData.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_COMP_PARTICLESNOMODS)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_COMP_PARTICLESNOMODS)).setIndex(WeatherUtilConfig.nbtClientData.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_COMP_PARTICLESNOMODS));
            }
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_COMP_STORM))).field_146124_l = this.canPlayerChangeServerSettings;
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_COMP_LOCK))).field_146124_l = this.canPlayerChangeServerSettings;
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_COMP_SNOWFALLBLOCKS))).field_146124_l = this.canPlayerChangeServerSettings;
        } else if (this.guiCur.equals(GUI_SUBGUI_PREFERENCE)) {
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PREF_RATEOFSTORM)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PREF_RATEOFSTORM)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PREF_RATEOFSTORM));
            }
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFSTORM)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFSTORM)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFSTORM));
            }
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFRAIN)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFRAIN)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFRAIN));
            }
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PREF_BLOCKDESTRUCTION)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PREF_BLOCKDESTRUCTION)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PREF_BLOCKDESTRUCTION));
            }
            if (serverDataCache.func_74764_b("btn_" + WeatherUtilConfig.CMD_BTN_PREF_TORNADOANDCYCLONES)) {
                ((GuiButtonCycle)this.buttonsLookup.get(WeatherUtilConfig.CMD_BTN_PREF_TORNADOANDCYCLONES)).setIndex(serverDataCache.func_74762_e("btn_" + WeatherUtilConfig.CMD_BTN_PREF_TORNADOANDCYCLONES));
            }
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_PREF_RATEOFSTORM))).field_146124_l = this.canPlayerChangeServerSettings;
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFSTORM))).field_146124_l = this.canPlayerChangeServerSettings;
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFRAIN))).field_146124_l = this.canPlayerChangeServerSettings;
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_PREF_BLOCKDESTRUCTION))).field_146124_l = this.canPlayerChangeServerSettings;
            ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)WeatherUtilConfig.CMD_BTN_PREF_TORNADOANDCYCLONES))).field_146124_l = this.canPlayerChangeServerSettings;
        } else if (this.guiCur.equals(GUI_SUBGUI_DIMENSIONS)) {
            try {
                for (int i = 0; i < this.curDimListCountPerPage; ++i) {
                    boolean show = false;
                    int startIndex = this.btnDimIndexStart + this.curDimListCountPerPage * i;
                    if (this.curDimListPage * this.curDimListCountPerPage + i < this.listDimIDs.size()) {
                        show = true;
                        ((GuiButtonCycle)this.buttonsLookup.get(startIndex + 0)).setIndex(this.listSettingWeather.get(this.curDimListPage * this.curDimListCountPerPage + i) != false ? 1 : 0);
                        ((GuiButtonCycle)this.buttonsLookup.get(startIndex + 1)).setIndex(this.listSettingClouds.get(this.curDimListPage * this.curDimListCountPerPage + i) != false ? 1 : 0);
                        ((GuiButtonCycle)this.buttonsLookup.get(startIndex + 2)).setIndex(this.listSettingStorms.get(this.curDimListPage * this.curDimListCountPerPage + i) != false ? 1 : 0);
                        ((GuiButtonCycle)this.buttonsLookup.get(startIndex + 3)).setIndex(this.listSettingEffects.get(this.curDimListPage * this.curDimListCountPerPage + i) != false ? 1 : 0);
                    }
                    Weather.dbg("page: " + this.curDimListPage + " - index: " + startIndex);
                    ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)(startIndex + 0)))).field_146125_m = show;
                    ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)(startIndex + 1)))).field_146125_m = show;
                    ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)(startIndex + 2)))).field_146125_m = show;
                    ((GuiButtonCycle)this.buttonsLookup.get((Object)Integer.valueOf((int)(startIndex + 3)))).field_146125_m = show;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.resetGuiElements();
        this.xSize = 372;
        this.ySize = 250;
        ScaledResolution var8 = new ScaledResolution(this.field_146297_k);
        int scaledWidth = var8.func_78326_a();
        int scaledHeight = var8.func_78328_b();
        this.xCenter = scaledWidth / 2;
        this.yCenter = scaledHeight / 2;
        this.xStart = this.xCenter - this.xSize / 2;
        this.yStart = this.yCenter - this.ySize / 2;
        int guiPadding = 8;
        int xStartPadded = this.xStart + guiPadding - 1;
        int yStartPadded = this.yStart + guiPadding - 1;
        int btnWidth = 80;
        int btnWidthAndPadding = 84;
        int btnWidthBool = 50;
        int btnHeight = 20;
        int btnHeightAndPadding = 24;
        boolean padding = true;
        int btnSpacing = 22;
        int yEleSize2 = 44;
        int xStartPadded2 = xStartPadded + 168;
        int yStartPadded2 = yStartPadded + 30;
        int yStartPadded3 = yStartPadded2 + 20;
        int btnDimIndex = this.btnDimIndexStart;
        this.addButton(new GuiButton(CMD_CLOSE, this.xStart + this.xSize - guiPadding - btnWidth, this.yStart + this.ySize - guiPadding - btnHeight, btnWidth, btnHeight, "Save & Close"));
        this.addButton(new GuiButton(CMD_SUBGUI_PERFORMANCE, xStartPadded + btnWidthAndPadding * 0, yStartPadded, btnWidth, btnHeight, (this.guiCur.equals(GUI_SUBGUI_PERFORMANCE) ? "\u00a72" : "") + GUI_SUBGUI_PERFORMANCE));
        this.addButton(new GuiButton(CMD_SUBGUI_COMPATIBILITY, xStartPadded + btnWidthAndPadding * 1, yStartPadded, btnWidth, btnHeight, (this.guiCur.equals(GUI_SUBGUI_COMPATIBILITY) ? "\u00a72" : "") + GUI_SUBGUI_COMPATIBILITY));
        this.addButton(new GuiButton(CMD_SUBGUI_PREFERENCE, xStartPadded + btnWidthAndPadding * 2, yStartPadded, btnWidth, btnHeight, (this.guiCur.equals(GUI_SUBGUI_PREFERENCE) ? "\u00a72" : "") + GUI_SUBGUI_PREFERENCE));
        this.addButton(new GuiButton(CMD_SUBGUI_DIMENSIONS, xStartPadded + btnWidthAndPadding * 3, yStartPadded, btnWidth, btnHeight, (this.guiCur.equals(GUI_SUBGUI_DIMENSIONS) ? "\u00a72" : "") + GUI_SUBGUI_DIMENSIONS));
        if (this.guiCur.equals(GUI_SUBGUI_PERFORMANCE)) {
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PERF_STORM, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2, btnWidth, btnHeight, WeatherUtilConfig.LIST_RATES, 0));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PERF_NATURE, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 1, btnWidth, btnHeight, WeatherUtilConfig.LIST_RATES2, 0));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PERF_PRECIPRATE, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 2, btnWidth, btnHeight, WeatherUtilConfig.LIST_RATES2, 0));
        } else if (this.guiCur.equals(GUI_SUBGUI_COMPATIBILITY)) {
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_COMP_STORM, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2, btnWidth, btnHeight, WeatherUtilConfig.LIST_STORMSWHEN, 0));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_COMP_LOCK, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 1, btnWidth, btnHeight, WeatherUtilConfig.LIST_LOCK, 0));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_COMP_PARTICLEPRECIP, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 2, btnWidth, btnHeight, WeatherUtilConfig.LIST_TOGGLE, 1));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_COMP_SNOWFALLBLOCKS, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 3, btnWidth, btnHeight, WeatherUtilConfig.LIST_TOGGLE, 0));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_COMP_PARTICLESNOMODS, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 4, btnWidth, btnHeight, WeatherUtilConfig.LIST_TOGGLE, 0));
        } else if (this.guiCur.equals(GUI_SUBGUI_PREFERENCE)) {
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PREF_RATEOFSTORM, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2, btnWidth, btnHeight, WeatherUtilConfig.LIST_CHANCE, 1));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFSTORM, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 1, btnWidth, btnHeight, WeatherUtilConfig.LIST_RATES, 0));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PREF_CHANCEOFRAIN, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 2, btnWidth, btnHeight, WeatherUtilConfig.LIST_RATES2, 0));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PREF_BLOCKDESTRUCTION, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 3, btnWidth, btnHeight, WeatherUtilConfig.LIST_TOGGLE, 1));
            this.addButton(new GuiButtonCycle(WeatherUtilConfig.CMD_BTN_PREF_TORNADOANDCYCLONES, xStartPadded2 + btnWidthAndPadding * 0, yStartPadded2 + btnHeightAndPadding * 4, btnWidth, btnHeight, WeatherUtilConfig.LIST_TOGGLE, 1));
        } else if (this.guiCur.equals(GUI_SUBGUI_DIMENSIONS)) {
            this.addButton(new GuiButton(CMD_BUTTON_DIMENSIONS_PREV, xStartPadded, this.yStart + this.ySize - guiPadding - btnHeight, 60, 20, "Prev Page"));
            this.addButton(new GuiButton(CMD_BUTTON_DIMENSIONS_NEXT, xStartPadded + 20 + btnWidthAndPadding * 1, this.yStart + this.ySize - guiPadding - btnHeight, 60, 20, "Next Page"));
            for (int i = 0; i < this.curDimListCountPerPage; ++i) {
                this.addButton(new GuiButtonCycle(btnDimIndex++, xStartPadded + 46, yStartPadded3 + yEleSize2 * i, 40, 20, WeatherUtilConfig.LIST_TOGGLE, 1));
                this.addButton(new GuiButtonCycle(btnDimIndex++, xStartPadded + 132, yStartPadded3 + yEleSize2 * i, 40, 20, WeatherUtilConfig.LIST_TOGGLE, 1));
                this.addButton(new GuiButtonCycle(btnDimIndex++, xStartPadded + 218, yStartPadded3 + yEleSize2 * i, 40, 20, WeatherUtilConfig.LIST_TOGGLE, 1));
                this.addButton(new GuiButtonCycle(btnDimIndex++, xStartPadded + 306, yStartPadded3 + yEleSize2 * i, 40, 20, WeatherUtilConfig.LIST_TOGGLE, 1));
            }
        }
        if (this.guiCur.equals("main")) {
            // empty if block
        }
        this.updateGuiElements();
    }

    protected void func_146284_a(GuiButton var1) {
        String guiForPacket = this.guiCur;
        boolean sendPacket = false;
        if (WeatherUtilConfig.listSettingsServer.contains(var1.field_146127_k)) {
            if (var1 instanceof GuiButtonBoolean) {
                ((GuiButtonBoolean)var1).setBooleanToggle();
                this.nbtSendCache.func_74775_l("guiData").func_74768_a("btn_" + var1.field_146127_k, ((GuiButtonBoolean)var1).getBoolean() ? 1 : 0);
            }
            if (var1 instanceof GuiButtonCycle) {
                ((GuiButtonCycle)var1).cycleIndex();
                this.nbtSendCache.func_74775_l("guiData").func_74768_a("btn_" + var1.field_146127_k, ((GuiButtonCycle)var1).getIndex());
            }
        } else if (WeatherUtilConfig.listSettingsClient.contains(var1.field_146127_k)) {
            if (var1 instanceof GuiButtonCycle) {
                ((GuiButtonCycle)var1).cycleIndex();
                WeatherUtilConfig.nbtClientData.func_74768_a("btn_" + var1.field_146127_k, ((GuiButtonCycle)var1).getIndex());
            }
        } else if (var1.field_146127_k == CMD_SUBGUI_PERFORMANCE || var1.field_146127_k == CMD_SUBGUI_COMPATIBILITY || var1.field_146127_k == CMD_SUBGUI_PREFERENCE || var1.field_146127_k == CMD_SUBGUI_DIMENSIONS) {
            if (var1.field_146127_k == CMD_SUBGUI_PERFORMANCE) {
                this.guiCur = GUI_SUBGUI_PERFORMANCE;
            } else if (var1.field_146127_k == CMD_SUBGUI_COMPATIBILITY) {
                this.guiCur = GUI_SUBGUI_COMPATIBILITY;
            } else if (var1.field_146127_k == CMD_SUBGUI_PREFERENCE) {
                this.guiCur = GUI_SUBGUI_PREFERENCE;
            } else if (var1.field_146127_k == CMD_SUBGUI_DIMENSIONS) {
                this.guiCur = GUI_SUBGUI_DIMENSIONS;
            }
            this.func_73866_w_();
        } else if (var1.field_146127_k == CMD_BUTTON_DIMENSIONS_PREV) {
            --this.curDimListPage;
            if (this.curDimListPage < 0) {
                this.curDimListPage = 0;
            }
            this.func_73866_w_();
        } else if (var1.field_146127_k == CMD_BUTTON_DIMENSIONS_NEXT) {
            ++this.curDimListPage;
            if (this.curDimListPage > this.listDimIDs.size() / this.curDimListCountPerPage) {
                --this.curDimListPage;
            }
            this.func_73866_w_();
        } else if (var1.field_146127_k == CMD_CLOSE) {
            sendPacket = true;
            this.field_146297_k.field_71439_g.func_71053_j();
            WeatherUtilConfig.processNBTToModConfigClient();
        } else if (var1.field_146127_k != CMD_ADVANCED) {
            try {
                if ((var1.field_146127_k - this.btnDimIndexStart) % 4 == 3) {
                    ((GuiButtonCycle)var1).cycleIndex();
                    NBTTagCompound nbtDims = WeatherUtilConfig.nbtClientData.func_74775_l("dimData");
                    nbtDims.func_74768_a("dim_" + this.listDimIDs.get(this.curDimListPage * this.curDimListCountPerPage + (var1.field_146127_k - this.btnDimIndexStart) / this.curDimListCountPerPage) + "_" + (var1.field_146127_k - this.btnDimIndexStart) % 4, ((GuiButtonCycle)var1).getIndex());
                    WeatherUtilConfig.nbtClientData.func_74782_a("dimData", (NBTBase)nbtDims);
                    Weather.dbg("nbtClientData: " + WeatherUtilConfig.nbtClientData);
                } else {
                    Weather.dbg((var1.field_146127_k - this.btnDimIndexStart) % 4 + " - " + this.listDimIDs.get(this.curDimListPage * this.curDimListCountPerPage + (var1.field_146127_k - this.btnDimIndexStart) / this.curDimListCountPerPage));
                    ((GuiButtonCycle)var1).cycleIndex();
                    NBTTagCompound nbtDims = this.nbtSendCache.func_74775_l("guiData").func_74775_l("dimData");
                    nbtDims.func_74768_a("dim_" + this.listDimIDs.get(this.curDimListPage * this.curDimListCountPerPage + (var1.field_146127_k - this.btnDimIndexStart) / this.curDimListCountPerPage) + "_" + (var1.field_146127_k - this.btnDimIndexStart) % 4, ((GuiButtonCycle)var1).getIndex());
                    this.nbtSendCache.func_74775_l("guiData").func_74782_a("dimData", (NBTBase)nbtDims);
                    Weather.dbg("nbtSendCache: " + this.nbtSendCache);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (sendPacket) {
            boolean val = false;
            this.nbtSendCache.func_74778_a("command", "applySettings");
            this.nbtSendCache.func_74778_a("packetCommand", "EZGuiData");
            Weather.eventChannel.sendToServer(PacketHelper.getNBTPacket((NBTTagCompound)this.nbtSendCache, (String)Weather.eventChannelName));
        }
    }

    public int sanitize(int val) {
        return this.sanitize(val, 0, 9999);
    }

    public int sanitize(int val, int min, int max) {
        if (val > max) {
            val = max;
        }
        if (val < min) {
            val = min;
        }
        return val;
    }

    public void func_73729_b(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.001953125f;
        float f1 = 0.001953125f;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer worldrenderer = tessellator.func_178180_c();
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + height) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + width), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + width) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        worldrenderer.func_181662_b((double)(x + 0), (double)(y + 0), (double)this.field_73735_i).func_181673_a((double)((float)(textureX + 0) * f), (double)((float)(textureY + 0) * f1)).func_181675_d();
        tessellator.func_78381_a();
    }
}

