/*
 * Decompiled with CFR 0.152.
 */
package weather2.weathersystem.storm;

import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.util.CoroUtilEntity;
import CoroUtil.util.Vec3;
import extendedrenderer.ExtendedRenderer;
import extendedrenderer.particle.ParticleRegistry;
import extendedrenderer.particle.behavior.ParticleBehaviorFog;
import extendedrenderer.particle.entity.EntityRotFX;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weather2.ServerTickHandler;
import weather2.Weather;
import weather2.config.ConfigMisc;
import weather2.entity.EntityIceBall;
import weather2.entity.EntityLightningBolt;
import weather2.player.PlayerData;
import weather2.util.WeatherUtil;
import weather2.util.WeatherUtilConfig;
import weather2.util.WeatherUtilEntity;
import weather2.weathersystem.WeatherManagerBase;
import weather2.weathersystem.WeatherManagerServer;
import weather2.weathersystem.storm.TornadoHelper;
import weather2.weathersystem.storm.WeatherEntityConfig;
import weather2.weathersystem.storm.WeatherTypes;

public class StormObject {
    public static long lastUsedStormID = 0L;
    public long ID;
    public WeatherManagerBase manager;
    public String userSpawnedFor = "";
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesCloud;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesGround;
    @SideOnly(value=Side.CLIENT)
    public List<EntityRotFX> listParticlesFunnel;
    @SideOnly(value=Side.CLIENT)
    public ParticleBehaviorFog particleBehaviorFog;
    public int sizeMaxFunnelParticles = 600;
    public static int static_YPos_layer0 = ConfigMisc.Cloud_Layer0_Height;
    public static int static_YPos_layer1 = 350;
    public static int static_YPos_layer2 = 500;
    public static List<Integer> layers = new ArrayList<Integer>(Arrays.asList(static_YPos_layer0, static_YPos_layer1, static_YPos_layer2));
    public int layer = 0;
    public Vec3 pos = new Vec3(0.0, (double)static_YPos_layer0, 0.0);
    public Vec3 posGround = new Vec3(0.0, 0.0, 0.0);
    public Vec3 motion = new Vec3(0.0, 0.0, 0.0);
    public boolean angleIsOverridden = false;
    public float angleMovementTornadoOverride = 0.0f;
    public int size = 50;
    public int maxSize = ConfigMisc.Storm_MaxRadius;
    public boolean isGrowing = true;
    public int levelWater = 0;
    public float levelWindMomentum = 0.0f;
    public float levelTemperature = 0.0f;
    public int levelWaterStartRaining = 100;
    public int levelCurIntensityStage = 0;
    public float levelCurStagesIntensity = 0.0f;
    public boolean hasStormPeaked = false;
    public int maxIntensityStage = STATE_STAGE5;
    public int stormType = TYPE_LAND;
    public static int TYPE_LAND = 0;
    public static int TYPE_WATER = 1;
    public static int STATE_NORMAL = 0;
    public static int STATE_THUNDER = 1;
    public static int STATE_HIGHWIND = 2;
    public static int STATE_HAIL = 3;
    public static int STATE_FORMING = 4;
    public static int STATE_STAGE1 = 5;
    public static int STATE_STAGE2 = 6;
    public static int STATE_STAGE3 = 7;
    public static int STATE_STAGE4 = 8;
    public static int STATE_STAGE5 = 9;
    public static float levelStormIntensityFormingStartVal = STATE_FORMING;
    public double spinSpeed = 0.02;
    public boolean attrib_precipitation = false;
    public boolean attrib_waterSpout = false;
    public float scale = 1.0f;
    public float strength = 100.0f;
    public int maxHeight = 60;
    public int currentTopYBlock = -1;
    public TornadoHelper tornadoHelper = new TornadoHelper(this);
    public Set<ChunkCoordIntPair> doneChunks = new HashSet<ChunkCoordIntPair>();
    public int updateLCG = new Random().nextInt();
    public float formingStrength = 0.0f;
    public Vec3 posBaseFormationPos;
    public boolean naturallySpawned;
    public boolean canSnowFromCloudTemperature;
    public boolean alwaysProgresses;
    public boolean isDead;
    public long ticksSinceLastPacketReceived;

    public StormObject(WeatherManagerBase parManager) {
        this.posBaseFormationPos = new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord);
        this.naturallySpawned = true;
        this.canSnowFromCloudTemperature = false;
        this.alwaysProgresses = false;
        this.isDead = false;
        this.ticksSinceLastPacketReceived = 0L;
        this.manager = parManager;
        if (parManager.getWorld().field_72995_K) {
            this.listParticlesCloud = new ArrayList<EntityRotFX>();
            this.listParticlesFunnel = new ArrayList<EntityRotFX>();
            this.listParticlesGround = new ArrayList<EntityRotFX>();
        }
    }

    public void initFirstTime() {
        this.ID = lastUsedStormID++;
        BiomeGenBase bgb = this.manager.getWorld().func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), 0, MathHelper.func_76128_c((double)this.pos.zCoord)));
        float temp = 1.0f;
        if (bgb != null) {
            temp = bgb.func_180626_a(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), MathHelper.func_76128_c((double)this.pos.yCoord), MathHelper.func_76128_c((double)this.pos.zCoord)));
        }
        if (this.naturallySpawned) {
            this.levelTemperature = this.getTemperatureMCToWeatherSys(temp);
        }
        this.levelWindMomentum = 0.0f;
    }

    public boolean isPrecipitating() {
        return this.attrib_precipitation;
    }

    public void setPrecipitating(boolean parVal) {
        this.attrib_precipitation = parVal;
    }

    public boolean isRealStorm() {
        return this.levelCurIntensityStage > STATE_NORMAL;
    }

    public boolean isTornadoFormingOrGreater() {
        return this.stormType == TYPE_LAND && this.levelCurIntensityStage >= STATE_FORMING;
    }

    public boolean isCycloneFormingOrGreater() {
        return this.stormType == TYPE_WATER && this.levelCurIntensityStage >= STATE_FORMING;
    }

    public boolean isSpinning() {
        return this.levelCurIntensityStage >= STATE_HIGHWIND;
    }

    public boolean isTropicalCyclone() {
        return this.levelCurIntensityStage >= STATE_STAGE1;
    }

    public boolean isHurricane() {
        return this.levelCurIntensityStage >= STATE_STAGE5;
    }

    public void readFromNBT(NBTTagCompound var1) {
        this.nbtSyncFromServer(var1);
        this.motion = new Vec3(var1.func_74769_h("vecX"), var1.func_74769_h("vecY"), var1.func_74769_h("vecZ"));
        this.angleIsOverridden = var1.func_74767_n("angleIsOverridden");
        this.angleMovementTornadoOverride = var1.func_74760_g("angleMovementTornadoOverride");
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = this.nbtSyncForClient();
        nbt.func_74780_a("vecX", this.motion.xCoord);
        nbt.func_74780_a("vecY", this.motion.yCoord);
        nbt.func_74780_a("vecZ", this.motion.zCoord);
        nbt.func_74757_a("angleIsOverridden", this.angleIsOverridden);
        nbt.func_74776_a("angleMovementTornadoOverride", this.angleMovementTornadoOverride);
        return nbt;
    }

    public void nbtSyncFromServer(NBTTagCompound parNBT) {
        this.ID = parNBT.func_74763_f("ID");
        this.pos = new Vec3((double)parNBT.func_74762_e("posX"), (double)parNBT.func_74762_e("posY"), (double)parNBT.func_74762_e("posZ"));
        this.size = parNBT.func_74762_e("size");
        this.maxSize = parNBT.func_74762_e("maxSize");
        this.attrib_precipitation = parNBT.func_74767_n("attrib_rain");
        this.attrib_waterSpout = parNBT.func_74767_n("attrib_waterSpout");
        this.currentTopYBlock = parNBT.func_74762_e("currentTopYBlock");
        this.levelTemperature = parNBT.func_74760_g("levelTemperature");
        this.levelWater = parNBT.func_74762_e("levelWater");
        this.layer = parNBT.func_74762_e("layer");
        this.levelCurIntensityStage = parNBT.func_74762_e("levelCurIntensityStage");
        this.levelCurStagesIntensity = parNBT.func_74760_g("levelCurStagesIntensity");
        this.stormType = parNBT.func_74762_e("stormType");
        this.hasStormPeaked = parNBT.func_74767_n("hasStormPeaked");
        this.isDead = parNBT.func_74767_n("isDead");
        this.ticksSinceLastPacketReceived = 0L;
    }

    public NBTTagCompound nbtSyncForClient() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("posX", (int)this.pos.xCoord);
        data.func_74768_a("posY", (int)this.pos.yCoord);
        data.func_74768_a("posZ", (int)this.pos.zCoord);
        data.func_74772_a("ID", this.ID);
        data.func_74768_a("size", this.size);
        data.func_74768_a("maxSize", this.maxSize);
        data.func_74757_a("attrib_rain", this.attrib_precipitation);
        data.func_74757_a("attrib_waterSpout", this.attrib_waterSpout);
        data.func_74768_a("currentTopYBlock", this.currentTopYBlock);
        data.func_74776_a("levelTemperature", this.levelTemperature);
        data.func_74768_a("levelWater", this.levelWater);
        data.func_74768_a("layer", this.layer);
        data.func_74768_a("levelCurIntensityStage", this.levelCurIntensityStage);
        data.func_74776_a("levelCurStagesIntensity", this.levelCurStagesIntensity);
        data.func_74768_a("stormType", this.stormType);
        data.func_74757_a("hasStormPeaked", this.hasStormPeaked);
        data.func_74757_a("isDead", this.isDead);
        return data;
    }

    public NBTTagCompound nbtForIMC() {
        return this.nbtSyncForClient();
    }

    @SideOnly(value=Side.CLIENT)
    public void tickRender(float partialTick) {
    }

    public void tick() {
        this.posGround = new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord);
        this.posGround.yCoord = this.currentTopYBlock;
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            if (!WeatherUtil.isPaused()) {
                ++this.ticksSinceLastPacketReceived;
                if (this.layer == 0) {
                    this.tickClient();
                }
                if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                    this.tornadoHelper.tick(this.manager.getWorld());
                }
                if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().field_72995_K) {
                    this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
                }
            }
        } else {
            if (this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater()) {
                this.tornadoHelper.tick(this.manager.getWorld());
            }
            if (this.levelCurIntensityStage >= STATE_HIGHWIND && this.manager.getWorld().field_72995_K) {
                this.tornadoHelper.soundUpdates(true, this.isTornadoFormingOrGreater() || this.isCycloneFormingOrGreater());
            }
            this.tickMovement();
            if (this.layer == 0) {
                this.tickWeatherEvents();
                this.tickProgression();
                this.tickSnowFall();
            }
        }
        if (this.layer == 0) {
            this.posBaseFormationPos = new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord);
            if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
                if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal + 1.0f) {
                    this.formingStrength = 1.0f;
                    this.posBaseFormationPos.yCoord = this.posGround.yCoord;
                } else {
                    float val;
                    float intensityAdj = Math.min(1.0f, this.levelCurStagesIntensity * 2.0f);
                    this.formingStrength = val = (float)this.levelCurIntensityStage + intensityAdj - levelStormIntensityFormingStartVal;
                    double yDiff = this.pos.yCoord - this.posGround.yCoord;
                    this.posBaseFormationPos.yCoord = this.pos.yCoord - yDiff * (double)this.formingStrength;
                }
            } else if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                this.formingStrength = 1.0f;
                this.posBaseFormationPos.yCoord = this.posGround.yCoord;
            } else {
                this.formingStrength = 0.0f;
                this.posBaseFormationPos.yCoord = this.pos.yCoord;
            }
        }
    }

    public void tickMovement() {
        float angle = this.getAdjustedAngle();
        if (this.angleIsOverridden) {
            angle = this.angleMovementTornadoOverride;
        }
        double vecX = -Math.sin(Math.toRadians(angle));
        double vecZ = Math.cos(Math.toRadians(angle));
        float cloudSpeedAmp = 0.2f;
        float finalSpeed = this.getAdjustedSpeed() * cloudSpeedAmp;
        if (this.levelCurIntensityStage >= STATE_FORMING) {
            finalSpeed = 0.2f;
        } else if (this.levelCurIntensityStage >= STATE_THUNDER) {
            finalSpeed = 0.05f;
        }
        if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
            finalSpeed /= (float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f;
        }
        if (finalSpeed < 0.03f) {
            finalSpeed = 0.03f;
        }
        if (finalSpeed > 0.3f) {
            finalSpeed = 0.3f;
        }
        if (this.manager.getWorld().func_82737_E() % 100L != 0L || this.levelCurIntensityStage >= STATE_FORMING) {
            // empty if block
        }
        this.motion.xCoord = vecX * (double)finalSpeed;
        this.motion.zCoord = vecZ * (double)finalSpeed;
        double max = 0.2;
        this.pos.xCoord += this.motion.xCoord;
        this.pos.zCoord += this.motion.zCoord;
    }

    public void tickWeatherEvents() {
        int z;
        int y;
        int x;
        Random rand = new Random();
        World world = this.manager.getWorld();
        this.currentTopYBlock = world.func_175645_m(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), 0, MathHelper.func_76128_c((double)this.pos.zCoord))).func_177956_o();
        if (this.levelCurIntensityStage >= STATE_THUNDER && rand.nextInt(Math.max(1, ConfigMisc.Storm_LightningStrikeBaseValueOddsTo1 - this.levelCurIntensityStage * 10)) == 0 && world.func_175667_e(new BlockPos(x = (int)(this.pos.xCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)), y = world.func_175725_q(new BlockPos(x, 0, z = (int)(this.pos.zCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)))).func_177956_o(), z))) {
            this.addWeatherEffectLightning(new EntityLightningBolt(world, x, y, z));
        }
        if (this.isPrecipitating() && this.levelCurIntensityStage == STATE_HAIL && this.stormType == TYPE_LAND) {
            for (int i = 0; i < Math.max(1, ConfigMisc.Storm_HailPerTick * (this.size / this.maxSize)); ++i) {
                int z2;
                int x2 = (int)(this.pos.xCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size));
                if (!world.func_175667_e(new BlockPos(x2, static_YPos_layer0, z2 = (int)(this.pos.zCoord + (double)rand.nextInt(this.size) - (double)rand.nextInt(this.size)))) || world.func_72977_a((double)x2, 50.0, (double)z2, 80.0) == null) continue;
                EntityIceBall hail = new EntityIceBall(world);
                hail.func_70107_b(x2, layers.get(this.layer).intValue(), z2);
                world.func_72838_d((Entity)hail);
            }
        }
    }

    public void tickSnowFall() {
        if (!ConfigMisc.Snow_PerformSnowfall) {
            return;
        }
        if (!this.isPrecipitating()) {
            return;
        }
        World world = this.manager.getWorld();
        long startTime = System.nanoTime();
        int xx = 0;
        int zz = 0;
        xx = (int)(this.pos.xCoord - (double)(this.size / 2));
        while ((double)xx < this.pos.xCoord + (double)(this.size / 2)) {
            zz = (int)(this.pos.zCoord - (double)(this.size / 2));
            while ((double)zz < this.pos.zCoord + (double)(this.size / 2)) {
                Chunk chunk;
                int chunkX = xx / 16;
                int chunkZ = zz / 16;
                int x = chunkX * 16;
                int z = chunkZ * 16;
                if (world.func_72863_F().func_73149_a(xx, zz) && world.field_73011_w.canDoRainSnowIce(chunk = world.func_72964_e(chunkX, chunkZ)) && (ConfigMisc.Snow_RarityOfBuildup == 0 || world.field_73012_v.nextInt(ConfigMisc.Snow_RarityOfBuildup) == 0)) {
                    this.updateLCG = this.updateLCG * 3 + 1013904223;
                    int i1 = this.updateLCG >> 2;
                    int xxx = i1 & 0xF;
                    double d0 = this.pos.xCoord - (double)(xx + xxx);
                    int zzz = i1 >> 8 & 0xF;
                    double d2 = this.pos.zCoord - (double)(zz + zzz);
                    if (!((double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) > (double)this.size)) {
                        int snowMetaMax = 7;
                        int setBlockHeight = world.func_175725_q(new BlockPos(xxx + x, 0, zzz + z)).func_177956_o();
                        if (this.canSnowAtBody(xxx + x, setBlockHeight, zzz + z) && Blocks.field_150433_aE.func_176196_c(world, new BlockPos(xxx + x, setBlockHeight, zzz + z))) {
                            int origMeta;
                            boolean perform = false;
                            Block id = world.func_180495_p(new BlockPos(xxx + x, setBlockHeight, zzz + z)).func_177230_c();
                            int meta = 0;
                            if (id.func_149688_o() == Material.field_151597_y) {
                                if (ConfigMisc.Snow_ExtraPileUp) {
                                    IBlockState state = world.func_180495_p(new BlockPos(xxx + x, setBlockHeight, zzz + z));
                                    meta = state.func_177230_c().func_176201_c(state);
                                    if (meta < snowMetaMax) {
                                        perform = true;
                                        ++meta;
                                    } else if (ConfigMisc.Snow_MaxBlockBuildupHeight > 1) {
                                        int i;
                                        int originalSetBlockHeight = setBlockHeight;
                                        for (i = 0; i < ConfigMisc.Snow_MaxBlockBuildupHeight; ++i) {
                                            Block checkID = world.func_180495_p(new BlockPos(xxx + x, originalSetBlockHeight + i, zzz + z)).func_177230_c();
                                            if (checkID.func_149688_o() == Material.field_151597_y) {
                                                IBlockState state2 = world.func_180495_p(new BlockPos(xxx + x, originalSetBlockHeight + i, zzz + z));
                                                meta = state2.func_177230_c().func_176201_c(state2);
                                                if (meta >= snowMetaMax) continue;
                                                setBlockHeight = originalSetBlockHeight + i;
                                                perform = true;
                                                ++meta;
                                                break;
                                            }
                                            if (!CoroUtilBlock.isAir((Block)checkID)) continue;
                                            meta = 0;
                                            setBlockHeight = originalSetBlockHeight + i;
                                            perform = true;
                                            break;
                                        }
                                        if (i == ConfigMisc.Snow_MaxBlockBuildupHeight) {
                                            perform = false;
                                        }
                                    }
                                }
                            } else {
                                perform = true;
                            }
                            if (perform && ConfigMisc.Snow_SmoothOutPlacement && (origMeta = Math.max(0, meta - 1)) > snowMetaMax - 4) {
                                ChunkCoordinatesBlock coords = this.getSnowfallEvenOutAdjustCheck(xxx + x, setBlockHeight, zzz + z, origMeta);
                                if (coords.posX != 0 || coords.posZ != 0) {
                                    if (meta != coords.meta + 1) {
                                        xxx = coords.posX;
                                        zzz = coords.posZ;
                                        meta = coords.meta + 1;
                                    } else {
                                        perform = false;
                                    }
                                }
                            }
                            if (perform) {
                                world.func_180501_a(new BlockPos(xxx + x, setBlockHeight, zzz + z), id.func_176203_a(meta), 3);
                            }
                        }
                    }
                }
                zz += 16;
            }
            xx += 16;
        }
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjustCheck(int x, int y, int z, int sourceMeta) {
        ChunkCoordinatesBlock attempt = this.getSnowfallEvenOutAdjust(x - 1, y, z, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x + 1, y, z, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z - 1, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        attempt = this.getSnowfallEvenOutAdjust(x, y, z + 1, sourceMeta);
        if (attempt.posX != 0 || attempt.posZ != 0) {
            return attempt;
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public ChunkCoordinatesBlock getSnowfallEvenOutAdjust(int x, int y, int z, int sourceMeta) {
        boolean metaToSet = false;
        World world = this.manager.getWorld();
        Block checkID = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
        if (CoroUtilBlock.isAir((Block)checkID)) {
            Block checkID2 = world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
            if (CoroUtilBlock.isAir((Block)checkID2)) {
                return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
            }
            return new ChunkCoordinatesBlock(x, y, z, Blocks.field_150350_a, 0);
        }
        if (checkID == Blocks.field_150433_aE) {
            IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
            int checkMeta = state.func_177230_c().func_176201_c(state);
            if (checkMeta < sourceMeta) {
                return new ChunkCoordinatesBlock(x, y, z, checkID, checkMeta);
            }
        } else {
            return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
        }
        return new ChunkCoordinatesBlock(0, 0, 0, Blocks.field_150350_a, 0);
    }

    public boolean canSnowAtBody(int par1, int par2, int par3) {
        World world;
        block7: {
            block6: {
                world = this.manager.getWorld();
                BiomeGenBase biomegenbase = world.func_180494_b(new BlockPos(par1, 0, par3));
                if (biomegenbase == null) {
                    return false;
                }
                float f = biomegenbase.func_180626_a(new BlockPos(par1, par2, par3));
                if (this.canSnowFromCloudTemperature && this.levelTemperature > 0.0f) break block6;
                if (this.canSnowFromCloudTemperature) break block7;
                BlockPos blockPos = new BlockPos(par1, par2, par3);
                if (!(biomegenbase.func_180626_a(blockPos) > 0.15f)) break block7;
            }
            return false;
        }
        if (par2 >= 0 && par2 < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, new BlockPos(par1, par2, par3)) < 10) {
            Block l = world.func_180495_p(new BlockPos(par1, par2 - 1, par3)).func_177230_c();
            Block i1 = world.func_180495_p(new BlockPos(par1, par2, par3)).func_177230_c();
            if ((CoroUtilBlock.isAir((Block)i1) || i1 == Blocks.field_150433_aE) && CoroUtilBlock.isAir((Block)l) && l != Blocks.field_150432_aD && l.func_149688_o().func_76230_c()) {
                return true;
            }
        }
        return false;
    }

    public void tickProgression() {
        World world = this.manager.getWorld();
        if (world.func_82737_E() % 3L == 0L && this.isGrowing && this.size < this.maxSize) {
            ++this.size;
        }
        float tempAdjustRate = (float)ConfigMisc.Storm_TemperatureAdjustRate;
        int levelWaterBuildRate = ConfigMisc.Storm_Rain_WaterBuildUpRate;
        int levelWaterSpendRate = ConfigMisc.Storm_Rain_WaterSpendRate;
        int randomChanceOfWaterBuildFromWater = ConfigMisc.Storm_Rain_WaterBuildUpOddsTo1FromSource;
        int randomChanceOfWaterBuildFromNothing = ConfigMisc.Storm_Rain_WaterBuildUpOddsTo1FromNothing;
        boolean isInOcean = false;
        boolean isOverWater = false;
        if (world.func_82737_E() % (long)ConfigMisc.Storm_AllTypes_TickRateDelay == 0L) {
            Block blockID;
            NBTTagCompound playerNBT = PlayerData.getPlayerNBT(this.userSpawnedFor);
            long lastStormDeadlyTime = playerNBT.func_74763_f("lastStormDeadlyTime");
            BiomeGenBase bgb = world.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), 0, MathHelper.func_76128_c((double)this.pos.zCoord)));
            if (bgb != null) {
                isInOcean = bgb.field_76791_y.contains("Ocean") || bgb.field_76791_y.contains("ocean");
                float biomeTempAdj = this.getTemperatureMCToWeatherSys(bgb.func_180626_a(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), MathHelper.func_76128_c((double)this.pos.yCoord), MathHelper.func_76128_c((double)this.pos.zCoord))));
                this.levelTemperature = this.levelTemperature > biomeTempAdj ? (this.levelTemperature -= tempAdjustRate) : (this.levelTemperature += tempAdjustRate);
            }
            boolean performBuildup = false;
            Random rand = new Random();
            if (!this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromNothing) == 0) {
                performBuildup = true;
            }
            if (!CoroUtilBlock.isAir((Block)(blockID = world.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.pos.xCoord), this.currentTopYBlock - 1, MathHelper.func_76128_c((double)this.pos.zCoord))).func_177230_c())) && blockID.func_149688_o() instanceof MaterialLiquid) {
                isOverWater = true;
            }
            if (!performBuildup && !this.isPrecipitating() && rand.nextInt(randomChanceOfWaterBuildFromWater) == 0) {
                if (isOverWater) {
                    performBuildup = true;
                }
                if (!performBuildup && bgb != null && (isInOcean || bgb.field_76791_y.contains("Swamp") || bgb.field_76791_y.contains("Jungle") || bgb.field_76791_y.contains("River"))) {
                    performBuildup = true;
                }
            }
            if (performBuildup) {
                this.levelWater += levelWaterBuildRate;
            }
            if (this.isPrecipitating()) {
                this.levelWater -= levelWaterSpendRate;
                if (this.levelWater < 0) {
                    this.levelWater = 0;
                }
                if (this.levelWater <= 0) {
                    this.setPrecipitating(false);
                    Weather.dbg("ending raining for: " + this.ID);
                }
            } else if ((!ConfigMisc.overcastMode || this.manager.getWorld().func_72896_J()) && this.levelWater >= this.levelWaterStartRaining && ConfigMisc.Player_Storm_Rain_OddsTo1 != -1 && rand.nextInt(ConfigMisc.Player_Storm_Rain_OddsTo1) == 0) {
                this.setPrecipitating(true);
                Weather.dbg("starting raining for: " + this.ID);
            }
            WeatherManagerServer wm = ServerTickHandler.lookupDimToWeatherMan.get(world.field_73011_w.func_177502_q());
            boolean tryFormStorm = false;
            if (ConfigMisc.Server_Storm_Deadly_UseGlobalRate) {
                if (ConfigMisc.Server_Storm_Deadly_TimeBetweenInTicks != -1 && (wm.lastStormFormed == 0L || wm.lastStormFormed + (long)ConfigMisc.Server_Storm_Deadly_TimeBetweenInTicks < world.func_82737_E())) {
                    tryFormStorm = true;
                }
            } else if (ConfigMisc.Player_Storm_Deadly_TimeBetweenInTicks != -1 && (lastStormDeadlyTime == 0L || lastStormDeadlyTime + (long)ConfigMisc.Player_Storm_Deadly_TimeBetweenInTicks < world.func_82737_E())) {
                tryFormStorm = true;
            }
            if ((ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() || !ConfigMisc.overcastMode) && WeatherUtilConfig.listDimensionsStorms.contains(this.manager.getWorld().field_73011_w.func_177502_q()) && tryFormStorm) {
                int stormFrontCollideDist = ConfigMisc.Storm_Deadly_CollideDistance;
                int randomChanceOfCollide = ConfigMisc.Player_Storm_Deadly_OddsTo1;
                if (isInOcean && ConfigMisc.Storm_OddsTo1OfOceanBasedStorm > 0 && rand.nextInt(ConfigMisc.Storm_OddsTo1OfOceanBasedStorm) == 0) {
                    EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigMisc.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.func_82737_E();
                    } else {
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                    }
                } else if (!isInOcean && ConfigMisc.Storm_OddsTo1OfLandBasedStorm > 0 && rand.nextInt(ConfigMisc.Storm_OddsTo1OfLandBasedStorm) == 0) {
                    EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                    if (entP != null) {
                        this.initRealStorm(entP, null);
                    } else {
                        this.initRealStorm(null, null);
                    }
                    if (ConfigMisc.Server_Storm_Deadly_UseGlobalRate) {
                        wm.lastStormFormed = world.func_82737_E();
                    } else {
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                    }
                } else if (rand.nextInt(randomChanceOfCollide) == 0) {
                    for (int i = 0; i < this.manager.getStormObjects().size(); ++i) {
                        StormObject so = this.manager.getStormObjects().get(i);
                        boolean startStorm = false;
                        if (so.ID != this.ID && so.levelCurIntensityStage <= 0 && so.pos.distanceTo(this.pos) < (double)stormFrontCollideDist) {
                            if (this.levelTemperature < 0.0f) {
                                if (so.levelTemperature > 0.0f) {
                                    startStorm = true;
                                }
                            } else if (this.levelTemperature > 0.0f && so.levelTemperature < 0.0f) {
                                startStorm = true;
                            }
                        }
                        if (!startStorm) continue;
                        playerNBT.func_74772_a("lastStormDeadlyTime", world.func_82737_E());
                        EntityPlayer entP = world.func_72924_a(this.userSpawnedFor);
                        if (entP != null) {
                            this.initRealStorm(entP, so);
                            break;
                        }
                        this.initRealStorm(null, so);
                        break;
                    }
                }
            }
            if (this.isRealStorm()) {
                if (ConfigMisc.overcastMode && !this.manager.getWorld().func_72896_J()) {
                    this.hasStormPeaked = true;
                }
                if (!this.hasStormPeaked) {
                    this.levelWater = this.levelWaterStartRaining;
                    this.setPrecipitating(true);
                }
                if ((this.levelCurIntensityStage == STATE_HIGHWIND || this.levelCurIntensityStage == STATE_HAIL) && isOverWater) {
                    if (ConfigMisc.Storm_OddsTo1OfHighWindWaterSpout != 0 && rand.nextInt(ConfigMisc.Storm_OddsTo1OfHighWindWaterSpout) == 0) {
                        this.attrib_waterSpout = true;
                    }
                } else {
                    this.attrib_waterSpout = false;
                }
                float levelStormIntensityRate = 0.02f;
                float minIntensityToProgress = 0.6f;
                int oddsTo1OfIntensityProgressionBase = ConfigMisc.Storm_OddsTo1OfProgressionBase;
                if ((float)this.levelCurIntensityStage >= levelStormIntensityFormingStartVal) {
                    levelStormIntensityRate *= 3.0f;
                    oddsTo1OfIntensityProgressionBase /= 3;
                }
                int oddsTo1OfIntensityProgression = oddsTo1OfIntensityProgressionBase + this.levelCurIntensityStage * ConfigMisc.Storm_OddsTo1OfProgressionStageMultiplier;
                if (!this.hasStormPeaked) {
                    this.levelCurStagesIntensity += levelStormIntensityRate;
                    if (!(this.levelCurIntensityStage >= this.maxIntensityStage || ConfigMisc.Storm_NoTornadosOrCyclones && this.levelCurIntensityStage >= STATE_FORMING - 1 || !(this.levelCurStagesIntensity >= minIntensityToProgress) || !this.alwaysProgresses && rand.nextInt(oddsTo1OfIntensityProgression) != 0)) {
                        this.stageNext();
                        Weather.dbg("storm ID: " + this.ID + " - growing, stage: " + this.levelCurIntensityStage);
                        if (isInOcean && this.levelCurIntensityStage == STATE_FORMING) {
                            Weather.dbg("storm ID: " + this.ID + " marked as tropical cyclone!");
                            this.stormType = TYPE_WATER;
                        }
                    }
                    if (this.levelCurStagesIntensity >= 1.0f) {
                        Weather.dbg("storm peaked at: " + this.levelCurIntensityStage);
                        this.hasStormPeaked = true;
                    }
                } else {
                    this.levelCurStagesIntensity = ConfigMisc.overcastMode && this.manager.getWorld().func_72896_J() ? (this.levelCurStagesIntensity -= levelStormIntensityRate * 0.9f) : (this.levelCurStagesIntensity -= levelStormIntensityRate * 0.3f);
                    if (this.levelCurStagesIntensity <= 0.0f) {
                        this.stagePrev();
                        Weather.dbg("storm ID: " + this.ID + " - dying, stage: " + this.levelCurIntensityStage);
                        if (this.levelCurIntensityStage <= 0) {
                            this.setNoStorm();
                        }
                    }
                }
            } else if (ConfigMisc.overcastMode && !this.manager.getWorld().func_72896_J() && this.attrib_precipitation) {
                this.setPrecipitating(false);
            }
        }
    }

    public WeatherEntityConfig getWeatherEntityConfigForStorm() {
        WeatherEntityConfig weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(5);
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(4);
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(3);
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(2);
        } else if (this.levelCurIntensityStage >= STATE_STAGE1) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(1);
        } else if (this.levelCurIntensityStage >= STATE_FORMING) {
            weatherConfig = WeatherTypes.weatherEntTypes.get(0);
        }
        return weatherConfig;
    }

    public void stageNext() {
        ++this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 0.0f;
        if (ConfigMisc.Storm_Tornado_aimAtPlayerOnSpawn && !this.hasStormPeaked && this.levelCurIntensityStage == STATE_FORMING) {
            this.aimStormAtClosestOrProvidedPlayer(null);
        }
    }

    public void stagePrev() {
        --this.levelCurIntensityStage;
        this.levelCurStagesIntensity = 1.0f;
    }

    public void initRealStorm(EntityPlayer entP, StormObject stormToAbsorb) {
        this.levelCurIntensityStage = STATE_THUNDER;
        float diff = 4.0f;
        if (stormToAbsorb != null) {
            diff = this.levelTemperature - stormToAbsorb.levelTemperature;
        }
        if (this.naturallySpawned) {
            this.levelWater = this.levelWaterStartRaining * 2;
        }
        this.attrib_precipitation = true;
        if (stormToAbsorb != null) {
            Weather.dbg("stormfront collision happened between ID " + this.ID + " and " + stormToAbsorb.ID);
            this.manager.removeStormObject(stormToAbsorb.ID);
            ((WeatherManagerServer)this.manager).syncStormRemove(stormToAbsorb);
        } else {
            Weather.dbg("ocean storm happened, ID " + this.ID);
        }
        if (ConfigMisc.Storm_Tornado_aimAtPlayerOnSpawn && entP != null) {
            this.aimStormAtClosestOrProvidedPlayer(entP);
        }
    }

    public void aimStormAtClosestOrProvidedPlayer(EntityPlayer entP) {
        if (entP == null) {
            entP = this.manager.getWorld().func_72977_a(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord, -1.0);
        }
        if (entP != null) {
            Random rand = new Random();
            double var11 = entP.field_70165_t - this.pos.xCoord;
            double var15 = entP.field_70161_v - this.pos.zCoord;
            float yaw = -((float)(Math.atan2(var11, var15) * 180.0 / Math.PI));
            int size = ConfigMisc.Storm_Tornado_aimAtPlayerAngleVariance;
            if (size > 0) {
                yaw += (float)(rand.nextInt(size) - size / 2);
            }
            this.angleIsOverridden = true;
            this.angleMovementTornadoOverride = yaw;
            Weather.dbg("stormfront aimed at player " + CoroUtilEntity.getName((Entity)entP));
        }
    }

    public void setNoStorm() {
        Weather.dbg("storm ID: " + this.ID + " - ended storm event");
        this.levelCurIntensityStage = STATE_NORMAL;
        this.levelCurStagesIntensity = 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public void tickClient() {
        EntityRotFX ent;
        int i;
        EntityRotFX particle;
        Vec3 tryPos;
        double spawnRad;
        int i2;
        if (this.particleBehaviorFog == null) {
            this.particleBehaviorFog = new ParticleBehaviorFog(new Vec3(this.pos.xCoord, this.pos.yCoord, this.pos.zCoord));
        } else if (!Minecraft.func_71410_x().func_71356_B() || !(Minecraft.func_71410_x().field_71462_r instanceof GuiIngameMenu)) {
            this.particleBehaviorFog.tickUpdateList();
        }
        EntityPlayerSP entP = Minecraft.func_71410_x().field_71439_g;
        this.spinSpeed = 0.02;
        double spinSpeedMax = 0.4;
        this.spinSpeed = this.isCycloneFormingOrGreater() ? spinSpeedMax * 0.0 + (double)((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * spinSpeedMax * 0.2 : (this.isTornadoFormingOrGreater() ? spinSpeedMax * 0.2 : (this.levelCurIntensityStage >= STATE_HIGHWIND ? spinSpeedMax * 0.05 : spinSpeedMax * 0.02));
        if (this.isHurricane()) {
            this.spinSpeed += 0.1;
        }
        if (this.size == 0) {
            this.size = 1;
        }
        int delay = Math.max(1, (int)(100.0f / (float)this.size * 1.0f));
        int loopSize = 1;
        int extraSpawning = 0;
        if (this.isSpinning()) {
            loopSize += 4;
            extraSpawning = 300;
        }
        if (this.stormType == TYPE_WATER) {
            if (this.levelCurIntensityStage >= STATE_STAGE5) {
                loopSize = 10;
                extraSpawning = 800;
            } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
                loopSize = 8;
                extraSpawning = 700;
            } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
                loopSize = 6;
                extraSpawning = 500;
            } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
                loopSize = 4;
                extraSpawning = 400;
            } else {
                extraSpawning = 300;
            }
        }
        Random rand = new Random();
        Vec3 playerAdjPos = new Vec3(entP.field_70165_t, this.pos.yCoord, entP.field_70161_v);
        double maxSpawnDistFromPlayer = 512.0;
        if (this.manager.getWorld().func_82737_E() % (long)(delay + ConfigMisc.Cloud_ParticleSpawnDelay) == 0L) {
            for (i2 = 0; i2 < loopSize; ++i2) {
                if (this.listParticlesCloud.size() >= this.size + extraSpawning) continue;
                spawnRad = this.size;
                if (this.layer != 0) {
                    spawnRad = this.size * 5;
                }
                if (!((tryPos = new Vec3(this.pos.xCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, (double)layers.get(this.layer).intValue(), this.pos.zCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad)).distanceTo(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                particle = this.spawnFogParticle(tryPos.xCoord, tryPos.yCoord, tryPos.zCoord, 2);
                this.listParticlesCloud.add(particle);
            }
        }
        if (this.levelCurIntensityStage >= STATE_HIGHWIND) {
            for (i2 = 0; i2 < (this.stormType == TYPE_WATER ? 50 : 3); ++i2) {
                if (this.listParticlesGround.size() >= (this.stormType == TYPE_WATER ? 600 : 150)) continue;
                spawnRad = this.size / 4 * 3;
                if (this.stormType == TYPE_WATER) {
                    spawnRad = this.size * 3;
                }
                if (!((tryPos = new Vec3(this.pos.xCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad, this.posGround.yCoord, this.pos.zCoord + rand.nextDouble() * spawnRad - rand.nextDouble() * spawnRad)).distanceTo(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                int groundY = this.manager.getWorld().func_175645_m(new BlockPos((int)tryPos.xCoord, 0, (int)tryPos.zCoord)).func_177956_o();
                EntityRotFX particle2 = this.spawnFogParticle(tryPos.xCoord, groundY + 3, tryPos.zCoord, 2);
                particle2.setScale(100.0f);
                particle2.field_70177_z = rand.nextInt(360);
                particle2.field_70125_A = rand.nextInt(360);
                this.listParticlesGround.add(particle2);
            }
        }
        delay = 1;
        loopSize = 2;
        double spawnRad2 = this.size / 48;
        if (this.levelCurIntensityStage >= STATE_STAGE5) {
            spawnRad2 = 200.0;
            loopSize = 10;
            this.sizeMaxFunnelParticles = 1200;
        } else if (this.levelCurIntensityStage >= STATE_STAGE4) {
            spawnRad2 = 150.0;
            loopSize = 8;
            this.sizeMaxFunnelParticles = 1000;
        } else if (this.levelCurIntensityStage >= STATE_STAGE3) {
            spawnRad2 = 100.0;
            loopSize = 6;
            this.sizeMaxFunnelParticles = 800;
        } else if (this.levelCurIntensityStage >= STATE_STAGE2) {
            spawnRad2 = 50.0;
            loopSize = 4;
            this.sizeMaxFunnelParticles = 600;
        } else {
            this.sizeMaxFunnelParticles = 600;
        }
        if ((this.isTornadoFormingOrGreater() || this.attrib_waterSpout) && this.manager.getWorld().func_82737_E() % (long)(delay + ConfigMisc.Storm_ParticleSpawnDelay) == 0L) {
            for (i = 0; i < loopSize; ++i) {
                if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles) {
                    this.listParticlesFunnel.get(0).func_70106_y();
                    this.listParticlesFunnel.remove(0);
                }
                if (this.listParticlesFunnel.size() >= this.sizeMaxFunnelParticles || !((tryPos = new Vec3(this.pos.xCoord + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2, this.pos.yCoord, this.pos.zCoord + rand.nextDouble() * spawnRad2 - rand.nextDouble() * spawnRad2)).distanceTo(playerAdjPos) < maxSpawnDistFromPlayer)) continue;
                particle = this.spawnFogParticle(tryPos.xCoord, this.posBaseFormationPos.yCoord, tryPos.zCoord, 3);
                particle.setMaxAge(150 + (this.levelCurIntensityStage - 1) * 100 + rand.nextInt(100));
                float baseBright = 0.3f;
                float randFloat = rand.nextFloat() * 0.6f;
                particle.field_70177_z = rand.nextInt(360);
                float finalBright = Math.min(1.0f, baseBright + randFloat);
                if (this.levelCurIntensityStage == STATE_HIGHWIND) {
                    particle.setScale(150.0f);
                    particle.func_70538_b(finalBright - 0.2f, finalBright - 0.2f, finalBright);
                } else {
                    particle.setScale(250.0f);
                    particle.func_70538_b(finalBright, finalBright, finalBright);
                }
                this.listParticlesFunnel.add(particle);
            }
        }
        for (i = 0; i < this.listParticlesFunnel.size(); ++i) {
            int fadingDistStart;
            ent = this.listParticlesFunnel.get(i);
            if (ent.field_70128_L) {
                this.listParticlesFunnel.remove(ent);
                continue;
            }
            if (ent.field_70163_u > this.pos.yCoord) {
                ent.func_70106_y();
                this.listParticlesFunnel.remove(ent);
                continue;
            }
            double var16 = this.pos.xCoord - ent.field_70165_t;
            double var18 = this.pos.zCoord - ent.field_70161_v;
            ent.field_70177_z = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
            ent.field_70177_z += (float)(ent.func_145782_y() % 90);
            ent.field_70125_A = -30.0f;
            if (this.levelCurIntensityStage == STATE_HIGHWIND && ent.field_70163_u > this.posGround.yCoord + (double)(fadingDistStart = 30)) {
                float maxVal = ent.func_70535_g();
                float fadeRate = 0.002f;
                ent.func_70538_b(Math.min(maxVal, ent.func_70534_d() + fadeRate), Math.min(maxVal, ent.func_70542_f() + fadeRate), maxVal);
            }
            this.spinEntity((Entity)ent);
        }
        for (i = 0; i < this.listParticlesCloud.size(); ++i) {
            ent = this.listParticlesCloud.get(i);
            if (ent.field_70128_L) {
                this.listParticlesCloud.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
            double curDist = ent.func_70011_f(this.pos.xCoord, ent.field_70163_u, this.pos.zCoord);
            float dropDownRange = 15.0f;
            float extraDropCalc = 0.0f;
            if (curDist < 200.0 && ent.func_145782_y() % 20 < 5) {
                extraDropCalc = (float)(ent.func_145782_y() % 20) * dropDownRange;
                if (this.isCycloneFormingOrGreater()) {
                    extraDropCalc = (float)(ent.func_145782_y() % 20) * dropDownRange * 5.0f;
                }
            }
            if (this.isSpinning()) {
                double speed = this.spinSpeed + rand.nextDouble() * 0.01;
                double distt = this.size;
                double vecX = ent.field_70165_t - this.pos.xCoord;
                double vecZ = ent.field_70161_v - this.pos.zCoord;
                float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
                angle = (float)((double)angle + speed * 50.0);
                angle = (float)((double)angle - (double)(ent.func_145782_y() % 10) * 3.0);
                angle += (float)(rand.nextInt(10) - rand.nextInt(10));
                if (curDist > distt) {
                    angle += 40.0f;
                }
                if (ent.func_145782_y() % 20 < 5) {
                    if (this.levelCurIntensityStage >= STATE_FORMING) {
                        if (this.stormType == TYPE_WATER) {
                            angle += (float)(40 + ent.func_145782_y() % 5 * 4);
                            if (curDist > (double)(150.0f + ((float)this.levelCurIntensityStage - levelStormIntensityFormingStartVal + 1.0f) * 30.0f)) {
                                angle += 10.0f;
                            }
                        } else {
                            angle += (float)(30 + ent.func_145782_y() % 5 * 4);
                        }
                    } else if (curDist > 150.0) {
                        angle += (float)(50 + ent.func_145782_y() % 5 * 4);
                    }
                    double var16 = this.pos.xCoord - ent.field_70165_t;
                    double var18 = this.pos.zCoord - ent.field_70161_v;
                    ent.field_70177_z = (float)(Math.atan2(var18, var16) * 180.0 / Math.PI) - 90.0f;
                    ent.field_70125_A = -20.0f - (float)(ent.func_145782_y() % 10);
                }
                if (curSpeed < speed * 20.0) {
                    ent.field_70159_w += -Math.sin(Math.toRadians(angle)) * speed;
                    ent.field_70179_y += Math.cos(Math.toRadians(angle)) * speed;
                }
            } else {
                float cloudMoveAmp = 0.2f * (float)(1 + this.layer);
                float speed = this.getAdjustedSpeed() * cloudMoveAmp;
                float angle = this.getAdjustedAngle();
                dropDownRange = 5.0f;
                if (ent.func_145782_y() % 20 < 5) {
                    extraDropCalc = (float)(ent.func_145782_y() % 20) * dropDownRange;
                }
                if (curSpeed < (double)speed * 1.0) {
                    ent.field_70159_w += -Math.sin(Math.toRadians(angle)) * (double)speed;
                    ent.field_70179_y += Math.cos(Math.toRadians(angle)) * (double)speed;
                }
            }
            if (Math.abs(ent.field_70163_u - (this.pos.yCoord - (double)extraDropCalc)) > 2.0) {
                ent.field_70181_x = ent.field_70163_u < this.pos.yCoord - (double)extraDropCalc ? (ent.field_70181_x += 0.1) : (ent.field_70181_x -= 0.1);
            }
            float dropDownSpeedMax = 0.15f;
            if (this.isCycloneFormingOrGreater()) {
                dropDownSpeedMax = 0.9f;
            }
            if (ent.field_70181_x < (double)(-dropDownSpeedMax)) {
                ent.field_70181_x = -dropDownSpeedMax;
            }
            if (!(ent.field_70181_x > (double)dropDownSpeedMax)) continue;
            ent.field_70181_x = dropDownSpeedMax;
        }
        for (i = 0; i < this.listParticlesGround.size(); ++i) {
            ent = this.listParticlesGround.get(i);
            double curDist = ent.func_70011_f(this.pos.xCoord, ent.field_70163_u, this.pos.zCoord);
            if (ent.field_70128_L) {
                this.listParticlesGround.remove(ent);
                continue;
            }
            double curSpeed = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
            double speed = Math.max((double)0.2f, 5.0 * this.spinSpeed) + rand.nextDouble() * 0.01;
            double distt = this.size;
            double vecX = ent.field_70165_t - this.pos.xCoord;
            double vecZ = ent.field_70161_v - this.pos.zCoord;
            float angle = (float)(Math.atan2(vecZ, vecX) * 180.0 / Math.PI);
            angle += 85.0f;
            int maxParticleSize = 60;
            if (this.stormType == TYPE_WATER) {
                maxParticleSize = 150;
                speed /= 5.0;
            }
            ent.setScale((float)Math.min((double)maxParticleSize, curDist * 2.0));
            if (curDist < 20.0) {
                ent.func_70106_y();
            }
            double var16 = this.pos.xCoord - ent.field_70165_t;
            double var18 = this.pos.zCoord - ent.field_70161_v;
            if (!(curSpeed < speed * 20.0)) continue;
            ent.field_70159_w += -Math.sin(Math.toRadians(angle)) * speed;
            ent.field_70179_y += Math.cos(Math.toRadians(angle)) * speed;
        }
    }

    public float getAdjustedSpeed() {
        return this.manager.windMan.getWindSpeedForClouds();
    }

    public float getAdjustedAngle() {
        float angle = this.manager.windMan.getWindAngleForClouds();
        float angleAdjust = Math.max(10.0f, Math.min(45.0f, 45.0f * this.levelTemperature * 0.2f));
        float targetYaw = 0.0f;
        targetYaw = this.levelTemperature > 0.0f ? 180.0f : 0.0f;
        float bestMove = MathHelper.func_76142_g((float)(targetYaw - angle));
        if (Math.abs(bestMove) < 180.0f) {
            if (bestMove > 0.0f) {
                angle -= angleAdjust;
            }
            if (bestMove < 0.0f) {
                angle += angleAdjust;
            }
        }
        return angle;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void spinEntity(Entity entity1) {
        long lastPullTime;
        double adjPull;
        float f;
        float f1;
        StormObject entT = this;
        StormObject entity = this;
        WeatherEntityConfig conf = this.getWeatherEntityConfigForStorm();
        Random rand = new Random();
        boolean forTornado = true;
        double radius = 10.0;
        double scale = conf.tornadoWidthScale;
        double d1 = entity.pos.xCoord - entity1.field_70165_t;
        double d2 = entity.pos.zCoord - entity1.field_70161_v;
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT) {
            float range = 30.0f * (float)Math.sin(Math.toRadians(((float)entity1.field_70170_p.func_82737_E() * 0.5f + (float)(this.ID * 50L)) % 360.0f));
            float heightPercent = (float)(1.0 - (entity1.field_70163_u - this.posGround.yCoord) / (this.pos.yCoord - this.posGround.yCoord));
            float posOffsetX = (float)Math.sin(Math.toRadians(heightPercent * 360.0f));
            float posOffsetZ = (float)(-Math.cos(Math.toRadians(heightPercent * 360.0f)));
            d1 += (double)(range * posOffsetX);
            d2 += (double)(range * posOffsetZ);
        }
        for (f1 = f = (float)(Math.atan2(d2, d1) * 180.0 / Math.PI) - 90.0f; f1 < -180.0f; f1 += 360.0f) {
        }
        while (f1 >= 180.0f) {
            f1 -= 360.0f;
        }
        double distY = entity.pos.yCoord - entity1.field_70163_u;
        double distXZ = Math.sqrt(Math.abs(d1)) + Math.sqrt(Math.abs(d2));
        distY = entity1.field_70163_u - entity.pos.yCoord < 0.0 ? 1.0 : entity1.field_70163_u - entity.pos.yCoord;
        if (distY > (double)this.maxHeight) {
            distY = this.maxHeight;
        }
        double grab = 10.0 / (double)WeatherUtilEntity.getWeight(entity1, forTornado) * (Math.abs((double)this.maxHeight - distY) / (double)this.maxHeight);
        float pullY = 0.0f;
        if (rand.nextInt(5) != 0) {
            // empty if block
        }
        if (distXZ > 5.0) {
            grab *= radius / distXZ;
        }
        pullY += conf.tornadoLiftRate / (WeatherUtilEntity.getWeight(entity1, forTornado) / 2.0f);
        if (entity1 instanceof EntityPlayer) {
            adjPull = 0.2 / ((double)WeatherUtilEntity.getWeight(entity1, forTornado) * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            double adjGrab = 10.0 * (double)((float)(((double)WeatherUtilEntity.playerInAirTime + 1.0) / 400.0));
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (entity1.field_70181_x > -0.8) {
                entity1.field_70143_R = 0.0f;
            } else if (!(entity1.field_70181_x > -1.5)) {
                // empty if block
            }
        } else if (entity1 instanceof EntityLivingBase) {
            adjPull = 0.005 / ((double)WeatherUtilEntity.getWeight(entity1, forTornado) * ((distXZ + 1.0) / radius));
            pullY = (float)((double)pullY + adjPull);
            int airTime = entity1.getEntityData().func_74762_e("timeInAir");
            double adjGrab = 10.0 * (double)((float)(((double)airTime + 1.0) / 400.0));
            if (adjGrab > 50.0) {
                adjGrab = 50.0;
            }
            if (adjGrab < -50.0) {
                adjGrab = -50.0;
            }
            grab -= adjGrab;
            if (entity1.field_70181_x > -1.5) {
                entity1.field_70143_R = 0.0f;
            }
            if (entity1.field_70181_x > (double)0.3f) {
                entity1.field_70181_x = 0.3f;
            }
            if (forTornado) {
                entity1.field_70122_E = false;
            }
        }
        double profileAngle = Math.max(1.0, 75.0 + (grab += (double)conf.relTornadoSize) - 10.0 * scale);
        f1 = (float)((double)f1 + profileAngle);
        if (entT != null && entT.scale != 1.0f) {
            f1 += 20.0f - 20.0f * entT.scale;
        }
        float f3 = (float)Math.cos(-f1 * 0.01745329f - (float)Math.PI);
        float f4 = (float)Math.sin(-f1 * 0.01745329f - (float)Math.PI);
        float f5 = conf.tornadoPullRate * 1.0f;
        if (entT != null && entT.scale != 1.0f) {
            f5 *= entT.scale * 1.2f;
        }
        if (entity1 instanceof EntityLivingBase) {
            f5 = (float)((double)f5 / ((double)WeatherUtilEntity.getWeight(entity1, forTornado) * ((distXZ + 1.0) / radius)));
        }
        if (entity1 instanceof EntityPlayer && conf.type != 0) {
            f5 = entity1.field_70122_E ? (f5 *= 10.5f) : (f5 *= 5.0f);
        } else if (entity1 instanceof EntityLivingBase && conf.type != 0) {
            f5 *= 1.5f;
        }
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof EntityLivingBase) {
            f5 *= 0.3f;
        }
        float moveX = f3 * f5;
        float moveZ = f4 * f5;
        float str = 1.0f;
        str = this.strength;
        if (conf.type == WeatherEntityConfig.TYPE_SPOUT && entity1 instanceof EntityLivingBase) {
            str *= 0.3f;
        }
        pullY *= str / 100.0f;
        if (entT != null && entT.scale != 1.0f) {
            pullY *= entT.scale * 1.0f;
            pullY += 0.002f;
        }
        if ((lastPullTime = entity1.getEntityData().func_74763_f("lastPullTime")) == entity1.field_70170_p.func_82737_E()) {
            pullY = 0.0f;
        }
        entity1.getEntityData().func_74772_a("lastPullTime", entity1.field_70170_p.func_82737_E());
        this.setVel(entity1, -moveX, pullY, moveZ);
    }

    public void setVel(Entity entity, float f, float f1, float f2) {
        entity.field_70159_w += (double)f;
        entity.field_70181_x += (double)f1;
        entity.field_70179_y += (double)f2;
        if (entity instanceof EntitySquid) {
            entity.func_70107_b(entity.field_70165_t + entity.field_70159_w * 5.0, entity.field_70163_u, entity.field_70161_v + entity.field_70179_y * 5.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EntityRotFX spawnFogParticle(double x, double y, double z, int parRenderOrder) {
        double speed = 0.0;
        Random rand = new Random();
        EntityRotFX entityfx = this.particleBehaviorFog.spawnNewParticleIconFX((World)Minecraft.func_71410_x().field_71441_e, ParticleRegistry.cloud256, x, y, z, (rand.nextDouble() - rand.nextDouble()) * speed, 0.0, (rand.nextDouble() - rand.nextDouble()) * speed, parRenderOrder);
        this.particleBehaviorFog.initParticle(entityfx);
        entityfx.field_70145_X = true;
        entityfx.callUpdatePB = false;
        boolean debug = false;
        if (debug) {
            // empty if block
        }
        if (this.levelCurIntensityStage == STATE_NORMAL) {
            entityfx.setMaxAge(300 + rand.nextInt(100));
        } else {
            entityfx.setMaxAge(this.size / 2 + rand.nextInt(100));
        }
        if (entityfx.func_145782_y() % 20 < 5 && this.isSpinning()) {
            entityfx.renderOrder = 3;
            entityfx.setMaxAge(this.size + rand.nextInt(100));
        }
        float randFloat = rand.nextFloat() * 0.6f;
        float baseBright = 0.7f;
        if (this.levelCurIntensityStage > STATE_NORMAL) {
            baseBright = 0.2f;
        } else if (this.attrib_precipitation) {
            baseBright = 0.2f;
        } else if (this.manager.isVanillaRainActiveOnServer) {
            baseBright = 0.2f;
        } else {
            float adj = Math.min(1.0f, (float)(this.levelWater / this.levelWaterStartRaining)) * 0.6f;
            baseBright -= adj;
        }
        if (this.layer == 1) {
            baseBright = 0.1f;
        }
        float finalBright = Math.min(1.0f, baseBright + randFloat);
        entityfx.func_70538_b(finalBright, finalBright, finalBright);
        if (debug) {
            if (this.levelTemperature < 0.0f) {
                entityfx.func_70538_b(0.0f, 0.0f, finalBright);
            } else if (this.levelTemperature > 0.0f) {
                entityfx.func_70538_b(finalBright, 0.0f, 0.0f);
            }
        }
        ExtendedRenderer.rotEffRenderer.addEffect((EntityFX)entityfx);
        this.particleBehaviorFog.particles.add(entityfx);
        return entityfx;
    }

    public void reset() {
        this.setDead();
    }

    public void setDead() {
        this.isDead = true;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.cleanupClient();
        }
        this.cleanup();
    }

    public void cleanup() {
        this.manager = null;
        if (this.tornadoHelper != null) {
            this.tornadoHelper.storm = null;
        }
        this.tornadoHelper = null;
    }

    @SideOnly(value=Side.CLIENT)
    public void cleanupClient() {
        this.listParticlesCloud.clear();
        this.listParticlesFunnel.clear();
        if (this.particleBehaviorFog != null && this.particleBehaviorFog.particles != null) {
            this.particleBehaviorFog.particles.clear();
        }
        this.particleBehaviorFog = null;
    }

    public float getTemperatureMCToWeatherSys(float parOrigVal) {
        parOrigVal = (float)((double)parOrigVal - 0.7);
        return parOrigVal *= 2.0f;
    }

    public void addWeatherEffectLightning(EntityLightningBolt parEnt) {
        this.manager.getWorld().field_73007_j.add(parEnt);
        ((WeatherManagerServer)this.manager).syncLightningNew(parEnt);
    }
}

