/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFPlatform;
import com.cinemamod.mcef.MCEFSettings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;

final class CefUtil {
    private static boolean init;
    private static CefApp cefAppInstance;
    private static CefClient cefClientInstance;

    private CefUtil() {
    }

    private static void setUnixExecutable(File file) {
        HashSet<PosixFilePermission> perms = new HashSet<PosixFilePermission>();
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        try {
            Files.setPosixFilePermissions(file.toPath(), perms);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static boolean init() {
        MCEFPlatform platform = MCEFPlatform.getPlatform();
        if (platform.isLinux()) {
            File jcefHelperFile = new File(System.getProperty("mcef.libraries.path"), platform.getNormalizedName() + "/jcef_helper");
            CefUtil.setUnixExecutable(jcefHelperFile);
        } else if (platform.isMacOS()) {
            File mcefLibrariesPath = new File(System.getProperty("mcef.libraries.path"));
            File jcefHelperFile = new File(mcefLibrariesPath, platform.getNormalizedName() + "/jcef_app.app/Contents/Frameworks/jcef Helper.app/Contents/MacOS/jcef Helper");
            File jcefHelperGPUFile = new File(mcefLibrariesPath, platform.getNormalizedName() + "/jcef_app.app/Contents/Frameworks/jcef Helper (GPU).app/Contents/MacOS/jcef Helper (GPU)");
            File jcefHelperPluginFile = new File(mcefLibrariesPath, platform.getNormalizedName() + "/jcef_app.app/Contents/Frameworks/jcef Helper (Plugin).app/Contents/MacOS/jcef Helper (Plugin)");
            File jcefHelperRendererFile = new File(mcefLibrariesPath, platform.getNormalizedName() + "/jcef_app.app/Contents/Frameworks/jcef Helper (Renderer).app/Contents/MacOS/jcef Helper (Renderer)");
            CefUtil.setUnixExecutable(jcefHelperFile);
            CefUtil.setUnixExecutable(jcefHelperGPUFile);
            CefUtil.setUnixExecutable(jcefHelperPluginFile);
            CefUtil.setUnixExecutable(jcefHelperRendererFile);
        }
        String[] cefSwitches = new String[]{"--autoplay-policy=no-user-gesture-required", "--disable-web-security", "--enable-widevine-cdm"};
        if (!CefApp.startup(cefSwitches)) {
            return false;
        }
        MCEFSettings settings = MCEF.getSettings();
        CefSettings cefSettings = new CefSettings();
        cefSettings.windowless_rendering_enabled = true;
        CefSettings cefSettings2 = cefSettings;
        Objects.requireNonNull(cefSettings2);
        cefSettings.background_color = new CefSettings.ColorType(cefSettings2, 0, 255, 255, 255);
        if (!Objects.equals(settings.getUserAgent(), "null")) {
            cefSettings.user_agent = settings.getUserAgent();
        } else {
            cefSettings.user_agent_product = "MCEF/2";
        }
        cefAppInstance = CefApp.getInstance(cefSwitches, cefSettings);
        cefClientInstance = cefAppInstance.createClient();
        CefUtil.cefAppInstance.macOSTerminationRequestRunnable = new Runnable(){

            @Override
            public void run() {
                Minecraft.m_91087_().m_91395_();
            }
        };
        init = true;
        return true;
    }

    static void shutdown() {
        if (CefUtil.isInit()) {
            init = false;
            cefClientInstance.dispose();
            cefAppInstance.dispose();
        }
    }

    static boolean isInit() {
        return init;
    }

    static CefApp getCefApp() {
        return cefAppInstance;
    }

    static CefClient getCefClient() {
        return cefClientInstance;
    }
}

