/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef;

import com.cinemamod.mcef.MIMEUtil;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import org.cef.callback.CefCallback;
import org.cef.handler.CefResourceHandler;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.slf4j.Logger;

public class ModScheme
implements CefResourceHandler {
    private String contentType = null;
    private InputStream is = null;
    private final String url;
    private static final Logger LOGGER = LogUtils.getLogger();

    public ModScheme(String url) {
        this.url = url;
    }

    @Override
    public boolean processRequest(CefRequest cefRequest, CefCallback cefCallback) {
        String url = this.url.substring("mod://".length());
        int pos = url.indexOf(47);
        if (pos < 0) {
            cefCallback.cancel();
            return false;
        }
        String mod = this.removeSlashes(url.substring(0, pos));
        String loc = this.removeSlashes(url.substring(pos + 1));
        if (mod.length() <= 0 || loc.length() <= 0 || mod.charAt(0) == '.' || loc.charAt(0) == '.') {
            LOGGER.warn("Invalid URL " + url);
            cefCallback.cancel();
            return false;
        }
        this.is = ModScheme.class.getClassLoader().getResourceAsStream("/assets/" + mod.toLowerCase() + "/html/" + loc.toLowerCase());
        if (this.is == null) {
            LOGGER.warn("Resource " + url + " NOT found!");
            cefCallback.cancel();
            return false;
        }
        this.contentType = null;
        pos = loc.lastIndexOf(46);
        if (pos >= 0 && pos < loc.length() - 2) {
            this.contentType = MIMEUtil.mimeFromExtension(loc.substring(pos + 1));
        }
        cefCallback.Continue();
        return true;
    }

    private String removeSlashes(String loc) {
        int i;
        for (i = 0; i < loc.length() && loc.charAt(i) == '/'; ++i) {
        }
        return loc.substring(i);
    }

    @Override
    public void getResponseHeaders(CefResponse cefResponse, IntRef contentLength, StringRef redir) {
        if (this.contentType != null) {
            cefResponse.setMimeType(this.contentType);
        }
        cefResponse.setStatus(200);
        cefResponse.setStatusText("OK");
        contentLength.set(0);
    }

    @Override
    public boolean readResponse(byte[] output, int bytesToRead, IntRef bytesRead, CefCallback cefCallback) {
        try {
            int ret = this.is.read(output, 0, bytesToRead);
            if (ret <= 0) {
                this.is.close();
                bytesRead.set(0);
                return false;
            }
            bytesRead.set(ret);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }
    }

    @Override
    public void cancel() {
        try {
            this.is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

