/*
 * Decompiled with CFR 0.152.
 */
package com.cinemamod.mcef.mixins;

import com.cinemamod.mcef.MCEF;
import com.cinemamod.mcef.MCEFDownloader;
import com.cinemamod.mcef.MCEFPlatform;
import com.cinemamod.mcef.MCEFSettings;
import com.cinemamod.mcef.internal.MCEFDownloadListener;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.resources.ClientPackSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPackSource.class})
public class CefDownloadMixin {
    @Unique
    private static void setupLibraryPath() throws IOException {
        File buildDir = new File("../build");
        File mcefLibrariesDir = buildDir.exists() && buildDir.isDirectory() ? new File(buildDir, "mcef-libraries/") : new File("mods/mcef-libraries/");
        mcefLibrariesDir.mkdirs();
        System.setProperty("mcef.libraries.path", mcefLibrariesDir.getCanonicalPath());
        System.setProperty("jcef.path", new File(mcefLibrariesDir, MCEFPlatform.getPlatform().getNormalizedName()).getCanonicalPath());
    }

    @Inject(at={@At(value="HEAD")}, method={"<clinit>"})
    private static void sinit(CallbackInfo callbackInfo) {
        try {
            CefDownloadMixin.setupLibraryPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Thread downloadThread = new Thread(() -> {
            boolean downloadJcefBuild;
            String javaCefCommit;
            try {
                javaCefCommit = MCEF.getJavaCefCommit();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            MCEF.getLogger().info("java-cef commit: " + javaCefCommit);
            MCEFSettings settings = MCEF.getSettings();
            MCEFDownloader downloader = new MCEFDownloader(settings.getDownloadMirror(), javaCefCommit, MCEFPlatform.getPlatform());
            try {
                downloadJcefBuild = !downloader.downloadJavaCefChecksum(MCEFDownloadListener.INSTANCE);
            }
            catch (IOException e) {
                e.printStackTrace();
                MCEFDownloadListener.INSTANCE.setFailed(true);
                return;
            }
            if (downloadJcefBuild && !settings.isSkipDownload()) {
                try {
                    downloader.downloadJavaCefBuild(MCEFDownloadListener.INSTANCE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    MCEFDownloadListener.INSTANCE.setFailed(true);
                    return;
                }
                downloader.extractJavaCefBuild(true, MCEFDownloadListener.INSTANCE);
            }
            MCEFDownloadListener.INSTANCE.setDone(true);
        });
        downloadThread.start();
    }
}

