/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.common.mixin.bugfix.world_leaks;

import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
@ClientOnlyMixin
public class MinecraftMixin {
    @Shadow
    @Nullable
    public ClientLevel level;

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/Minecraft;level:Lnet/minecraft/client/multiplayer/ClientLevel;")})
    private void clearLevelDataForLeaks(CallbackInfo ci) {
        if (this.level != null) {
            try {
                AtomicReferenceArray chunks = this.level.getChunkSource().storage.chunks;
                for (int i = 0; i < chunks.length(); ++i) {
                    chunks.set(i, null);
                }
                this.level.getChunkSource().lightEngine = new LevelLightEngine((LightChunkGetter)this.level.getChunkSource(), false, false);
                this.level.blockEntityTickers.clear();
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception clearing level data", (Throwable)e);
            }
        }
    }
}

