/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.neoforge.mixin.perf.dynamic_resources;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.duck.IExtendedModelBaker;
import org.embeddedt.modernfix.duck.IExtendedModelBakery;
import org.embeddedt.modernfix.dynamicresources.DynamicBakedModelProvider;
import org.embeddedt.modernfix.dynamicresources.ModelBakeryHelpers;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ModelBakery.class}, priority=1100)
@ClientOnlyMixin
public abstract class ModelBakeryMixin
implements IExtendedModelBakery {
    private static final boolean debugDynamicModelLoading = Boolean.getBoolean("modernfix.debugDynamicModelLoading");
    @Shadow
    @Final
    @Mutable
    public Map<ResourceLocation, UnbakedModel> unbakedCache;
    @Shadow
    @Final
    public static ModelResourceLocation MISSING_MODEL_LOCATION;
    @Shadow
    @Final
    private Set<ResourceLocation> loadingStack;
    @Shadow
    @Final
    @Mutable
    private Map<ResourceLocation, BakedModel> bakedTopLevelModels;
    @Shadow
    @Final
    @Mutable
    private Map<ModelBakery.BakedCacheKey, BakedModel> bakedCache;
    @Shadow
    @Final
    @Mutable
    private BlockColors blockColors;
    @Shadow
    @Final
    private static Logger LOGGER;
    private Cache<ModelBakery.BakedCacheKey, BakedModel> loadedBakedModels;
    private Cache<ResourceLocation, UnbakedModel> loadedModels;
    private HashMap<ResourceLocation, UnbakedModel> smallLoadingCache = new HashMap();
    private boolean ignoreModelLoad;
    private boolean fabric_enableGetOrLoadModelGuard;
    private UnbakedModel missingModel;
    private Set<ResourceLocation> blockStateFiles;
    private Set<ResourceLocation> modelFiles;
    private BiFunction<ResourceLocation, Material, TextureAtlasSprite> textureGetter;
    private int mfix$nestedLoads = 0;
    private BakedModel bakedMissingModel = null;

    @Shadow
    protected abstract BlockModel loadBlockModel(ResourceLocation var1) throws IOException;

    @Shadow
    protected abstract void loadModel(ResourceLocation var1) throws Exception;

    @Shadow
    public abstract void loadTopLevel(ModelResourceLocation var1);

    @Shadow
    public abstract UnbakedModel getModel(ResourceLocation var1);

    @Redirect(method={"<init>(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/Map;Ljava/util/Map;)V"}, at=@At(value="FIELD", opcode=181, target="Lnet/minecraft/client/resources/model/ModelBakery;blockColors:Lnet/minecraft/client/color/block/BlockColors;"))
    private void replaceTopLevelBakedModels(ModelBakery bakery, BlockColors val) {
        this.fabric_enableGetOrLoadModelGuard = false;
        this.blockColors = val;
        this.loadedBakedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.loadedModels = CacheBuilder.newBuilder().expireAfterAccess(300L, TimeUnit.SECONDS).maximumSize(10000L).concurrencyLevel(8).removalListener(this::onModelRemoved).softValues().build();
        this.bakedCache = this.loadedBakedModels.asMap();
        final ConcurrentMap unbakedCacheBackingMap = this.loadedModels.asMap();
        this.unbakedCache = new ForwardingMap<ResourceLocation, UnbakedModel>(){

            protected Map<ResourceLocation, UnbakedModel> delegate() {
                return unbakedCacheBackingMap;
            }

            public UnbakedModel put(ResourceLocation key, UnbakedModel value) {
                ModelBakeryMixin.this.smallLoadingCache.put(key, value);
                return (UnbakedModel)super.put((Object)key, (Object)value);
            }
        };
        this.bakedTopLevelModels = new DynamicBakedModelProvider((ModelBakery)this, this.bakedCache);
    }

    @ModifyArg(method={"<init>(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/Map;Ljava/util/Map;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=0), index=0)
    private String ignoreFutureModelLoads(String name) {
        this.ignoreModelLoad = true;
        return name;
    }

    private <K, V> void onModelRemoved(RemovalNotification<K, V> notification) {
        ResourceLocation rl;
        if (!debugDynamicModelLoading) {
            return;
        }
        Object k = notification.getKey();
        if (k == null) {
            return;
        }
        boolean baked = false;
        if (k instanceof ResourceLocation) {
            rl = (ResourceLocation)k;
        } else {
            rl = ((ModelBakery.BakedCacheKey)k).id();
            baked = true;
        }
        if (!baked && this.loadedModels.getIfPresent((Object)rl) != null) {
            return;
        }
        ModernFix.LOGGER.warn("Evicted {} model {}", (Object)(baked ? "baked" : "unbaked"), (Object)rl);
    }

    @ModifyArg(method={"<init>(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/Map;Ljava/util/Map;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", ordinal=0), index=1)
    private Object captureMissingModel(Object model) {
        this.missingModel = (UnbakedModel)model;
        this.blockStateFiles = new HashSet<ResourceLocation>();
        this.modelFiles = new HashSet<ResourceLocation>();
        return this.missingModel;
    }

    @Redirect(method={"*"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/resources/model/ModelBakery;loadTopLevel(Lnet/minecraft/client/resources/model/ModelResourceLocation;)V"))
    private void addTopLevelFile(ModelBakery bakery, ModelResourceLocation location) {
        if (location == MISSING_MODEL_LOCATION || !this.ignoreModelLoad) {
            this.loadTopLevel(location);
        }
    }

    @Redirect(method={"<init>(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/Map;Ljava/util/Map;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;forEach(Ljava/util/function/BiConsumer;)V", ordinal=0))
    private void fetchStaticDefinitions(Map<ResourceLocation, StateDefinition<Block, BlockState>> map, BiConsumer<ResourceLocation, StateDefinition<Block, BlockState>> func) {
    }

    @Redirect(method={"<init>(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/Map;Ljava/util/Map;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;", ordinal=0))
    private ImmutableList<BlockState> fetchBlocks(StateDefinition<Block, BlockState> def) {
        return ImmutableList.of();
    }

    @Redirect(method={"<init>(Lnet/minecraft/client/color/block/BlockColors;Lnet/minecraft/util/profiling/ProfilerFiller;Ljava/util/Map;Ljava/util/Map;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;values()Ljava/util/Collection;", ordinal=0))
    private Collection<?> copyTopLevelModelList(Map<?, ?> map) {
        return new ArrayList(map.values());
    }

    @Inject(method={"bakeModels(Ljava/util/function/BiFunction;)V"}, at={@At(value="HEAD")})
    private void captureGetter(BiFunction<ResourceLocation, Material, TextureAtlasSprite> getter, CallbackInfo ci) {
        this.ignoreModelLoad = false;
        this.textureGetter = getter;
        DynamicBakedModelProvider.currentInstance = (DynamicBakedModelProvider)this.bakedTopLevelModels;
    }

    @Redirect(method={"bakeModels(Ljava/util/function/BiFunction;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;keySet()Ljava/util/Set;"))
    private Set<ResourceLocation> skipBake(Map<ResourceLocation, UnbakedModel> instance) {
        HashSet<ResourceLocation> modelSet = new HashSet<ResourceLocation>(instance.keySet());
        if (modelSet.size() > 0) {
            ModernFix.LOGGER.info("Early baking {} models", (Object)modelSet.size());
        }
        return modelSet;
    }

    @Redirect(method={"loadModel(Lnet/minecraft/resources/ResourceLocation;)V"}, at=@At(value="INVOKE", target="Ljava/util/Map;get(Ljava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private Object getMissingModel(Map map, Object rl) {
        if (rl == MISSING_MODEL_LOCATION && map == this.unbakedCache) {
            return this.missingModel;
        }
        return this.unbakedCache.get(rl);
    }

    @ModifyVariable(method={"cacheAndQueueDependencies(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/model/UnbakedModel;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private UnbakedModel fireUnbakedEvent(UnbakedModel model, ResourceLocation location) {
        for (ModernFixClientIntegration integration : ModernFixClient.CLIENT_INTEGRATIONS) {
            try {
                model = integration.onUnbakedModelLoad(location, model, (ModelBakery)this);
            }
            catch (RuntimeException e) {
                ModernFix.LOGGER.error("Exception firing model load event for {}", (Object)location, (Object)e);
            }
        }
        return model;
    }

    @Inject(method={"cacheAndQueueDependencies(Lnet/minecraft/resources/ResourceLocation;Lnet/minecraft/client/resources/model/UnbakedModel;)V"}, at={@At(value="RETURN")})
    private void addToSmallLoadingCache(ResourceLocation location, UnbakedModel model, CallbackInfo ci) {
        this.smallLoadingCache.put(location, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getModel(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/resources/model/UnbakedModel;"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOrLoadModelDynamic(ResourceLocation modelLocation, CallbackInfoReturnable<UnbakedModel> cir) {
        if (modelLocation.equals((Object)MISSING_MODEL_LOCATION)) {
            cir.setReturnValue((Object)this.missingModel);
            return;
        }
        UnbakedModel existing = this.unbakedCache.get(modelLocation);
        if (existing != null) {
            cir.setReturnValue((Object)existing);
        } else {
            ModelBakeryMixin modelBakeryMixin = this;
            synchronized (modelBakeryMixin) {
                if (this.loadingStack.contains(modelLocation)) {
                    throw new IllegalStateException("Circular reference while loading " + modelLocation);
                }
                this.loadingStack.add(modelLocation);
                UnbakedModel iunbakedmodel = this.missingModel;
                while (!this.loadingStack.isEmpty()) {
                    ResourceLocation resourcelocation = this.loadingStack.iterator().next();
                    ++this.mfix$nestedLoads;
                    try {
                        existing = this.unbakedCache.get(resourcelocation);
                        if (existing == null) {
                            if (debugDynamicModelLoading) {
                                LOGGER.info("Loading {}", (Object)resourcelocation);
                            }
                            this.loadModel(resourcelocation);
                            continue;
                        }
                        this.smallLoadingCache.put(resourcelocation, existing);
                    }
                    catch (ModelBakery.BlockStateDefinitionException var9) {
                        LOGGER.warn(var9.getMessage());
                        this.unbakedCache.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    catch (Exception var10) {
                        LOGGER.warn("Unable to load model: '{}' referenced from: {}: {}", new Object[]{resourcelocation, modelLocation, var10});
                        this.unbakedCache.put(resourcelocation, iunbakedmodel);
                        this.smallLoadingCache.put(resourcelocation, iunbakedmodel);
                    }
                    finally {
                        --this.mfix$nestedLoads;
                        this.loadingStack.remove(resourcelocation);
                    }
                }
                UnbakedModel result = this.smallLoadingCache.getOrDefault(modelLocation, iunbakedmodel);
                try {
                    result.resolveParents(this::getModel);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (this.mfix$nestedLoads == 0) {
                    this.smallLoadingCache.clear();
                }
                cir.setReturnValue((Object)result);
            }
        }
    }

    private <T extends Comparable<T>, V extends T> BlockState setPropertyGeneric(BlockState state, Property<T> prop, Object o) {
        return (BlockState)state.setValue(prop, (Comparable)o);
    }

    @Redirect(method={"loadModel(Lnet/minecraft/resources/ResourceLocation;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/StateDefinition;getPossibleStates()Lcom/google/common/collect/ImmutableList;"))
    private ImmutableList<BlockState> loadOnlyRelevantBlockState(StateDefinition<Block, BlockState> stateDefinition, ResourceLocation location) {
        if (!(location instanceof ModelResourceLocation) || Minecraft.getInstance().level == null) {
            return stateDefinition.getPossibleStates();
        }
        return ModelBakeryHelpers.getBlockStatesForMRL(stateDefinition, (ModelResourceLocation)location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BakedModel bakeDefault(ResourceLocation modelLocation, ModelState state) {
        ModelBakery self;
        ModelBakery.BakedCacheKey key = new ModelBakery.BakedCacheKey(modelLocation, BlockModelRotation.X0_Y0.getRotation(), BlockModelRotation.X0_Y0.isUvLocked());
        BakedModel m = (BakedModel)this.loadedBakedModels.getIfPresent((Object)key);
        if (m != null) {
            return m;
        }
        ModelBakery modelBakery = self = (ModelBakery)this;
        Objects.requireNonNull(modelBakery);
        ModelBakery.ModelBakerImpl theBaker = new ModelBakery.ModelBakerImpl(modelBakery, this.textureGetter, modelLocation);
        ((IExtendedModelBaker)theBaker).throwOnMissingModel(true);
        ModelBakeryMixin modelBakeryMixin = this;
        synchronized (modelBakeryMixin) {
            m = theBaker.bake(modelLocation, state, theBaker.getModelTextureGetter());
        }
        if (m != null) {
            this.loadedBakedModels.put((Object)key, (Object)m);
        }
        return m;
    }

    @Override
    public ImmutableList<BlockState> getBlockStatesForMRL(StateDefinition<Block, BlockState> stateDefinition, ModelResourceLocation location) {
        return this.loadOnlyRelevantBlockState(stateDefinition, (ResourceLocation)location);
    }

    public void setBakedMissingModel(BakedModel m) {
        this.bakedMissingModel = m;
    }

    public BakedModel getBakedMissingModel() {
        return this.bakedMissingModel;
    }

    @Override
    public UnbakedModel mfix$getUnbakedMissingModel() {
        return this.missingModel;
    }
}

