/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.packet;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.embeddedt.modernfix.ModernFix;

public class EntityIDSyncPacket
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("modernfix", "entity_id_sync");
    private Map<Class<? extends Entity>, List<Pair<String, Integer>>> map;

    public EntityIDSyncPacket(Map<Class<? extends Entity>, List<Pair<String, Integer>>> map) {
        this.map = map;
    }

    public Map<Class<? extends Entity>, List<Pair<String, Integer>>> getFieldInfo() {
        return this.map;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeVarInt(this.map.keySet().size());
        for (Map.Entry<Class<? extends Entity>, List<Pair<String, Integer>>> entry : this.map.entrySet()) {
            buf.writeUtf(entry.getKey().getName());
            buf.writeVarInt(entry.getValue().size());
            for (Pair<String, Integer> field : entry.getValue()) {
                buf.writeUtf((String)field.getFirst());
                buf.writeVarInt(((Integer)field.getSecond()).intValue());
            }
        }
    }

    public EntityIDSyncPacket(FriendlyByteBuf buf) {
        this.map = new HashMap<Class<? extends Entity>, List<Pair<String, Integer>>>();
        EntityIDSyncPacket self = this;
        int numEntityClasses = buf.readVarInt();
        for (int i = 0; i < numEntityClasses; ++i) {
            String clzName = buf.readUtf();
            try {
                Class<?> clz;
                try {
                    clz = Class.forName(clzName);
                }
                catch (ClassNotFoundException e) {
                    ModernFix.LOGGER.warn("Entity class not found: {}", (Object)clzName);
                    break;
                }
                if (!Entity.class.isAssignableFrom(clz)) {
                    ModernFix.LOGGER.error("Not an entity: " + clzName);
                    break;
                }
                int numFields = buf.readVarInt();
                for (int j = 0; j < numFields; ++j) {
                    String fieldName = buf.readUtf();
                    int id = buf.readVarInt();
                    Field f = clz.getDeclaredField(fieldName);
                    if (!Modifier.isStatic(f.getModifiers())) continue;
                    f.setAccessible(true);
                    if (!EntityDataAccessor.class.isAssignableFrom(f.get(null).getClass())) {
                        ModernFix.LOGGER.error("Not a data accessor field: " + clz + "." + fieldName);
                        continue;
                    }
                    self.map.computeIfAbsent(clz, k -> new ArrayList()).add(Pair.of((Object)fieldName, (Object)id));
                }
                continue;
            }
            catch (ReflectiveOperationException e) {
                ModernFix.LOGGER.error("Error deserializing packet", (Throwable)e);
            }
        }
    }

    public ResourceLocation id() {
        return ID;
    }
}

