/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.searchtree;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.embeddedt.modernfix.searchtree.DummySearchTree;

public class RecipeBookSearchTree
extends DummySearchTree<RecipeCollection> {
    private final SearchTree<ItemStack> stackCollector;
    private Map<Item, List<RecipeCollection>> collectionsByItem = null;
    private final List<RecipeCollection> allCollections;

    public RecipeBookSearchTree(SearchTree<ItemStack> stackCollector, List<RecipeCollection> allCollections) {
        this.stackCollector = stackCollector;
        this.allCollections = allCollections;
    }

    private Map<Item, List<RecipeCollection>> populateCollectionMap() {
        Object2ObjectOpenHashMap collections = this.collectionsByItem;
        if (collections == null) {
            Object2ObjectOpenHashMap finalCollection = collections = new Object2ObjectOpenHashMap();
            for (RecipeCollection collection : this.allCollections) {
                collection.getRecipes().stream().map(recipe -> recipe.value().getResultItem(collection.registryAccess()).getItem()).distinct().forEach(arg_0 -> RecipeBookSearchTree.lambda$populateCollectionMap$2((Map)finalCollection, collection, arg_0));
            }
            this.collectionsByItem = collections;
        }
        return collections;
    }

    @Override
    public void refresh() {
        this.collectionsByItem = null;
    }

    @Override
    public List<RecipeCollection> search(String pSearchText) {
        if (pSearchText.trim().length() == 0) {
            return this.allCollections;
        }
        List stacks = this.stackCollector.search(pSearchText);
        Map<Item, List<RecipeCollection>> collections = this.populateCollectionMap();
        return stacks.stream().map(ItemStack::getItem).distinct().flatMap(item -> collections.getOrDefault(item, Collections.emptyList()).stream()).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$populateCollectionMap$2(Map finalCollection, RecipeCollection collection, Item item) {
        finalCollection.computeIfAbsent(item, k -> new ArrayList()).add(collection);
    }
}

