/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.structure;

import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.platform.ModernFixPlatformHooks;
import org.embeddedt.modernfix.util.FileUtil;

public class CachingStructureManager {
    private static ThreadLocal<MessageDigest> digestThreadLocal = ThreadLocal.withInitial(() -> {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    });
    private static final File STRUCTURE_CACHE_FOLDER = FileUtil.childFile(ModernFixPlatformHooks.INSTANCE.getGameDirectory().resolve("modernfix").resolve("structureCacheV1").toFile());
    private static final Set<String> laggyStructureMods;
    private static final int MAX_HASH_LENGTH = 9;

    public static StructureTemplate readStructure(ResourceLocation location, DataFixer datafixer, InputStream stream, HolderGetter<Block> blockGetter) throws IOException {
        CompoundTag tag = CachingStructureManager.readStructureTag(location, datafixer, stream);
        StructureTemplate template = new StructureTemplate();
        template.load(blockGetter, tag);
        return template;
    }

    private static String encodeHex(byte[] byteArray) {
        StringBuilder sb = new StringBuilder();
        for (byte b : byteArray) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    private static String truncateHash(String hash) {
        return hash.substring(0, 10);
    }

    public static CompoundTag readStructureTag(ResourceLocation location, DataFixer datafixer, InputStream stream) throws IOException {
        int requiredMinimumDataVersion;
        int currentDataVersion;
        byte[] structureBytes = CachingStructureManager.toBytes(stream);
        CompoundTag currentTag = NbtIo.readCompressed((InputStream)new ByteArrayInputStream(structureBytes), (NbtAccounter)NbtAccounter.unlimitedHeap());
        if (!currentTag.contains("DataVersion", 99)) {
            currentTag.putInt("DataVersion", 500);
        }
        if ((currentDataVersion = currentTag.getInt("DataVersion")) < (requiredMinimumDataVersion = SharedConstants.getCurrentVersion().getDataVersion().getVersion())) {
            MessageDigest hasher = digestThreadLocal.get();
            hasher.reset();
            String hash = CachingStructureManager.encodeHex(hasher.digest(structureBytes));
            CompoundTag cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, CachingStructureManager.truncateHash(hash));
            if (cachedUpgraded == null) {
                cachedUpgraded = CachingStructureManager.getCachedUpgraded(location, hash);
            }
            if (cachedUpgraded != null && cachedUpgraded.getInt("DataVersion") == requiredMinimumDataVersion) {
                ModernFix.LOGGER.debug("Using cached upgraded version of {}", (Object)location);
                currentTag = cachedUpgraded;
            } else {
                ModernFix.LOGGER.debug("Structure {} is being run through DFU (hash {}), this will cause launch time delays", (Object)location, (Object)hash);
                currentTag = DataFixTypes.STRUCTURE.update(datafixer, currentTag, currentDataVersion, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                currentTag.putInt("DataVersion", SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                CachingStructureManager.saveCachedUpgraded(location, hash, currentTag);
            }
        }
        return currentTag;
    }

    private static File getCachePath(ResourceLocation location, String hash) {
        String fileName = location.getNamespace() + "_" + location.getPath().replace('/', '_') + "_" + hash + ".nbt";
        return new File(STRUCTURE_CACHE_FOLDER, fileName);
    }

    private static synchronized CompoundTag getCachedUpgraded(ResourceLocation location, String hash) {
        CompoundTag compoundTag;
        File theFile = CachingStructureManager.getCachePath(location, hash);
        FileInputStream stream = new FileInputStream(theFile);
        try {
            compoundTag = NbtIo.readCompressed((InputStream)stream, (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        stream.close();
        return compoundTag;
    }

    private static synchronized void saveCachedUpgraded(ResourceLocation location, String hash, CompoundTag tagToSave) {
        File theFile = CachingStructureManager.getCachePath(location, CachingStructureManager.truncateHash(hash));
        try (FileOutputStream stream = new FileOutputStream(theFile);){
            NbtIo.writeCompressed((CompoundTag)tagToSave, (OutputStream)stream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static byte[] toBytes(InputStream stream) throws IOException {
        int n;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] tmp = new byte[16384];
        while ((n = stream.read(tmp, 0, tmp.length)) != -1) {
            buffer.write(tmp, 0, n);
        }
        return buffer.toByteArray();
    }

    static {
        STRUCTURE_CACHE_FOLDER.mkdirs();
        laggyStructureMods = new ObjectOpenHashSet();
    }
}

