/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.world;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.saveddata.SavedData;

public class StrongholdLocationCache
extends SavedData {
    private List<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();

    public static SavedData.Factory<StrongholdLocationCache> factory(ServerLevel serverLevel) {
        return new SavedData.Factory(StrongholdLocationCache::new, StrongholdLocationCache::load, DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    }

    public List<ChunkPos> getChunkPosList() {
        return new ArrayList<ChunkPos>(this.chunkPosList);
    }

    public void setChunkPosList(List<ChunkPos> positions) {
        this.chunkPosList = new ArrayList<ChunkPos>(positions);
        this.setDirty();
    }

    public static StrongholdLocationCache load(CompoundTag arg) {
        StrongholdLocationCache cache = new StrongholdLocationCache();
        if (arg.contains("Positions", 12)) {
            long[] positions;
            for (long position : positions = arg.getLongArray("Positions")) {
                cache.chunkPosList.add(new ChunkPos(position));
            }
        }
        return cache;
    }

    public CompoundTag save(CompoundTag compoundTag) {
        long[] serialized = new long[this.chunkPosList.size()];
        for (int i = 0; i < this.chunkPosList.size(); ++i) {
            ChunkPos thePos = this.chunkPosList.get(i);
            serialized[i] = thePos.toLong();
        }
        compoundTag.putLongArray("Positions", serialized);
        return compoundTag;
    }

    public static String getFileId(Holder<DimensionType> dimensionType) {
        return "mfix_strongholds";
    }
}

