/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Events;

import com.wuest.prefab.BuildingMethods;
import com.wuest.prefab.Capabilities.StructureConfigurationCapability;
import com.wuest.prefab.Capabilities.StructureConfigurationProvider;
import com.wuest.prefab.Config.ModConfiguration;
import com.wuest.prefab.Items.ItemBasicStructure;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.ClientProxy;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.Proxy.Messages.ConfigSyncMessage;
import com.wuest.prefab.StructureGen.BuildBlock;
import com.wuest.prefab.StructureGen.Structure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ModEventHandler {
    public static final String GIVEN_HOUSEBUILDER_TAG = "givenHousebuilder";
    public static HashMap<EntityPlayer, ArrayList<Structure>> structuresToBuild = new HashMap();
    public static ArrayList<BlockPos> RedstoneAffectedBlockPositions = null;

    @SubscribeEvent
    public void PlayerJoinedWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayer) {
            boolean shouldGiveHousebuilder;
            System.out.println("Player joined world, checking to see if the house builder should be provided.");
            EntityPlayer player = (EntityPlayer)event.getEntity();
            NBTTagCompound persistTag = this.getModIsPlayerNewTag(player);
            boolean bl = shouldGiveHousebuilder = !persistTag.func_74767_n(GIVEN_HOUSEBUILDER_TAG);
            if (shouldGiveHousebuilder) {
                if (CommonProxy.proxyConfiguration.addHouseItem) {
                    ItemStack stack = new ItemStack((Item)ModRegistry.StartHouse());
                    player.field_71071_by.func_70441_a(stack);
                    player.field_71069_bz.func_75142_b();
                    persistTag.func_74757_a(GIVEN_HOUSEBUILDER_TAG, true);
                }
            }
        }
    }

    @SubscribeEvent
    public void AttachItemStackCapabilities(AttachCapabilitiesEvent.Item event) {
        if (event.getItem() instanceof ItemBasicStructure) {
            event.addCapability(new ResourceLocation("prefab", "structuresconfiguration"), (ICapabilityProvider)new StructureConfigurationProvider(new StructureConfigurationCapability()));
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        ArrayList<EntityPlayer> playersToRemove = new ArrayList<EntityPlayer>();
        for (Map.Entry<EntityPlayer, ArrayList<Structure>> entry : structuresToBuild.entrySet()) {
            ArrayList<Structure> structuresToRemove = new ArrayList<Structure>();
            block1: for (Structure structure : entry.getValue()) {
                for (int i = 0; i < 100; ++i) {
                    if (structure.clearedBlockPos.size() > 0) {
                        BlockPos currentPos = structure.clearedBlockPos.get(0);
                        structure.clearedBlockPos.remove(0);
                        if (structure.world.func_175623_d(currentPos)) continue;
                        structure.world.func_175698_g(currentPos);
                        continue;
                    }
                    BuildBlock currentBlock = null;
                    if (structure.priorityOneBlocks.size() > 0) {
                        currentBlock = structure.priorityOneBlocks.get(0);
                        structure.priorityOneBlocks.remove(0);
                    } else if (structure.priorityTwoBlocks.size() > 0) {
                        currentBlock = structure.priorityTwoBlocks.get(0);
                        structure.priorityTwoBlocks.remove(0);
                    } else if (structure.priorityThreeBlocks.size() > 0) {
                        currentBlock = structure.priorityThreeBlocks.get(0);
                        structure.priorityThreeBlocks.remove(0);
                    } else {
                        structuresToRemove.add(structure);
                        continue block1;
                    }
                    IBlockState state = currentBlock.getBlockState();
                    BuildingMethods.ReplaceBlockNoAir(structure.world, currentBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.configuration.houseFacing), state);
                    if (currentBlock.getSubBlock() == null) continue;
                    BuildBlock subBlock = currentBlock.getSubBlock();
                    BuildingMethods.ReplaceBlockNoAir(structure.world, subBlock.getStartingPosition().getRelativePosition(structure.originalPos, structure.configuration.houseFacing), subBlock.getBlockState());
                }
            }
            for (Structure structure : structuresToRemove) {
                structure.AfterBuilding(structure.configuration, structure.world, structure.originalPos, structure.assumedNorth, entry.getKey());
                entry.getValue().remove(structure);
            }
            if (entry.getValue().size() != 0) continue;
            playersToRemove.add(entry.getKey());
        }
        for (EntityPlayer player : playersToRemove) {
            structuresToBuild.remove(player);
        }
    }

    @SubscribeEvent
    public void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = CommonProxy.proxyConfiguration.ToNBTTagCompound();
            Prefab.network.sendTo((IMessage)new ConfigSyncMessage(tag), (EntityPlayerMP)event.player);
            System.out.println("Sent config to '" + event.player.getDisplayNameString() + ".'");
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            ((ClientProxy)Prefab.proxy).serverConfiguration = null;
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        NBTTagCompound originalTag = event.getOriginal().getEntityData();
        if (CommonProxy.proxyConfiguration.addHouseItem && originalTag.func_74764_b("IsPlayerNew")) {
            NBTTagCompound newPlayerTag = event.getEntityPlayer().getEntityData();
            newPlayerTag.func_74782_a("IsPlayerNew", originalTag.func_74781_a("IsPlayerNew"));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent onConfigChangedEvent) {
        if (onConfigChangedEvent.getModID().equals("prefab")) {
            ModConfiguration.syncConfig();
        }
    }

    private NBTTagCompound getModIsPlayerNewTag(EntityPlayer player) {
        NBTTagCompound tag = player.getEntityData();
        NBTTagCompound newPlayerTag = null;
        if (tag.func_74764_b("IsPlayerNew")) {
            newPlayerTag = tag.func_74775_l("IsPlayerNew");
        } else {
            newPlayerTag = new NBTTagCompound();
            tag.func_74782_a("IsPlayerNew", (NBTBase)newPlayerTag);
        }
        return newPlayerTag;
    }

    static {
        RedstoneAffectedBlockPositions = new ArrayList();
    }
}

