/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Items;

import com.wuest.prefab.Capabilities.IStructureConfigurationCapability;
import com.wuest.prefab.Capabilities.Storage.StructureConfigurationStorage;
import com.wuest.prefab.Capabilities.StructureConfigurationCapability;
import com.wuest.prefab.Config.BasicStructureConfiguration;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.StructureGen.CustomStructures.StructureBasic;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBasicStructure
extends Item {
    public ItemBasicStructure(String name) {
        this.func_77637_a(CreativeTabs.field_78026_f);
        ModRegistry.setItemName(this, name);
        this.func_77627_a(true);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos hitBlockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IStructureConfigurationCapability capability;
        if (world.field_72995_K && side == EnumFacing.UP && (capability = (IStructureConfigurationCapability)stack.getCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH)) != null) {
            BasicStructureConfiguration structureConfiguration = capability.getConfiguration();
            player.openGui((Object)Prefab.instance, 13, player.field_70170_p, hitBlockPos.func_177958_n(), hitBlockPos.func_177956_o(), hitBlockPos.func_177952_p());
            return EnumActionResult.PASS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (BasicStructureConfiguration.EnumBasicStructureName value : BasicStructureConfiguration.EnumBasicStructureName.values()) {
            if (value.getResourceLocation() == null) continue;
            ItemStack stack = new ItemStack(itemIn);
            IStructureConfigurationCapability capability = (IStructureConfigurationCapability)stack.getCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH);
            capability.getConfiguration().basicStructureName = value;
            subItems.add(stack);
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer) {
            ItemBasicStructure.getStackCapability(stack);
        }
    }

    public String func_77667_c(ItemStack stack) {
        IStructureConfigurationCapability capability = ItemBasicStructure.getStackCapability(stack);
        if (capability != null) {
            return capability.getConfiguration().getDisplayName();
        }
        return this.func_77658_a();
    }

    public String func_77653_i(ItemStack stack) {
        return ("" + I18n.func_74838_a((String)this.func_77657_g(stack))).trim();
    }

    public static void BuildHouse(EntityPlayer player, World world, BasicStructureConfiguration configuration) {
        if (configuration != null) {
            Block hitBlock;
            BlockPos hitBlockPos = configuration.pos;
            BlockPos playerPosition = player.func_180425_c();
            IBlockState hitBlockState = world.func_180495_p(hitBlockPos);
            if (hitBlockState != null && (hitBlock = hitBlockState.func_177230_c()) != null) {
                StructureBasic structure;
                String assetLocation = "";
                if (!configuration.IsCustomStructure()) {
                    assetLocation = configuration.basicStructureName.getAssetLocation();
                }
                if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(configuration, world, hitBlockPos, EnumFacing.NORTH, player)) {
                    ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(player);
                    if (stack.field_77994_a == 1) {
                        player.field_71071_by.func_184437_d(stack);
                    } else {
                        --stack.field_77994_a;
                    }
                    player.field_71069_bz.func_75142_b();
                }
            }
        }
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return stack.serializeNBT();
        }
        return stack.func_77978_p();
    }

    public static ItemStack getBasicStructureItemInHand(EntityPlayer player) {
        Object stack = player.func_184592_cb();
        if (stack == null || !(stack.func_77973_b() instanceof ItemBasicStructure)) {
            stack = player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ItemBasicStructure ? player.func_184614_ca() : null;
        }
        return stack;
    }

    public static IStructureConfigurationCapability getStackCapability(ItemStack stack) {
        if (stack.hasCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH)) {
            NBTTagCompound forgeCapabilities = stack.func_179543_a("ForgeCaps", false);
            IStructureConfigurationCapability stackCapability = (IStructureConfigurationCapability)stack.getCapability(ModRegistry.StructureConfiguration, EnumFacing.NORTH);
            if (forgeCapabilities != null && stackCapability.getDirty() && forgeCapabilities.func_74764_b("prefab:structuresconfiguration")) {
                StructureConfigurationCapability capabilityTemp = new StructureConfigurationCapability();
                StructureConfigurationStorage storage = new StructureConfigurationStorage();
                storage.readNBT(ModRegistry.StructureConfiguration, capabilityTemp, EnumFacing.NORTH, (NBTBase)forgeCapabilities.func_74775_l("prefab:structuresconfiguration"));
                if (!capabilityTemp.getConfiguration().basicStructureName.getName().equals(stackCapability.getConfiguration().basicStructureName.getName())) {
                    stackCapability.setConfiguration(capabilityTemp.getConfiguration());
                    stackCapability.setDirty(false);
                }
            }
            return stackCapability;
        }
        return null;
    }
}

