/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.Items;

import com.wuest.prefab.BuildingMethods;
import com.wuest.prefab.Config.HouseConfiguration;
import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.Proxy.CommonProxy;
import com.wuest.prefab.StructureGen.CustomStructures.StructureAlternateStart;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemStartHouse
extends Item {
    protected static BlockPos NorthEastCorner;
    protected static BlockPos SouthEastCorner;
    protected static BlockPos SouthWestCorner;
    protected static BlockPos NorthWestCorner;
    private HouseConfiguration currentConfiguration = null;

    public ItemStartHouse(String name) {
        this.func_77637_a(CreativeTabs.field_78026_f);
        ModRegistry.setItemName(this, name);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos hitBlockPos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && side == EnumFacing.UP) {
            if (player.field_71093_bK == -1 || player.field_71093_bK == 1) {
                player.func_145747_a((ITextComponent)new TextComponentString("The Starter House cannot be placed in the nether or the end."));
                return EnumActionResult.FAIL;
            }
            player.openGui((Object)Prefab.instance, 6, player.field_70170_p, hitBlockPos.func_177958_n(), hitBlockPos.func_177956_o(), hitBlockPos.func_177952_p());
            return EnumActionResult.PASS;
        }
        return EnumActionResult.FAIL;
    }

    public static void BuildHouse(EntityPlayer player, World world, HouseConfiguration configuration) {
        if (configuration != null) {
            Block hitBlock;
            BlockPos hitBlockPos = configuration.pos;
            BlockPos playerPosition = player.func_180425_c();
            IBlockState hitBlockState = world.func_180495_p(hitBlockPos);
            if (hitBlockState != null && (hitBlock = hitBlockState.func_177230_c()) != null) {
                boolean houseBuilt = true;
                if (configuration.houseStyle == HouseConfiguration.HouseStyle.BASIC) {
                    BlockPos endBlockPos;
                    BlockPos startingPosition = hitBlockPos.func_177984_a();
                    EnumFacing northFace = configuration.houseFacing;
                    EnumFacing southFace = northFace.func_176734_d();
                    NorthEastCorner = startingPosition.func_177972_a(southFace).func_177972_a(northFace.func_176746_e());
                    SouthEastCorner = NorthEastCorner.func_177967_a(southFace, configuration.houseDepth + 1);
                    SouthWestCorner = SouthEastCorner.func_177967_a(northFace.func_176735_f(), configuration.houseWidth + 1);
                    NorthWestCorner = NorthEastCorner.func_177967_a(northFace.func_176735_f(), configuration.houseWidth + 1);
                    startingPosition = NorthEastCorner.func_177967_a(southFace, (int)Math.floor(configuration.houseDepth / 2) + 1).func_177967_a(northFace.func_176735_f(), (int)Math.floor(configuration.houseWidth / 2) + 1);
                    if (!BuildingMethods.CheckBuildSpaceForAllowedBlockReplacement(configuration, world, startingPosition, endBlockPos = startingPosition.func_177967_a(northFace.func_176735_f(), configuration.houseWidth + 11).func_177967_a(southFace, configuration.houseDepth + 11).func_177967_a(EnumFacing.UP, 15), player)) {
                        player.func_146105_b(new TextComponentTranslation("prefab.gui.structure.nobuild", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                        return;
                    }
                    BuildingMethods.ClearSpace(world, NorthEastCorner, configuration.houseWidth, 15, configuration.houseDepth, northFace);
                    ItemStartHouse.BuildStructure(world, startingPosition, configuration, northFace);
                    ItemStartHouse.BuildInterior(world, startingPosition, player, configuration, northFace);
                    ItemStartHouse.BuildExterior(world, startingPosition, player, configuration, northFace);
                    if (configuration.addMineShaft && startingPosition.func_177956_o() > 15) {
                        ItemStartHouse.PlaceMineShaft(world, startingPosition, configuration.houseDepth, northFace);
                    }
                } else {
                    StructureAlternateStart structure = (StructureAlternateStart)StructureAlternateStart.CreateInstance(configuration.houseStyle.getStructureLocation(), StructureAlternateStart.class);
                    houseBuilt = structure.BuildStructure(configuration, world, hitBlockPos, EnumFacing.NORTH, player);
                }
                if (houseBuilt) {
                    player.field_71071_by.func_174925_a((Item)ModRegistry.StartHouse(), -1, 1, null);
                    player.field_71069_bz.func_75142_b();
                }
            }
            player.getEntityData().func_82580_o(HouseConfiguration.tagKey);
        }
    }

    private static void BuildStructure(World world, BlockPos startingPosition, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos pos = NorthEastCorner;
        BuildingMethods.SetFloor(world, pos.func_177979_c(2), Blocks.field_150346_d, configuration.houseWidth + 2, configuration.houseDepth + 2, new ArrayList<ItemStack>(), facing.func_176734_d(), null);
        Block floor = null;
        switch (configuration.floorBlock) {
            case Brick: {
                floor = Blocks.field_150336_V;
                break;
            }
            case SandStone: {
                floor = Blocks.field_150322_A;
                break;
            }
            default: {
                floor = Blocks.field_150417_aV;
            }
        }
        BuildingMethods.SetFloor(world, pos.func_177977_b(), floor, configuration.houseWidth + 2, configuration.houseDepth + 2, new ArrayList<ItemStack>(), facing.func_176734_d(), null);
        ItemStartHouse.SetWalls(world, ((BlockPlanks)Blocks.field_150344_f).func_176203_a(configuration.wallWoodType.getValue()), configuration, facing);
        Block ceiling = null;
        Block stairs = null;
        switch (configuration.ceilingBlock) {
            case Brick: {
                ceiling = Blocks.field_150336_V;
                stairs = Blocks.field_150389_bf;
                break;
            }
            case SandStone: {
                ceiling = Blocks.field_150322_A;
                stairs = Blocks.field_150372_bz;
                break;
            }
            default: {
                ceiling = Blocks.field_150417_aV;
                stairs = Blocks.field_150390_bg;
            }
        }
        pos = pos.func_177981_b(4);
        BuildingMethods.SetCeiling(world, pos, ceiling, configuration.houseWidth + 2, configuration.houseDepth + 2, stairs, configuration, facing, null);
    }

    private static void BuildInterior(World world, BlockPos startingPosition, EntityPlayer player, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos northEastCornerPosition = NorthEastCorner.func_177984_a();
        BlockPos southEastCornerPosition = SouthEastCorner.func_177984_a();
        BlockPos northWestCornerPosition = NorthWestCorner.func_177984_a();
        BlockPos southWestCornerPosition = SouthWestCorner.func_177984_a();
        BlockPos itemPosition = northEastCornerPosition;
        if (configuration.addTorches) {
            ItemStartHouse.PlaceInsideTorches(world, configuration, facing);
        }
        ItemStartHouse.DecorateDoor(world, northEastCornerPosition, player, configuration, facing);
        if (configuration.addBed) {
            ItemStartHouse.PlaceBed(world, northWestCornerPosition, facing);
        }
        if (configuration.addCraftingTable) {
            if (!CommonProxy.proxyConfiguration.enableHouseGenerationRestrictions) {
                ItemStartHouse.PlaceAndFillCraftingMachines(player, world, southWestCornerPosition, facing);
            }
        }
        if (configuration.addChest) {
            if (!CommonProxy.proxyConfiguration.enableHouseGenerationRestrictions) {
                ItemStartHouse.PlaceAndFillChest(player, world, southEastCornerPosition, configuration, facing);
            }
        }
    }

    private static void BuildExterior(World world, BlockPos startingPosition, EntityPlayer player, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos northEastCornerPosition = NorthEastCorner.func_177984_a();
        BlockPos southEastCornerPosition = SouthEastCorner.func_177984_a();
        BlockPos northWestCornerPosition = NorthWestCorner.func_177984_a();
        BlockPos southWestCornerPosition = SouthWestCorner.func_177984_a();
        if (configuration.addTorches) {
            ItemStartHouse.PlaceOutsideTorches(world, northEastCornerPosition, configuration, facing);
        }
        if (configuration.addFarm) {
            ItemStartHouse.PlaceSmallFarm(world, northEastCornerPosition.func_177977_b(), facing);
        }
    }

    private static void SetWalls(World world, IBlockState block, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos pos = NorthEastCorner;
        facing = facing.func_176734_d();
        BuildingMethods.CreateWall(world, 4, configuration.houseDepth + 1, facing, pos, block);
        facing = facing.func_176746_e();
        pos = SouthEastCorner;
        BuildingMethods.CreateWall(world, 4, configuration.houseWidth + 2, facing, pos, block);
        facing = facing.func_176746_e();
        pos = SouthWestCorner;
        BuildingMethods.CreateWall(world, 4, configuration.houseDepth + 2, facing, pos, block);
        facing = facing.func_176746_e();
        pos = NorthWestCorner;
        BuildingMethods.CreateWall(world, 4, configuration.houseWidth + 2, facing, pos, block);
    }

    private static void PlaceInsideTorches(World world, HouseConfiguration configuration, EnumFacing facing) {
        int blocksMoved;
        BlockPos itemPosition = null;
        int torchWidthOffset = configuration.houseWidth < 9 ? 2 : 4;
        int torchDepthOffset = configuration.houseDepth < 9 ? 2 : 4;
        itemPosition = NorthEastCorner.func_177967_a(facing.func_176735_f(), torchWidthOffset).func_177972_a(facing.func_176734_d()).func_177984_a();
        IBlockState blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176734_d());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchWidthOffset; blocksMoved < configuration.houseWidth; blocksMoved += torchWidthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchWidthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthEastCorner.func_177967_a(facing.func_176734_d(), torchDepthOffset).func_177972_a(facing.func_176735_f()).func_177984_a();
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176735_f());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved < configuration.houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing.func_176746_e()))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthWestCorner.func_177967_a(facing.func_176734_d(), torchDepthOffset).func_177972_a(facing.func_176746_e()).func_177984_a();
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved < configuration.houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing.func_176735_f()))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = SouthEastCorner.func_177967_a(facing.func_176735_f(), torchWidthOffset).func_177972_a(facing).func_177984_a();
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved < configuration.houseWidth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchDepthOffset)) || world.func_175623_d(itemPosition.func_177972_a(facing.func_176734_d()))) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
    }

    private static void DecorateDoor(World world, BlockPos cornerPosition, EntityPlayer player, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos itemPosition = cornerPosition.func_177972_a(facing.func_176735_f());
        world.func_175698_g(itemPosition);
        BlockDoor door = null;
        Block stairs = null;
        switch (configuration.wallWoodType) {
            case Spruce: {
                door = Blocks.field_180414_ap;
                stairs = Blocks.field_150485_bF;
                break;
            }
            case Birch: {
                door = Blocks.field_180412_aq;
                stairs = Blocks.field_150487_bG;
                break;
            }
            case Jungle: {
                door = Blocks.field_180411_ar;
                stairs = Blocks.field_150481_bH;
                break;
            }
            case Acacia: {
                door = Blocks.field_180410_as;
                stairs = Blocks.field_150400_ck;
                break;
            }
            case DarkOak: {
                door = Blocks.field_180409_at;
                stairs = Blocks.field_150401_cl;
                break;
            }
            default: {
                door = Blocks.field_180413_ao;
                stairs = Blocks.field_150476_ad;
            }
        }
        ItemDoor.func_179235_a((World)world, (BlockPos)itemPosition.func_177977_b(), (EnumFacing)facing, (Block)door, (boolean)true);
        BuildingMethods.ReplaceBlock(world, itemPosition.func_177984_a(), Blocks.field_150410_aZ);
        itemPosition = itemPosition.func_177972_a(facing.func_176734_d()).func_177977_b();
        BuildingMethods.ReplaceBlock(world, itemPosition, Blocks.field_150452_aw);
        itemPosition = itemPosition.func_177967_a(facing, 2).func_177972_a(facing.func_176735_f());
        BlockSign sign = (BlockSign)Blocks.field_150472_an;
        int signMeta = 8;
        switch (facing) {
            case EAST: {
                signMeta = 12;
                break;
            }
            case SOUTH: {
                signMeta = 0;
                break;
            }
            case WEST: {
                signMeta = 4;
                break;
            }
        }
        BuildingMethods.ReplaceBlock(world, itemPosition.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, itemPosition, sign.func_176203_a(signMeta));
        TileEntity tileEntity = world.func_175625_s(itemPosition);
        if (tileEntity instanceof TileEntitySign) {
            TileEntitySign signTile = (TileEntitySign)tileEntity;
            signTile.field_145915_a[0] = new TextComponentString("This is");
            signTile.field_145915_a[1] = player.getDisplayNameString().length() >= 15 ? new TextComponentString(player.getDisplayNameString()) : new TextComponentString(player.getDisplayNameString() + "'s");
            signTile.field_145915_a[2] = new TextComponentString("house!");
        }
    }

    private static void PlaceBed(World world, BlockPos cornerPosition, EnumFacing facing) {
        IBlockState bedFootState;
        BlockPos itemPosition = cornerPosition.func_177967_a(facing.func_176746_e(), 1).func_177967_a(facing.func_176734_d(), 2).func_177977_b();
        if (world.func_180501_a(itemPosition, bedFootState = Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)facing).func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT), 3)) {
            IBlockState bedHeadState = bedFootState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
            world.func_180501_a(itemPosition.func_177972_a(facing), bedHeadState, 3);
        }
    }

    private static void PlaceAndFillChest(EntityPlayer player, World world, BlockPos cornerPosition, HouseConfiguration configuration, EnumFacing facing) {
        BlockPos itemPosition = cornerPosition.func_177972_a(facing).func_177972_a(facing.func_176735_f()).func_177977_b();
        IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing);
        BuildingMethods.ReplaceBlock(world, itemPosition, chestState);
        itemPosition = itemPosition.func_177972_a(facing.func_176735_f());
        BuildingMethods.ReplaceBlock(world, itemPosition, chestState);
        if (configuration.addChestContents) {
            StructureAlternateStart.FillChest(world, itemPosition, configuration, player);
        }
    }

    private static void PlaceAndFillCraftingMachines(EntityPlayer player, World world, BlockPos cornerPosition, EnumFacing facing) {
        BlockPos itemPosition = cornerPosition.func_177972_a(facing.func_176746_e()).func_177972_a(facing).func_177977_b();
        BuildingMethods.ReplaceBlock(world, itemPosition, Blocks.field_150462_ai);
        player.func_71029_a((StatBase)AchievementList.field_187984_h);
        itemPosition = itemPosition.func_177972_a(facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, itemPosition, Blocks.field_150460_al.func_176223_P().func_177226_a((IProperty)BlockFurnace.field_176447_a, (Comparable)facing));
        TileEntity tileEntity = world.func_175625_s(itemPosition);
        if (tileEntity instanceof TileEntityFurnace) {
            TileEntityFurnace furnaceTile = (TileEntityFurnace)tileEntity;
            furnaceTile.func_70299_a(1, new ItemStack(Items.field_151044_h, 20));
        }
    }

    private static void PlaceOutsideTorches(World world, BlockPos cornerPosition, HouseConfiguration configuration, EnumFacing facing) {
        int blocksMoved;
        BlockPos itemPosition = NorthEastCorner.func_177972_a(facing);
        int houseDepth = configuration.houseDepth + 2;
        int houseWidth = configuration.houseWidth + 2;
        int torchWidthOffset = configuration.houseWidth < 9 ? 3 : 4;
        int torchDepthOffset = configuration.houseDepth < 9 ? 3 : 4;
        IBlockState blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing);
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchWidthOffset; blocksMoved <= houseWidth; blocksMoved += torchWidthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchWidthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing.func_176734_d()), facing)) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthEastCorner.func_177972_a(facing.func_176746_e());
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved <= houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing.func_176735_f()), facing.func_176746_e())) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = NorthWestCorner.func_177972_a(facing.func_176735_f());
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176735_f());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved <= houseDepth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176734_d(), torchDepthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing.func_176746_e()), facing.func_176735_f())) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        itemPosition = SouthEastCorner.func_177972_a(facing.func_176734_d());
        blockState = Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)facing.func_176734_d());
        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        for (blocksMoved = torchDepthOffset; blocksMoved <= houseWidth; blocksMoved += torchDepthOffset) {
            if (!world.func_175623_d(itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchDepthOffset)) || !world.isSideSolid(itemPosition.func_177972_a(facing), facing.func_176734_d())) continue;
            BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
        }
        if (configuration.isCeilingFlat) {
            cornerPosition = cornerPosition.func_177981_b(4);
            blockState = Blocks.field_150478_aa.func_176203_a(BuildingMethods.GetTorchFacing(EnumFacing.UP));
            for (int i = 0; i <= houseDepth; i += torchDepthOffset) {
                itemPosition = cornerPosition.func_177967_a(facing.func_176734_d(), i);
                for (int j = 0; j <= houseWidth; j += torchWidthOffset) {
                    if (world.func_175623_d(itemPosition) && !world.func_175623_d(itemPosition.func_177977_b())) {
                        BuildingMethods.ReplaceBlock(world, itemPosition, blockState);
                    }
                    itemPosition = itemPosition.func_177967_a(facing.func_176735_f(), torchWidthOffset);
                }
            }
        }
    }

    private static void PlaceSmallFarm(World world, BlockPos cornerPosition, EnumFacing facing) {
        BlockPos farmStart = cornerPosition.func_177967_a(facing, 4).func_177967_a(facing.func_176735_f(), 5);
        IBlockState state = world.func_180495_p(farmStart);
        farmStart = farmStart.func_177977_b();
        BuildingMethods.ReplaceBlock(world, farmStart, (Block)Blocks.field_150355_j);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177984_a(), Blocks.field_150359_w);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177981_b(2), Blocks.field_150478_aa);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing).func_177972_a(facing.func_176735_f()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176735_f()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176735_f()), Blocks.field_150458_ak);
        farmStart = farmStart.func_177972_a(facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, farmStart, (Block)Blocks.field_150355_j);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177984_a(), Blocks.field_150359_w);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177981_b(2), Blocks.field_150478_aa);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()), Blocks.field_150458_ak);
        farmStart = farmStart.func_177972_a(facing.func_176746_e());
        BuildingMethods.ReplaceBlock(world, farmStart, (Block)Blocks.field_150355_j);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177977_b(), Blocks.field_150346_d);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177984_a(), Blocks.field_150359_w);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177981_b(2), Blocks.field_150478_aa);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing).func_177972_a(facing.func_176746_e()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176746_e()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()), Blocks.field_150458_ak);
        BuildingMethods.ReplaceBlock(world, farmStart.func_177972_a(facing.func_176734_d()).func_177972_a(facing.func_176746_e()), Blocks.field_150458_ak);
    }

    private static void PlaceMineShaft(World world, BlockPos pos, int houseDepth, EnumFacing facing) {
        houseDepth = (houseDepth & 1) != 0 ? (int)Math.floor(houseDepth / 2) : (int)Math.floor(houseDepth / 2) - 1;
        pos = pos.func_177967_a(facing.func_176734_d(), houseDepth).func_177977_b();
        StructureAlternateStart.PlaceMineShaft(world, pos, facing, false);
    }
}

