/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.StructureGen.CustomStructures;

import com.wuest.prefab.Config.BasicStructureConfiguration;
import com.wuest.prefab.Config.StructureConfiguration;
import com.wuest.prefab.StructureGen.BuildBlock;
import com.wuest.prefab.StructureGen.BuildClear;
import com.wuest.prefab.StructureGen.BuildShape;
import com.wuest.prefab.StructureGen.CustomStructures.StructureAlternateStart;
import com.wuest.prefab.StructureGen.PositionOffset;
import com.wuest.prefab.StructureGen.Structure;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureBasic
extends Structure {
    BlockPos customBlockPos = null;

    public static void ScanStructure(World world, BlockPos originalPos, EnumFacing playerFacing, BasicStructureConfiguration configuration) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.setShape(configuration.basicStructureName.getClearShape());
        clearedSpace.setStartingPosition(configuration.basicStructureName.getClearPositionOffset());
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        if (!configuration.IsCustomStructure()) {
            BuildShape buildShape = configuration.basicStructureName.getClearShape();
            PositionOffset offset = configuration.basicStructureName.getClearPositionOffset();
            int downOffset = offset.getHeightOffset() < 0 ? offset.getHeightOffset() : 0;
            BlockPos cornerPos = originalPos.func_177965_g(offset.getEastOffset()).func_177970_e(offset.getSouthOffset()).func_177979_c(downOffset);
            Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.func_177970_e(buildShape.getLength()).func_177985_f(buildShape.getWidth()).func_177981_b(buildShape.getHeight()), ".\\src\\main\\resources\\assets\\prefab\\structures\\" + configuration.basicStructureName.getName() + ".zip", clearedSpace, playerFacing);
        }
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (foundBlock instanceof BlockHopper && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdavancedCoop.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, configuration.houseFacing);
        } else if (foundBlock instanceof BlockTrapDoor && config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
            this.customBlockPos = block.getStartingPosition().getRelativePosition(originalPos, configuration.houseFacing);
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        BasicStructureConfiguration config = (BasicStructureConfiguration)configuration;
        if (this.customBlockPos != null) {
            if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.AdavancedCoop.getName())) {
                for (int i = 0; i < 4; ++i) {
                    EntityChicken entity = new EntityChicken(world);
                    entity.func_70107_b((double)this.customBlockPos.func_177958_n(), (double)this.customBlockPos.func_177984_a().func_177956_o(), (double)this.customBlockPos.func_177952_p());
                    world.func_72838_d((Entity)entity);
                }
            } else if (config.basicStructureName.getName().equals(BasicStructureConfiguration.EnumBasicStructureName.MineshaftEntrance.getName())) {
                StructureAlternateStart.PlaceMineShaft(world, this.customBlockPos.func_177977_b(), configuration.houseFacing, true);
            }
            this.customBlockPos = null;
        }
    }
}

