/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client;

import com.st0x0ef.stellaris.Stellaris;
import com.st0x0ef.stellaris.client.overlays.JetSuitOverlay;
import com.st0x0ef.stellaris.client.overlays.LanderOverlay;
import com.st0x0ef.stellaris.client.overlays.RocketBarOverlay;
import com.st0x0ef.stellaris.client.overlays.RocketStartOverlay;
import com.st0x0ef.stellaris.client.particles.LargeFlameParticle;
import com.st0x0ef.stellaris.client.particles.LargeSmokeParticle;
import com.st0x0ef.stellaris.client.particles.SmallFlameParticle;
import com.st0x0ef.stellaris.client.particles.SmallSmokeParticle;
import com.st0x0ef.stellaris.client.particles.VenusRainParticle;
import com.st0x0ef.stellaris.client.registries.KeyMappingsRegistry;
import com.st0x0ef.stellaris.client.renderers.armors.JetSuitModel;
import com.st0x0ef.stellaris.client.renderers.entities.alien.AlienModel;
import com.st0x0ef.stellaris.client.renderers.entities.alien.AlienRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.alienzombie.AlienZombieModel;
import com.st0x0ef.stellaris.client.renderers.entities.alienzombie.AlienZombieRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.cheeseboss.CheeseBossModel;
import com.st0x0ef.stellaris.client.renderers.entities.cheeseboss.CheeseBossRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.martianraptor.MartianRaptorModel;
import com.st0x0ef.stellaris.client.renderers.entities.martianraptor.MartianRaptorRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.mogler.MoglerModel;
import com.st0x0ef.stellaris.client.renderers.entities.mogler.MoglerRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.projectiles.IceShardArrowRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.pygro.PygroBruteRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.pygro.PygroModel;
import com.st0x0ef.stellaris.client.renderers.entities.pygro.PygroRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.starcrawler.StarCrawlerModel;
import com.st0x0ef.stellaris.client.renderers.entities.starcrawler.StarCrawlerRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.lander.LanderModel;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.lander.LanderRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.big.BigRocketModel;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.big.BigRocketRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.normal.NormalRocketModel;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.normal.NormalRocketRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.small.SmallRocketModel;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.small.SmallRocketRenderer;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.tiny.TinyRocketModel;
import com.st0x0ef.stellaris.client.renderers.entities.vehicle.rocket.tiny.TinyRocketRenderer;
import com.st0x0ef.stellaris.client.renderers.globe.GlobeBlockRenderer;
import com.st0x0ef.stellaris.client.renderers.globe.GlobeModel;
import com.st0x0ef.stellaris.client.screens.CoalGeneratorScreen;
import com.st0x0ef.stellaris.client.screens.ConfigScreen;
import com.st0x0ef.stellaris.client.screens.FuelRefineryScreen;
import com.st0x0ef.stellaris.client.screens.LanderScreen;
import com.st0x0ef.stellaris.client.screens.MilkyWayScreen;
import com.st0x0ef.stellaris.client.screens.OxygenDistributorScreen;
import com.st0x0ef.stellaris.client.screens.PlanetSelectionScreen;
import com.st0x0ef.stellaris.client.screens.RadioactiveGeneratorScreen;
import com.st0x0ef.stellaris.client.screens.RocketScreen;
import com.st0x0ef.stellaris.client.screens.RocketStationScreen;
import com.st0x0ef.stellaris.client.screens.SolarPanelScreen;
import com.st0x0ef.stellaris.client.screens.VacumatorScreen;
import com.st0x0ef.stellaris.client.screens.WaterSeparatorScreen;
import com.st0x0ef.stellaris.client.skys.record.SkyPropertiesData;
import com.st0x0ef.stellaris.common.data.screen.MoonPack;
import com.st0x0ef.stellaris.common.data.screen.PlanetPack;
import com.st0x0ef.stellaris.common.data.screen.StarPack;
import com.st0x0ef.stellaris.common.handlers.GlobalExceptionHandler;
import com.st0x0ef.stellaris.common.registry.BlockEntityRegistry;
import com.st0x0ef.stellaris.common.registry.EntityRegistry;
import com.st0x0ef.stellaris.common.registry.ItemsRegistry;
import com.st0x0ef.stellaris.common.registry.MenuTypesRegistry;
import com.st0x0ef.stellaris.common.registry.ParticleRegistry;
import com.st0x0ef.stellaris.platform.ClientUtilsPlatform;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.menu.MenuRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLDebugMessageCallback;

@OnlyIn(value=Dist.CLIENT)
public class StellarisClient {
    public static void initClient() {
        StellarisClient.registerPacks();
        Minecraft.getInstance().execute(() -> {
            StellarisClient.setupOpenGLDebugMessageCallback();
            Thread.setDefaultUncaughtExceptionHandler(new GlobalExceptionHandler());
        });
        KeyMappingsRegistry.register();
        StellarisClient.registerParticle();
        StellarisClient.registerScreen();
        StellarisClient.registerOverlays();
        StellarisClient.registerJetSuitModel();
        Platform.getMod((String)"stellaris").registerConfigurationScreen(ConfigScreen::new);
    }

    private static void registerJetSuitModel() {
        ClientUtilsPlatform.registerArmor(JetSuitModel.TEXTURE, JetSuitModel.LAYER_LOCATION, JetSuitModel::new, (Item)ItemsRegistry.JETSUIT_BOOTS.get(), (Item)ItemsRegistry.JETSUIT_LEGGINGS.get(), (Item)ItemsRegistry.JETSUIT_HELMET.get(), (Item)ItemsRegistry.JETSUIT_SUIT.get());
    }

    public static void registerEntityModelLayer() {
        EntityModelLayerRegistry.register((ModelLayerLocation)AlienModel.LAYER_LOCATION, AlienModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)AlienZombieModel.LAYER_LOCATION, AlienZombieModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)MartianRaptorModel.LAYER_LOCATION, MartianRaptorModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)PygroModel.LAYER_LOCATION, PygroModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)MoglerModel.LAYER_LOCATION, MoglerModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)StarCrawlerModel.LAYER_LOCATION, StarCrawlerModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)CheeseBossModel.LAYER_LOCATION, CheeseBossModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)GlobeModel.LAYER_LOCATION, GlobeModel::createLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)LanderModel.LAYER_LOCATION, LanderModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)TinyRocketModel.LAYER_LOCATION, TinyRocketModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)SmallRocketModel.LAYER_LOCATION, SmallRocketModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)NormalRocketModel.LAYER_LOCATION, NormalRocketModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)BigRocketModel.LAYER_LOCATION, BigRocketModel::createBodyLayer);
        EntityModelLayerRegistry.register((ModelLayerLocation)JetSuitModel.LAYER_LOCATION, JetSuitModel::createBodyLayer);
    }

    public static void registerEntityRenderer() {
        EntityRendererRegistry.register(EntityRegistry.ALIEN, AlienRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.ALIEN_ZOMBIE, AlienZombieRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.MARTIAN_RAPTOR, MartianRaptorRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.PYGRO, PygroRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.PYGRO_BRUTE, PygroBruteRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.MOGLER, MoglerRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.STAR_CRAWLER, StarCrawlerRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.CHEESE_BOSS, CheeseBossRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.ICE_SPIT, renderManager -> new ThrownItemRenderer(renderManager, 1.0f, true));
        EntityRendererRegistry.register(EntityRegistry.ICE_SHARD_ARROW, IceShardArrowRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.NORMAL_ROCKET, NormalRocketRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.TINY_ROCKET, TinyRocketRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.SMALL_ROCKET, SmallRocketRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.BIG_ROCKET, BigRocketRenderer::new);
        EntityRendererRegistry.register(EntityRegistry.LANDER, LanderRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)BlockEntityRegistry.GLOBE_BLOCK_ENTITY.get()), GlobeBlockRenderer::new);
    }

    public static void registerParticle() {
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.VENUS_RAIN_PARTICLE.get()), VenusRainParticle.ParticleFactory::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.LARGE_FLAME_PARTICLE.get()), LargeFlameParticle.ParticleFactory::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.LARGE_SMOKE_PARTICLE.get()), LargeSmokeParticle.ParticleFactory::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.SMALL_FLAME_PARTICLE.get()), SmallFlameParticle.ParticleFactory::new);
        ParticleProviderRegistry.register((ParticleType)((ParticleType)ParticleRegistry.SMALL_SMOKE_PARTICLE.get()), SmallSmokeParticle.ParticleFactory::new);
    }

    public static void registerScreen() {
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.ROCKET_STATION.get()), RocketStationScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.ROCKET_MENU.get()), RocketScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.VACUMATOR_MENU.get()), VacumatorScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.SOLAR_PANEL_MENU.get()), SolarPanelScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.COAL_GENERATOR_MENU.get()), CoalGeneratorScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.RADIOACTIVE_GENERATOR_MENU.get()), RadioactiveGeneratorScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.PLANET_SELECTION_MENU.get()), PlanetSelectionScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.MILKYWAY_MENU.get()), MilkyWayScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.LANDER_MENU.get()), LanderScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.OXYGEN_DISTRIBUTOR.get()), OxygenDistributorScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.WATER_SEPARATOR_MENU.get()), WaterSeparatorScreen::new);
        MenuRegistry.registerScreenFactory((MenuType)((MenuType)MenuTypesRegistry.FUEL_REFINERY.get()), FuelRefineryScreen::new);
    }

    public static void registerOverlays() {
        ClientGuiEvent.RENDER_HUD.register(RocketStartOverlay::render);
        ClientGuiEvent.RENDER_HUD.register(RocketBarOverlay::render);
        ClientGuiEvent.RENDER_HUD.register(LanderOverlay::render);
        ClientGuiEvent.RENDER_HUD.register(JetSuitOverlay::render);
    }

    public static void setupOpenGLDebugMessageCallback() {
        if (GL.getCapabilities().GL_KHR_debug) {
            GL43.glDebugMessageCallback((source, type, id, severity, length, message, userParam) -> {
                if (id == 1281) {
                    return;
                }
                String errorMessage = GLDebugMessageCallback.getMessage((int)length, (long)message);
                Stellaris.LOG.error("OpenGL debug message: id={}, source={}, type={}, severity={}, message='{}'", new Object[]{id, source, type, severity, errorMessage});
            }, (long)0L);
            GL43.glEnable((int)37600);
            GL43.glEnable((int)33346);
        }
    }

    public static void registerPacks() {
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new StarPack());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new PlanetPack());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new MoonPack());
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (PreparableReloadListener)new SkyPropertiesData());
    }
}

