/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.overlays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.st0x0ef.stellaris.client.screens.helper.ScreenHelper;
import com.st0x0ef.stellaris.common.entities.RocketEntity;
import com.st0x0ef.stellaris.common.utils.PlanetUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;

public class RocketBarOverlay {
    public static final ResourceLocation ROCKET = new ResourceLocation("stellaris", "textures/planet_bar/rocket.png");

    public static void render(GuiGraphics graphics, float tickDelta) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player.getVehicle() instanceof RocketEntity) {
            ClientLevel level = Minecraft.getInstance().level;
            float yHeight = (float)player.getY() / 5.3f;
            if (yHeight < 0.0f) {
                yHeight = 0.0f;
            } else if (yHeight > 113.0f) {
                yHeight = 113.0f;
            }
            ResourceLocation planet = PlanetUtil.getPlanetBar(level.dimension().location());
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)planet);
            graphics.blit(planet, 0, graphics.guiHeight() / 2 - 64, 0.0f, 0.0f, 16, 128, 16, 128);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)ROCKET);
            ScreenHelper.renderWithFloat.blit(graphics.pose(), 4.0f, (float)graphics.guiHeight() / 2.0f + 51.5f - yHeight, 0.0f, 0.0f, 8.0f, 11.0f, 8.0f, 11.0f);
        }
    }
}

