/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.alien;

import com.st0x0ef.stellaris.client.renderers.entities.alien.AlienModel;
import com.st0x0ef.stellaris.common.entities.alien.Alien;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AlienRenderer
extends MobRenderer<Alien, AlienModel<Alien>> {
    public static final ResourceLocation ALIEN = new ResourceLocation("stellaris", "textures/entity/alien/alien.png");
    public static final ResourceLocation FARMER = new ResourceLocation("stellaris", "textures/entity/alien/farmer.png");
    public static final ResourceLocation FISHERMAN = new ResourceLocation("stellaris", "textures/entity/alien/fisherman.png");
    public static final ResourceLocation SHEPHERD = new ResourceLocation("stellaris", "textures/entity/alien/shepherd.png");
    public static final ResourceLocation FLETCHER = new ResourceLocation("stellaris", "textures/entity/alien/fletcher.png");
    public static final ResourceLocation LIBRARIAN = new ResourceLocation("stellaris", "textures/entity/alien/librarian.png");
    public static final ResourceLocation CARTOGRAPHER = new ResourceLocation("stellaris", "textures/entity/alien/cartographer.png");
    public static final ResourceLocation CLERIC = new ResourceLocation("stellaris", "textures/entity/alien/cleric.png");
    public static final ResourceLocation ARMORER = new ResourceLocation("stellaris", "textures/entity/alien/armorer.png");
    public static final ResourceLocation WEAPON_SMITH = new ResourceLocation("stellaris", "textures/entity/alien/weapon_smith.png");
    public static final ResourceLocation TOOL_SMITH = new ResourceLocation("stellaris", "textures/entity/alien/tool_smith.png");
    public static final ResourceLocation BUTCHER = new ResourceLocation("stellaris", "textures/entity/alien/butcher.png");
    public static final ResourceLocation LEATHER_WORKER = new ResourceLocation("stellaris", "textures/entity/alien/leather_worker.png");
    public static final ResourceLocation MASON = new ResourceLocation("stellaris", "textures/entity/alien/mason.png");

    public AlienRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, new AlienModel(renderManagerIn.bakeLayer(AlienModel.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(Alien entity) {
        if (entity.getVillagerData().getProfession() == VillagerProfession.FARMER) {
            return FARMER;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.FISHERMAN) {
            return FISHERMAN;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.SHEPHERD) {
            return SHEPHERD;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.FLETCHER) {
            return FLETCHER;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.LIBRARIAN) {
            return LIBRARIAN;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.CARTOGRAPHER) {
            return CARTOGRAPHER;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.CLERIC) {
            return CLERIC;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.ARMORER) {
            return ARMORER;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.WEAPONSMITH) {
            return WEAPON_SMITH;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.TOOLSMITH) {
            return TOOL_SMITH;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.BUTCHER) {
            return BUTCHER;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.LEATHERWORKER) {
            return LEATHER_WORKER;
        }
        if (entity.getVillagerData().getProfession() == VillagerProfession.MASON) {
            return MASON;
        }
        return ALIEN;
    }

    public boolean shouldRender(Alien livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return livingEntity != null && camera.isVisible(livingEntity.getBoundingBoxForCulling());
    }
}

