/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.alienzombie;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.st0x0ef.stellaris.common.entities.AlienZombie;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AlienZombieModel<T extends AlienZombie>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stellaris", "alien_zombie"), "main");
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leg0;
    private final ModelPart leg1;
    private final ModelPart arm1;
    private final ModelPart arm2;
    private final ModelPart monsterarm1;
    private final ModelPart monsterarm2;
    private final ModelPart monsterarm3;
    private final ModelPart monsterarm4;

    public AlienZombieModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leg0 = root.getChild("leg0");
        this.leg1 = root.getChild("leg1");
        this.arm1 = root.getChild("arm1");
        this.arm2 = root.getChild("arm2");
        this.monsterarm1 = root.getChild("monsterarm1");
        this.monsterarm2 = root.getChild("monsterarm2");
        this.monsterarm3 = root.getChild("monsterarm3");
        this.monsterarm4 = root.getChild("monsterarm4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)-6.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = head.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(88, 59).mirror().addBox(-0.5095f, -2.211f, -0.6496f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)2.25f, (float)4.1027f, (float)-5.534f, (float)1.0036f, (float)0.48f, (float)-0.8727f));
        PartDefinition cube_r2 = head.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(88, 59).addBox(-1.7975f, -1.8508f, -0.9483f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.75f, (float)4.1027f, (float)-5.534f, (float)1.0036f, (float)-0.48f, (float)0.8727f));
        PartDefinition cube_r3 = head.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(88, 54).addBox(-1.5f, -1.75f, -0.75f, 3.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.8527f, (float)-7.434f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition head_r1 = head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(33, 0).mirror().addBox(-4.5f, -3.9804f, -4.3483f, 9.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-14.0f, (float)1.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition head_r2 = head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(40, 53).mirror().addBox(-3.0f, 2.8551f, 0.3492f, 7.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-0.5f, (float)-5.0f, (float)0.0f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-3.1927f, (float)0.7599f));
        PartDefinition nose_r1 = nose.addOrReplaceChild("nose_r1", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-1.0f, -0.5896f, 1.4131f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-6.0f, (float)-1.0036f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).mirror().addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 38).mirror().addBox(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-3.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition leg0 = partdefinition.addOrReplaceChild("leg0", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition leg1 = partdefinition.addOrReplaceChild("leg1", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition arm1 = partdefinition.addOrReplaceChild("arm1", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(-8.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)-1.5f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition arm2 = partdefinition.addOrReplaceChild("arm2", CubeListBuilder.create().texOffs(44, 22).mirror().addBox(4.0f, -2.0f, -5.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)7.0f, (float)-1.5f));
        PartDefinition monsterarm1 = partdefinition.addOrReplaceChild("monsterarm1", CubeListBuilder.create().texOffs(30, 46).addBox(-17.0f, -1.0f, -1.0f, 17.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-4.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.9599f));
        PartDefinition cube_r4 = monsterarm1.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(34, 46).addBox(-15.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-16.25f, (float)0.0f, (float)0.75f, (float)0.0f, (float)-1.1345f, (float)0.0f));
        PartDefinition monsterarm2 = partdefinition.addOrReplaceChild("monsterarm2", CubeListBuilder.create().texOffs(30, 46).addBox(-17.0f, -1.0f, -1.0f, 17.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-3.0f, (float)-0.25f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition cube_r5 = monsterarm2.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(34, 46).addBox(-15.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-16.25f, (float)0.0f, (float)0.75f, (float)0.0f, (float)-1.1345f, (float)0.0f));
        PartDefinition monsterarm3 = partdefinition.addOrReplaceChild("monsterarm3", CubeListBuilder.create().texOffs(30, 46).addBox(-17.0f, -1.0f, -1.0f, 17.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)2.1817f));
        PartDefinition cube_r6 = monsterarm3.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(34, 46).addBox(-15.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-16.25f, (float)0.0f, (float)0.75f, (float)0.0f, (float)-1.1345f, (float)0.0f));
        PartDefinition monsterarm4 = partdefinition.addOrReplaceChild("monsterarm4", CubeListBuilder.create().texOffs(30, 46).addBox(-17.0f, -1.0f, -1.0f, 17.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-0.25f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-2.7489f));
        PartDefinition cube_r7 = monsterarm4.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(30, 46).addBox(-15.0f, -1.0f, -1.0f, 15.0f, 2.0f, 2.0f, new CubeDeformation(-0.1f)), PartPose.offsetAndRotation((float)-16.25f, (float)0.0f, (float)0.75f, (float)0.0f, (float)-1.1345f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)96, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.head.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.body.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg0.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.leg1.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.arm1.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.arm2.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.monsterarm1.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.monsterarm2.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.monsterarm3.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.monsterarm4.render(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float f, float f1, float f2, float f3, float f4) {
        this.arm2.yRot = 0.0f;
        this.arm1.yRot = 0.0f;
        this.arm2.zRot = 0.0f;
        this.arm1.zRot = 0.0f;
        this.arm2.xRot = 0.0f;
        this.arm1.xRot = 0.0f;
        this.arm2.zRot -= Mth.cos((float)(f2 * 0.04f)) * 0.04f + 0.04f;
        this.arm1.zRot += Mth.cos((float)(f2 * 0.04f)) * 0.04f + 0.04f;
        this.head.yRot = f3 / 57.295776f;
        this.head.xRot = f4 / 57.295776f;
        this.leg0.xRot = Mth.cos((float)f) * -1.0f * f1;
        this.leg1.xRot = Mth.cos((float)f) * 1.0f * f1;
        this.monsterarm1.yRot = Mth.cos((float)(f * 0.3662f + (float)Math.PI)) * f1 / 2.0f;
        this.monsterarm4.yRot = Mth.cos((float)(f * 0.3662f + (float)Math.PI)) * f1 / 2.0f;
        this.monsterarm3.yRot = Mth.cos((float)(f * 0.3662f + (float)Math.PI)) * f1 / 2.0f;
        this.monsterarm2.yRot = Mth.cos((float)(f * 0.3662f + (float)Math.PI)) * f1 / 2.0f;
        this.arm1.xRot = 30.0f;
        this.arm2.xRot = 30.0f;
        this.arm2.xRot -= Mth.cos((float)(f2 * 0.04f)) * 0.04f + 0.04f;
        this.arm1.xRot += Mth.cos((float)(f2 * 0.04f)) * 0.04f + 0.04f;
    }
}

