/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.cheeseboss;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.st0x0ef.stellaris.client.renderers.entities.cheeseboss.CheeseBossAnim;
import com.st0x0ef.stellaris.common.entities.CheeseBoss;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CheeseBossModel<T extends CheeseBoss>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stellaris", "cheese_boss"), "main");
    private final ModelPart CheeseBoss;
    private final ModelPart Head;

    public CheeseBossModel(ModelPart root) {
        this.CheeseBoss = root.getChild("CheeseBoss");
        this.Head = this.CheeseBoss.getChild("Body").getChild("Head");
    }

    public ModelPart root() {
        return this.CheeseBoss;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition CheeseBoss2 = partdefinition.addOrReplaceChild("CheeseBoss", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Body = CheeseBoss2.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(0, 0).addBox(-9.0f, -23.0f, -4.0f, 18.0f, 23.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-27.0f, (float)0.0f));
        PartDefinition cube_r1 = Body.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(70, 63).addBox(-4.0f, -38.0f, -4.0f, 13.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)15.0f, (float)27.0f, (float)-17.0f, (float)-0.288f, (float)-0.103f, (float)-0.3341f));
        PartDefinition cube_r2 = Body.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(112, 51).addBox(-15.0f, -38.0f, -6.0f, 10.0f, 0.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-23.0f, (float)27.0f, (float)-17.0f, (float)-0.2451f, (float)0.1841f, (float)0.6318f));
        PartDefinition cube_r3 = Body.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(28, 79).mirror().addBox(-5.75f, -5.0f, -5.0f, 12.0f, 12.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-9.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition Head = Body.addOrReplaceChild("Head", CubeListBuilder.create().texOffs(36, 63).addBox(-5.0f, -9.0f, -4.0f, 10.0f, 9.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-23.0f, (float)0.0f));
        PartDefinition cube_r4 = Head.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(0, 51).mirror().addBox(0.0f, -45.0f, -6.0f, 0.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-11.0f, (float)26.0f, (float)5.0f, (float)0.1309f, (float)0.0f, (float)0.3491f));
        PartDefinition cube_r5 = Head.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(0, 51).addBox(0.0f, -45.0f, -6.0f, 0.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)11.0f, (float)26.0f, (float)5.0f, (float)0.1309f, (float)0.0f, (float)-0.3491f));
        PartDefinition cube_r6 = Head.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(54, 79).addBox(-3.0f, -32.0f, -1.0f, 3.0f, 14.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.offsetAndRotation((float)2.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition cube_r7 = Head.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(54, 79).mirror().addBox(0.0f, -32.0f, -1.0f, 3.0f, 14.0f, 4.0f, new CubeDeformation(0.5f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)19.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition ShoulderL = Body.addOrReplaceChild("ShoulderL", CubeListBuilder.create(), PartPose.offset((float)9.0f, (float)-19.0f, (float)3.0f));
        PartDefinition cube_r8 = ShoulderL.addOrReplaceChild("cube_r8", CubeListBuilder.create().texOffs(100, 34).mirror().addBox(-1.0f, -44.0f, -12.0f, 0.0f, 17.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)26.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3054f));
        PartDefinition cube_r9 = ShoulderL.addOrReplaceChild("cube_r9", CubeListBuilder.create().texOffs(50, 0).mirror().addBox(-6.0f, -6.0f, -5.0f, 15.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition ArmL = ShoulderL.addOrReplaceChild("ArmL", CubeListBuilder.create().texOffs(0, 34).mirror().addBox(-4.0f, -3.0f, -4.0f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)7.0f, (float)3.0f, (float)-3.0f));
        PartDefinition LowerArmL = ArmL.addOrReplaceChild("LowerArmL", CubeListBuilder.create().texOffs(0, 79).mirror().addBox(-3.0f, 7.0f, -4.0f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.5f)).mirror(false).texOffs(0, 43).mirror().addBox(-3.0f, 0.0f, -4.0f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-1.0f, (float)8.0f, (float)0.0f));
        PartDefinition cube_r10 = LowerArmL.addOrReplaceChild("cube_r10", CubeListBuilder.create().texOffs(64, 34).mirror().addBox(-4.5f, -4.0f, -5.5f, 8.0f, 8.0f, 10.0f, new CubeDeformation(-0.5f)).mirror(false), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition ShoulderR = Body.addOrReplaceChild("ShoulderR", CubeListBuilder.create(), PartPose.offset((float)-9.0f, (float)-19.0f, (float)0.0f));
        PartDefinition cube_r11 = ShoulderR.addOrReplaceChild("cube_r11", CubeListBuilder.create().texOffs(50, 0).addBox(-9.0f, -6.0f, -5.0f, 15.0f, 12.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        PartDefinition cube_r12 = ShoulderR.addOrReplaceChild("cube_r12", CubeListBuilder.create().texOffs(100, 34).addBox(1.0f, -44.0f, -12.0f, 0.0f, 17.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)26.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.3054f));
        PartDefinition ArmR = ShoulderR.addOrReplaceChild("ArmR", CubeListBuilder.create().texOffs(0, 34).addBox(-3.0f, -3.0f, -4.0f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-7.0f, (float)3.0f, (float)0.0f));
        PartDefinition LowerArmR = ArmR.addOrReplaceChild("LowerArmR", CubeListBuilder.create().texOffs(0, 79).addBox(-4.0f, 7.0f, -4.0f, 7.0f, 5.0f, 7.0f, new CubeDeformation(0.5f)).texOffs(0, 43).addBox(-4.0f, 0.0f, -4.0f, 7.0f, 12.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)8.0f, (float)0.0f));
        PartDefinition cube_r13 = LowerArmR.addOrReplaceChild("cube_r13", CubeListBuilder.create().texOffs(64, 34).addBox(-3.5f, -4.0f, -5.5f, 8.0f, 8.0f, 10.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition LegL = CheeseBoss2.addOrReplaceChild("LegL", CubeListBuilder.create().texOffs(98, 0).mirror().addBox(-7.9118f, 0.9583f, -4.0f, 7.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)9.0f, (float)-29.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition cube_r14 = LegL.addOrReplaceChild("cube_r14", CubeListBuilder.create().texOffs(28, 34).mirror().addBox(-4.5f, -4.0f, -5.5f, 8.0f, 8.0f, 10.0f, new CubeDeformation(-0.5f)).mirror(false), PartPose.offsetAndRotation((float)-4.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition cube_r15 = LegL.addOrReplaceChild("cube_r15", CubeListBuilder.create().texOffs(110, 63).addBox(-6.0f, 2.0f, -5.0f, 8.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5236f));
        PartDefinition LowerLegL = LegL.addOrReplaceChild("LowerLegL", CubeListBuilder.create(), PartPose.offset((float)-4.5f, (float)12.5f, (float)0.0f));
        PartDefinition cube_r16 = LowerLegL.addOrReplaceChild("cube_r16", CubeListBuilder.create().texOffs(98, 10).mirror().addBox(1.5f, -17.0f, -4.0f, 7.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 63).mirror().addBox(0.5f, -9.0f, -5.0f, 9.0f, 6.0f, 9.0f, new CubeDeformation(-0.5f)).mirror(false), PartPose.offsetAndRotation((float)-5.5f, (float)15.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition LegR = CheeseBoss2.addOrReplaceChild("LegR", CubeListBuilder.create().texOffs(98, 0).mirror().addBox(1.0f, 1.0f, -4.0f, 7.0f, 10.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-9.0f, (float)-29.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition cube_r17 = LegR.addOrReplaceChild("cube_r17", CubeListBuilder.create().texOffs(110, 63).mirror().addBox(-2.0f, 2.0f, -5.0f, 8.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        PartDefinition cube_r18 = LegR.addOrReplaceChild("cube_r18", CubeListBuilder.create().texOffs(28, 34).addBox(-3.5f, -4.0f, -5.5f, 8.0f, 8.0f, 10.0f, new CubeDeformation(-0.5f)), PartPose.offsetAndRotation((float)4.0f, (float)11.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition LowerLegR = LegR.addOrReplaceChild("LowerLegR", CubeListBuilder.create(), PartPose.offsetAndRotation((float)4.5f, (float)12.5f, (float)0.0f, (float)0.0436f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r19 = LowerLegR.addOrReplaceChild("cube_r19", CubeListBuilder.create().texOffs(0, 63).addBox(-9.5f, -9.0f, -5.0f, 9.0f, 6.0f, 9.0f, new CubeDeformation(-0.5f)).texOffs(98, 10).addBox(-8.5f, -17.0f, -4.0f, 7.0f, 17.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)5.5f, (float)15.4564f, (float)0.001f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.applyHeadRotation(netHeadYaw, headPitch);
        this.animateWalk(CheeseBossAnim.walking, limbSwing, limbSwingAmount, 4.1f, 2.5f);
        this.animate(((CheeseBoss)((Object)entity)).idleAnimationState, CheeseBossAnim.idle, ageInTicks, 1.0f);
    }

    private void applyHeadRotation(float netHeadYaw, float headPitch) {
        netHeadYaw = Mth.clamp((float)netHeadYaw, (float)-30.0f, (float)30.0f);
        headPitch = Mth.clamp((float)headPitch, (float)-25.0f, (float)45.0f);
        this.Head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.Head.xRot = headPitch * ((float)Math.PI / 180);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.CheeseBoss.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

