/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.client.renderers.entities.vehicle;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.st0x0ef.stellaris.common.entities.IVehicleEntity;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class VehicleRenderer<T extends IVehicleEntity, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    protected final M model;
    protected final List<RenderLayer<T, M>> layers = Lists.newArrayList();

    public VehicleRenderer(EntityRendererProvider.Context context, M model, float shadowRadius) {
        super(context);
        this.model = model;
        this.shadowRadius = shadowRadius;
    }

    public final boolean addLayer(RenderLayer<T, M> p_115327_) {
        return this.layers.add(p_115327_);
    }

    public M getModel() {
        return this.model;
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Entity entity2;
        boolean shouldSit;
        poseStack.pushPose();
        ((EntityModel)this.model).riding = shouldSit = entity.isPassenger() && entity.getVehicle() != null;
        float f = Mth.rotLerp((float)partialTick, (float)((IVehicleEntity)((Object)entity)).yRotO, (float)entity.getYRot());
        float f1 = Mth.rotLerp((float)partialTick, (float)((IVehicleEntity)((Object)entity)).yRotO, (float)entity.getYRot());
        float f2 = f1 - f;
        if (shouldSit && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity2;
            f = Mth.rotLerp((float)partialTick, (float)livingentity.yBodyRotO, (float)livingentity.yBodyRot);
            f2 = f1 - f;
            float f3 = Mth.wrapDegrees((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.lerp((float)partialTick, (float)((IVehicleEntity)((Object)entity)).xRotO, (float)entity.getXRot());
        float f7 = this.getBob(entity, partialTick);
        this.setupRotations(entity, poseStack, f7, f, partialTick);
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        this.scale(entity, poseStack, partialTick);
        poseStack.translate(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        this.model.prepareMobModel(entity, f5, f8, partialTick);
        this.model.setupAnim(entity, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.getInstance();
        boolean flag = this.isBodyVisible(entity);
        boolean flag1 = !flag && !entity.isInvisibleTo((Player)minecraft.player);
        boolean flag2 = minecraft.shouldEntityAppearGlowing(entity);
        RenderType rendertype = this.getRenderType(entity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = buffer.getBuffer(rendertype);
            int i = VehicleRenderer.getOverlayCoords(entity, this.getWhiteOverlayProgress(entity, partialTick));
            this.model.renderToBuffer(poseStack, vertexconsumer, packedLight, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!entity.isSpectator()) {
            for (RenderLayer<T, M> renderlayer : this.layers) {
                renderlayer.render(poseStack, buffer, packedLight, entity, f5, f8, partialTick, f7, f2, f6);
            }
        }
        poseStack.popPose();
        super.render(entity, entityYaw, partialTick, poseStack, buffer, packedLight);
    }

    @Nullable
    protected RenderType getRenderType(T entity, boolean p_115323_, boolean p_115324_, boolean p_115325_) {
        ResourceLocation resourcelocation = this.getTextureLocation((Entity)entity);
        if (p_115324_) {
            return RenderType.itemEntityTranslucentCull((ResourceLocation)resourcelocation);
        }
        if (p_115323_) {
            return this.model.renderType(resourcelocation);
        }
        return p_115325_ ? RenderType.outline((ResourceLocation)resourcelocation) : null;
    }

    protected boolean isBodyVisible(T p_115341_) {
        return !p_115341_.isInvisible();
    }

    protected boolean isShaking(T p_115304_) {
        return false;
    }

    public static int getOverlayCoords(Entity p_115339_, float p_115340_) {
        return OverlayTexture.pack((int)OverlayTexture.u((float)p_115340_), (int)OverlayTexture.v((boolean)false));
    }

    protected float getWhiteOverlayProgress(T p_115334_, float p_115335_) {
        return 0.0f;
    }

    protected void setupRotations(T entity, PoseStack poseStack, float p_115319_, float p_115320_, float p_115321_) {
        if (this.isShaking(entity) && !Minecraft.getInstance().isPaused()) {
            double shakeDirection1 = p_115321_ * (float)(entity.level().random.nextBoolean() ? 1 : -1) / 50.0f;
            double shakeDirection2 = p_115321_ * (float)(entity.level().random.nextBoolean() ? 1 : -1) / 50.0f;
            double shakeDirection3 = p_115321_ * (float)(entity.level().random.nextBoolean() ? 1 : -1) / 50.0f;
            poseStack.translate(shakeDirection1, shakeDirection2, shakeDirection3);
        }
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - p_115320_));
    }

    protected float getBob(T p_115305_, float p_115306_) {
        return (float)((IVehicleEntity)((Object)p_115305_)).tickCount + p_115306_;
    }

    protected void scale(T p_115314_, PoseStack p_115315_, float p_115316_) {
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return livingEntity != null && camera.isVisible(livingEntity.getBoundingBoxForCulling());
    }
}

